#include <stdio.h> //for debugging

#include <stdlib.h>

#include <qtimer.h>
#include <qapplication.h>
#include <qwmatrix.h>

#include "QwPrinterSpriteFieldView.h"

#include "kpstext.h"
#include "kpswhatami.h"

#include "kputil.h"

#include "kpview.moc"

KPView::KPView (QwSpriteField *_field,
		QWidget *parent, char *name) : 
  QwSpriteFieldView (_field, parent, name, WStyle_NoBorder)
{
  grabbed_sprite=0;
  qfield = _field;

  aspect = 2./(sqrt (5) + 1); //Golden Landscape, h:w

  focus_sprite=0;

  qtresize = new QTimer;
  connect ( qtresize, SIGNAL (timeout()),
	    SLOT (slotResize()) );

  qpmresize= new QPixmap (10,10);
  qpmresize->fill();

  qwresize=0;
  qrresize = new QResizeEvent (QSize(0,0), QSize (0,0));

  refwidth = .45*QApplication::desktop()->width();

  busermaneuver=FALSE;

  rmb=0;
  zoomtool=zoomrect=zoomsel=FALSE;

  //QwSpriteFIeld's all() doesn't seem to work
  // if there are no objects...
  KPSText *safe;
  safe = new KPSText (this, "", -1, -1);
  
  bobj = false;
}

void
KPView::zoomTool (bool on)
{
  printf ("ZOOM is (%d)\n",on);
  zoomtool = on;
  if (!zoomtool)
    zoomrect=zoomsel=FALSE; //sometimes things don't register...

}

void
KPView::mousePressEvent (QMouseEvent *m)
{
  if (zoomtool && m->button()==LeftButton)
    {
      printf ("Z&LB\n");
      zoomstart = m->pos();
      zoomsel = TRUE;
    }
  else
    {
      printf ("NOT(Z&LB)\n");
      
      Pix p = qfield->topAt (m->x(), m->y());
      
      if (p==0)
	{
	  printf ("no object\n");
	  if (focus_sprite)
	    {
	      focus_sprite->setSelected (FALSE);
	      focus_sprite=0;
	      update();
	    }
	  
	  qfield->end (p);
	  
	  if (m->button()==RightButton && rmb)
	    rmb->exec(QCursor::pos());
	  
	  bobj = false;
	  return;
	}
      printf ("objectA\n");
      
      bobj = true;
      

      if ( qfield->exact (p) )
	{
	  //      printf ("exact\n");
	  grabbed_sprite = (KPSprite *)qfield->at(p);
	  
	  offsetx = grabbed_sprite->x() - m->x();
	  offsety = grabbed_sprite->y() - m->y();
	  
	  QMouseEvent m2 ( QEvent::MouseButtonPress,
			   QPoint (offsetx, offsety),
			   m->button(), m->state());
	  
	  grabbed_sprite->mousePressEvent (&m2);
	  
	  if (focus_sprite)
	    focus_sprite->setSelected (FALSE);
	  focus_sprite = grabbed_sprite;
	  focus_sprite->setSelected ();
	  update();
	  
	  if (! (grabbed_sprite->movableX() ||
		 grabbed_sprite->movableY()) )
	    grabbed_sprite=0;  //we don't really want to grab it
	}
      
      qfield->end(p);
    }
  
  if (emitMMsignals)
    emit mouseAt ( m->pos().x(), m->pos().y() );
}

void
KPView::mouseMoveEvent ( QMouseEvent *m )
{
  if (zoomsel)
    {
      QPainter p(this);
      p.setPen (DashLine);
      p.setRasterOp (NotROP);
      if (zoomrect)
	p.drawRect (zoomstart.x(), zoomstart.y(),
		    zoomend.x()-zoomstart.x(), 
		    zoomend.y()-zoomstart.y());
      
      zoomend = m->pos();
      p.drawRect (zoomstart.x(), zoomstart.y(),
		  zoomend.x()-zoomstart.x(), 
		  zoomend.y()-zoomstart.y());
      zoomrect=TRUE;
      p.end();
    }
  else
    {
      if (!bobj)
	return;


      int newx, newy;
      
      busermaneuver=TRUE;
      
      if (grabbed_sprite!=0)
	{
	  if (grabbed_sprite->movableX())
	    newx = offsetx + m->x();
	  else
	    newx = grabbed_sprite->x();
	  
	  if (grabbed_sprite->movableY())
	    newy = offsety + m->y();
	  else
	    newy = grabbed_sprite->y();
	  
	  grabbed_sprite->moveTo (newx, newy);
	  update();
	}
      
      busermaneuver=FALSE;
    }

  if (emitMMsignals)
    emit mouseAt ( m->pos().x(), m->pos().y() );

}

void
KPView::mouseReleaseEvent ( QMouseEvent *m )
{

  if (!zoomsel)
    {
      grabbed_sprite=0; //not dragging any more
      
      Pix p = qfield->topAt (m->x(), m->y());
      
      if (p==0)
	{
	  //      printf ("no object\n");
	  qfield->end (p);
	  return;
	}
      //  printf ("object\n");
      
      if ( qfield->exact (p) )
	{
	  KPSprite *t = (KPSprite *)qfield->at(p);
	  
	  offsetx = t->x() - m->x();
	  offsety = t->y() - m->y();
	  
	  QMouseEvent m2 ( QEvent::MouseButtonPress,
			   QPoint (offsetx, offsety),
			   m->button(), m->state());

	  t->mouseReleaseEvent (&m2);
	}
      
      qfield->end(p);
    }
  else
    {
      QPainter p (this);
      p.setPen (DashLine);
      p.setRasterOp (XorROP);
      if (zoomrect)
	{
	  p.drawRect (zoomstart.x(), zoomstart.y(),
		      zoomend.x()-zoomstart.x(), 
		      zoomend.y()-zoomstart.y());
	  zoomrect=FALSE;
	}
      zoomsel=FALSE;
      p.end();
      emit zoomedRect ( QRect(kpmin (zoomstart.x(), zoomend.x()),
			      kpmin (zoomstart.y(), zoomend.y()),
			      abs (zoomend.x()-zoomstart.x()), 
			      abs (zoomend.y()-zoomstart.y())) );
    }
  
  if (emitMMsignals)
    emit mouseAt ( m->pos().x(), m->pos().y() );
}

void
KPView::resizeEvent (QResizeEvent *r)
{
  if (qpmresize==0)
    {
      qpmresize = new QPixmap (r->oldSize());

      QRect qrfrom (QPoint (0,0), r->oldSize());

      bitBlt (qpmresize, QPoint (0,0), this,
	      qrfrom, CopyROP);

    }

  if (qwresize == 0)
    {
      qwresize = new QWidget (this);
      qwresize->show();
    }

  //perform scaling opeation here
  QWMatrix scale;
  scale.scale ( r->size().width()/(double)qpmresize->rect().width(),
		r->size().height()/(double)qpmresize->rect().height());
  QPixmap qpmnew;
  qpmnew = qpmresize->xForm (scale);
  *qpmresize = qpmnew;



  qwresize->resize (r->size());
  *qrresize = *r;

  bitBlt (qwresize, QPoint (0,0), qpmresize,  
	  qpmresize->rect(), CopyROP);

  qtresize->start (250, TRUE);
}


KPView::~KPView()
{
  delete qtresize;
  delete qrresize;
}


void
KPView::slotResize ()
{
  KPSprite *t;

  qfield->resize (qrresize->size().width(),
 		  qrresize->size().height());


  int cnt=0;
  for (Pix p=qfield->all(); p; qfield->next(p))
    cnt++;
  //  printf ("%d sprite(s)\n",cnt);

  if (cnt>1)
    for (Pix p=qfield->all(); p; qfield->next(p))
      {
	t = (KPSprite *)qfield->at(p);
	if (t->whatami()!=0)
	  t->resizeEvent (qrresize);
      }
  

  delete qpmresize;
  delete qwresize;
  qpmresize=0;
  qwresize=0;

  update();
}


/*
  //If we want it later, we'll uncomment it.

void
KPView::polish()
{
  KPSprite *t;
  
  for (Pix p=qfield->all(); p; qfield->next(p))
    {
      t = (KPSprite *)qfield->at(p);
      t->creationEvent ();
      t->setRect();
    }
}

*/

void
KPView::installRMBMenu (QPopupMenu *menu)
{
  rmb = menu;
}

void
KPView::printDraft (void)
{

  if (focus_sprite)
    focus_sprite->setSelected (FALSE);

  QwPrinterSpriteFieldView printer;

  if (aspectRatio()<1)
    printer.setOrientation (QPrinter::Landscape);
  else
    printer.setOrientation (QPrinter::Portrait);
  
  printer.setPageSize (QPrinter::Letter);

  if (printer.setup())
    printer.printAll (field());

  if (focus_sprite)
    focus_sprite->setSelected (TRUE);

}


///Later this will take a QPrinter as an argument which has all of
//  its options already set.
void
KPView::print (void)
{

  if (focus_sprite)
    focus_sprite->setSelected (FALSE);

  QwPrinterSpriteFieldView printer;

  if (aspectRatio()<1)
    printer.setOrientation (QPrinter::Landscape);
  else
    printer.setOrientation (QPrinter::Portrait);

  printer.setPageSize (QPrinter::Letter);
  
  KPSprite *t;
  for (Pix p=qfield->all(); p; qfield->next(p))
    {
      t = (KPSprite *)qfield->at(p);
      t->doPostscript ();
    }
  

  if (printer.setup())
    printer.printAll (field());

  if (focus_sprite)
    focus_sprite->setSelected (TRUE);

  for (Pix p=qfield->all(); p; qfield->next(p))
    {
      t = (KPSprite *)qfield->at(p);
      t->doPostscript (FALSE);
    }
}

void
KPView::spriteLeaving (KPSprite *s)
{
  bool up=FALSE;

  if (s == focus_sprite)
    {
      focus_sprite = 0;
      up=TRUE;
    }
  if (s == grabbed_sprite)
    {
      grabbed_sprite = 0;
      up=TRUE;
    }

  if (up)
    update();
}

void
KPView::setEmitMouseMove (bool enable)
{
  emitMMsignals=enable;

  /*
    // I like it better w/o mouse tracking right now
  if (enable)
    setMouseTracking (TRUE);
  else
    setMouseTracking (FALSE);
  */
}
