/***************************************************************************
                          abicondialog.cpp  -  description
                             -------------------
    begin                : Tue Aug 15 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "abicondialog.h"

#include <qstringlist.h>
#include <qfileinfo.h>
#include <kiconloader.h>

ABIconDialog::ABIconDialog(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	view = new KIconView(this);
	QComboBox_1 -> insertItem(i18n("MimeType"));
	QComboBox_1 -> insertItem(i18n("Action"));
	QComboBox_1 -> insertItem(i18n("Application"));
	QComboBox_1 -> insertItem(i18n("Device"));
	QComboBox_1 -> insertItem(i18n("FileSystem"));
	connect(QComboBox_1, SIGNAL(activated(const QString&)), SLOT(slotActivated(const QString&)));
	connect(QPushButton_2, SIGNAL(clicked()), SLOT(slotCancel()));
	connect(view,SIGNAL(selectionChanged(QIconViewItem*)), SLOT(slotSelectionChanged(QIconViewItem*)));
	init();	
	icn = QString::null;
}

ABIconDialog::~ABIconDialog(){
}

void ABIconDialog::init(){
	view -> setGeometry(10,10,380,200);
	view -> setGridX(50);
	view -> setGridY(40);
	slotActivated("MimeType");
}

void ABIconDialog::slotActivated(const QString &s){
	KIconLoader l;
	QFileInfo fi;
	QStringList lst;
	if (s == i18n("MimeType"))
		lst = l.queryIcons(KIcon::Small, KIcon::MimeType);
	if (s == i18n("Action"))
		lst = l.queryIcons(KIcon::Small, KIcon::Action);
	if (s == i18n("Application"))
		lst = l.queryIcons(KIcon::Small, KIcon::Application);
	if (s == i18n("Device"))
		lst = l.queryIcons(KIcon::Small, KIcon::Device);
	if (s == i18n("FileSystem"))
		lst = l.queryIcons(KIcon::Small, KIcon::FileSystem);

	view -> clear();
	for (unsigned int i = 0; i < lst.count(); i++){
		fi = QFileInfo(*lst.at(i));
		new QIconViewItem(view,	fi.baseName(), *lst.at(i));	
	}
}

void ABIconDialog::slotSelectionChanged(QIconViewItem* i){
	icn = i -> text();
	this -> hide();
}

void ABIconDialog::slotCancel(){
	this -> hide();
}
