/***************************************************************************
                          batch.h  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCH_H
#define BATCH_H

#include "abprocess.h"
#include <qfile.h>
#include <qtextstream.h>
#include "filegroupext.h"

/**
  *@author Arjan Buursink
  */

class Batch : public QObject {
	Q_OBJECT
public: 
	Batch(bool);
	~Batch();
	void start();
	void startProcess(bool);
	void append(ABProcess *, FileGroupBase *);
	QList<ABProcess> * procList;
	QList <FileGroupBase> * groupList;
	/**
	* Returns true if an error has occured.
	*/
	bool error();
	unsigned int count() { return procList -> count(); };
	ABProcess * process(int i) { return procList -> at(i); };
	FileGroupBase * group(int i) { return groupList -> at(i); };
	void cancel();
	void setContinueAfterError(bool b){cont = b;};
	bool continueAfterError(){ return cont;};
private:
	unsigned int cntr;
	/**
	* This variable is set in the constructor. False means that during batch process the parent process is
	* blocked until the batch has ended
	*/
	bool gui;
	QFile file;
	QTextStream log;
	bool cont;
private slots:
	void slotCont();
signals:
	void batchExited();	
	void processExited();
};

#endif
