/***************************************************************************
                          filegroupbase.h  -  description
                             -------------------
    begin                : Wed Dec 29 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEGROUPBASE_H
#define FILEGROUPBASE_H

#include<qfileinfo.h>
#include<qstring.h>
#include <qstrlist.h>

#include <abprocess.h>

enum grouptype {TYPE_UDG,TYPE_RPM, TYPE_INS, TYPE_TGZ, TYPE_DBL};
enum infotag {INFO_NAME, INFO_VERSION, INFO_DESCRIPTION, INFO_RELEASE};

/**
  *@author Arjan Buursink
  */
class FileGroupBase : public QObject
{
	Q_OBJECT
public:
	/**
	 * Creates a File group. A File Group consists of a list of files which has some specific
	 * file features.
	 */
	FileGroupBase();
	/**
	 * The destructor.
	 */
	~FileGroupBase();
	/**
	 *	Adds a file to the group. No check is performed if file is already in the group!
	 */
	void addFile(QString);
	void addDir(QString);
	void removeFile(const unsigned int);
	/**
	 * Sets the safety level of the group
	 */
	void setSafetyLevel(int s) {slvl = s;};
	/**
	 * Returns the nuber of bytes in the group.
	 */
	virtual unsigned int totalSize();
	/**
	 * Returns the number of files.
	 */
	unsigned int numFiles() {return nf;};
	unsigned int numDirs() {return nd;};
	/**
	 * Sets the name of the group.
	 */
	void setName(QString s) {nm = s;};	
	/**
	 * Returns the name of the group.
	 */
	QString name(){return nm;};
	/**
	 * Sets the description of the FileGroup.
	 */
	void setDescription(QString s);
	/**
	 * Returns file i
	*/
	QString file(unsigned int);
	QString dir(unsigned int);
	void unloadFiles();
	unsigned int file(QString);
	unsigned int dir(QString);
	bool fileMark(unsigned int);
	void setFileMark(unsigned int, bool);
	void setAutoCleanUp(bool b){autocleanup = b;};
	QString description();
	void setIcon(QString s){icn = s;};
	QString icon(){return icn;};
	unsigned int safetyLevel() {return slvl;};
	QStrList * permanent;
	bool containsFile(QString);
	bool containsDir(QString);
	void addPermanentFiles();
	virtual unsigned int sizeGreen();
	bool isSafe(QString);
	unsigned int sizeMarked();
	unsigned int numMarked();
	void markAll();
	void unMarkAll();
	void markGreen();
	unsigned int numGreen();
	bool isMarked() {return m;};
	void setMarked(bool b) { m = b;};
	grouptype type(){return tp;};
	void setType(grouptype t){ tp = t;};
	virtual QString info(infotag);
	virtual void loadFiles() {};
	void condLoad();
	void clearMem();
	virtual ABProcess* unInstall() {return 0;};
	void addFileFast(QString);
	void sync();
private:
	QStrList * fileList, * dirList;
	QList<bool> * fileMarkList, * dirMarkList;
	QString nm;
	QString icn;
	QString descr;
	unsigned int totsize, slvl, nf, nd;
	bool autocleanup;
	bool m;
	grouptype tp;
};


#endif
