/***************************************************************************
                          uninstalldialog.cpp  -  description
                             -------------------
    begin                : Wed Nov 22 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "uninstalldialog.h"
#include "qlistbox.h"
#include <kmessagebox.h>

UninstallDialog::UninstallDialog(GroupManager * gm) : UninstallDialogBase(0,0,true){
	groupManager = gm;
	for (unsigned int i = 0; i < groupManager -> count(TYPE_RPM); i++)
		if (groupManager -> rpm(i) -> isMarked())
			ListBox1 -> insertItem(groupManager -> rpm(i) -> name(),-1);
	for (unsigned int i = 0; i < groupManager -> count(TYPE_INS); i++)
			if (groupManager -> ins(i) -> isMarked())
				ListBox1 -> insertItem(groupManager -> ins(i) -> name(),-1);
}

UninstallDialog::~UninstallDialog(){
}

void UninstallDialog::accept(){
	counter = 0;
	batch = new Batch(true);
	batch -> setContinueAfterError(true);
	batchProgress = new QueryProgress_2();
	batchProgress -> show();
	unsigned int steps = 0;
	for (unsigned int i = 0; i < groupManager -> count(TYPE_RPM); i++){
		if (groupManager -> rpm(i) -> isMarked()){
			batch -> append(groupManager -> rpm(i) -> unInstall(),groupManager -> rpm(i));
			steps++;
		}
	}
	for (unsigned int i = 0; i < groupManager -> count(TYPE_INS); i++){
		if (groupManager -> ins(i) -> isMarked()){
			batch -> append(groupManager -> ins(i) -> unInstall(),groupManager -> ins(i));
			steps++;
		}
	}
	batchProgress -> QProgressBar_1 -> setTotalSteps(steps);
	connect(batch, SIGNAL(processExited()), SLOT(slotProcessExited()));
	connect(batch, SIGNAL(batchExited()), SLOT(slotBatchExited()));
	batch -> start();
	setResult(0);
}

void UninstallDialog::reject(){
	setResult(-1);
	hide();
}

void UninstallDialog::slotProcessExited(){
	counter++;
	batchProgress -> QProgressBar_1 -> setProgress(counter);
}

void UninstallDialog::slotBatchExited(){
	batchProgress -> hide();
	QString s1;
	unsigned int cntr = 0;
	s1 += i18n("The next packages were succesful removed:\n");
	for (unsigned int i = 0; i < batch -> count(); i++){
		if (batch -> process(i) -> error().isEmpty()){
			s1+= batch -> group(i) -> name();
			s1+= "\n";
			cntr++;
		}
	}
	if (cntr == 0){
		s1 += i18n("none");
		s1 += "\n";
	}
	s1 += "\n";
	cntr = 0;
	QString s2;
	s2 += i18n("The following problems were encountered:\n");
	for (unsigned int i = 0; i < batch -> count(); i++){
		if (!batch -> process(i) -> error().isEmpty()){
			s2 += i18n("Process: ");
			s2 += batch -> group(i) -> name();
	    s2 += "\n";
			s2 += i18n("Error: ");
			s2 += batch -> process(i) -> error();
			cntr++;
		}
	}
	if (cntr > 0)
  	s1 += s2;
	KMessageBox::information(0,s1);
	hide();
}

