/***************************************************************************
                          kdlgmanager1.cpp  -  description
                             -------------------
    begin                : Wed Sep 6 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.10 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <kfiledialog.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include "ktmanager.h"
#include "kdlgmanager1.h"

KDlgManager1::KDlgManager1(KTManager m, QWidget *parent, 
			   const char *name) : QWidget(parent,name) {
  mngr = m;
  initDialog();
  init();
}

KDlgManager1::~KDlgManager1(){
}

/** close the dialog accepting the data */
void KDlgManager1::accept(){
  int maxband = QString(lneMaxBand->text()).toInt();
  int maxconn = QString(lneMaxConn->text()).toInt();
  mngr.setAutoDownload(cbtAutoDownload->isChecked());
  mngr.setAutoRemove(cbtRemoveCompleted->isChecked());
  mngr.setMaxBandwidth(maxband);
  mngr.setMaxConnection(maxconn);
  mngr.setPriority(QString(lnePriority->text()).toInt());
  mngr.setDefaultType(_typeList[cmbType->currentItem()]);
#ifndef KURLREQ_ERR
  mngr.setDownloadDir(cmbDDir->url());
  mngr.setWorkingDir(cmbWDir->url());
  mngr.setLogFile(cmbLog->url());
#else
  mngr.setDownloadDir(lneDDir->text());
  mngr.setWorkingDir(lneWDir->text());
  mngr.setLogFile(lneLog->text());
#endif
  //mngr->update();
}

/** init the widgets state */
void KDlgManager1::init() {
  cbtAutoDownload->setChecked(mngr.getAutoDownload());
  cbtRemoveCompleted->setChecked(mngr.getAutoRemove());
  lneMaxBand->setText(QString::number(mngr.getMaxBandwidth()));
  lneMaxConn->setText(QString::number(mngr.getMaxConnection()));
  lnePriority->setText(QString::number(mngr.getPriority()));
#ifndef KURLREQ_ERR
  cmbDDir->setURL(mngr.getDownloadDir().absPath());
  cmbWDir->setURL(mngr.getWorkingDir().absPath());
  cmbLog->setURL(mngr.getLogFile());
#else
  lneDDir->setText(mngr.getDownloadDir().absPath());
  lneWDir->setText(mngr.getWorkingDir().absPath());
  lneLog->setText(mngr.getLogFile());
#endif
  cmbType->clear();
  _typeList.clear();
  KObject::List lst = mngr.globals();
  for (KObject::List::Iterator i = lst.begin(); i != lst.end(); ++i) {
    cmbType->insertItem(KObject::typeStr((*i).type()));
    _typeList += (*i).type();
  }
  cmbType->setCurrentItem(_typeList.findIndex(mngr.getDefaultType()));
}

void  KDlgManager1::initDialog(){

  QBoxLayout *l = new QVBoxLayout(this, 8);

  QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("Automation"), this,
				  "GrbAutomation");
  l->addWidget(gbox);

  cbtAutoDownload= new QCheckBox(gbox, "CbtAutoDownload");
  QToolTip::add(cbtAutoDownload,
		i18n("Enable automatic downloading of transfers"));
  cbtAutoDownload->setText(i18n("Automatic downloading"));
  
  cbtRemoveCompleted= new QCheckBox(gbox, "CbtRemoveCompleted");
  QToolTip::add(cbtRemoveCompleted,
		i18n("Automatic removing of completed transfers"));
  cbtRemoveCompleted->setText(i18n("Remove completed transfers"));

  QHBox * box = new QHBox(gbox);
  QLabel *lbl = new QLabel(i18n("Default Transfer Type"), box, "LblType");
  cmbType= new KComboBox(box, "CmbType");
  box->setStretchFactor(lbl, 5);
  box->setStretchFactor(cmbType, 1);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Priority"), box, "NoName");
  lnePriority= new QLineEdit(box,"LnePriority");
  lnePriority->setFixedWidth(lnePriority->fontMetrics().width("XXXXX"));
  QToolTip::add(lnePriority, i18n("Transfer's default priority"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lnePriority, 0);

  gbox = new QGroupBox(1, Horizontal, i18n("Limits"), this, "GrbLimits");
  l->addWidget(gbox);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Max Open Transfers"), box,"LblMaxConn");
  lneMaxConn= new QLineEdit(box,"LneMaxConn");
  lneMaxConn->setFixedWidth(lneMaxConn->fontMetrics().width("XXXXX"));
  QToolTip::add(lneMaxConn,i18n("Maximum number of running transfers"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneMaxConn, 0);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Max Bandwidth (BPS)"), box,"LblMaxBand");
  lneMaxBand= new QLineEdit("XXXXXX", box, "LneMaxBand");
  lneMaxBand->setFixedWidth(lneMaxBand->fontMetrics().width("XXXXXXXX"));
  QToolTip::add(lneMaxBand,i18n("Maximum bandwidth allowed in BPS"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneMaxBand, 0);

  gbox = new QGroupBox(3, Horizontal, i18n("Directory & Files"), this, "grpDir");
  l->addWidget(gbox);

  lbl = new QLabel(i18n("Download Dir"), gbox, "lblDDir");

#ifndef KURLREQ_ERR
  cmbDDir = new KURLRequester(gbox, "CmbDDir");
  KFile::Mode mode = static_cast<KFile::Mode>(KFile::Directory|KFile::ExistingOnly | KFile::LocalOnly);
  cmbDDir->fileDialog()->setMode(mode);
  cmbDDir->fileDialog()->setKeepLocation(true);
  QToolTip::add(cmbDDir,i18n("Path of directory storing downloaded files"));
#else
  lneDDir = new QLineEdit(gbox, "LneDDir");
  btnDDir = new QPushButton(SmallIcon("fileopen"), QString::null, gbox, "BtnDDir");
  QToolTip::add(lneDDir,i18n("Path of directory storing downloaded files"));
  connect(btnDDir, SIGNAL(clicked()), this, SLOT(slotOpenDDir()));
#endif

  lbl = new QLabel(i18n("Working Dir"), gbox, "lblWDir");

#ifndef KURLREQ_ERR
  cmbWDir = new KURLRequester(gbox, "CmbWDir");
  mode = static_cast<KFile::Mode>(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly);
  cmbWDir->fileDialog()->setMode(mode);
  cmbWDir->fileDialog()->setKeepLocation(true);
  QToolTip::add(cmbWDir, i18n("Path of directory storing temporary files"));
#else
  lneWDir = new QLineEdit(gbox, "LneWDir");
  btnWDir = new QPushButton(SmallIcon("fileopen"), QString::null, gbox, 
			    "BtnWDir");
  QToolTip::add(lneWDir,i18n("Path of directory storing temporary files"));
  connect(btnWDir, SIGNAL(clicked()), this, SLOT(slotOpenWDir()));
#endif

  lbl = new QLabel(i18n("Log File"), gbox, "lblLog");

#ifndef KURLREQ_ERR
  cmbLog = new KURLRequester(gbox, "CmbLog");
  mode = static_cast<KFile::Mode>(KFile::File | KFile::LocalOnly);
  cmbLog->fileDialog()->setMode(mode);
  cmbLog->fileDialog()->setKeepLocation(true);
  QToolTip::add(cmbLog, i18n("Path of log file"));
#else
  lneLog = new QLineEdit(gbox, "LneLog");
  btnLog = new QPushButton(SmallIcon("fileopen"), QString::null, gbox, "BtnLog");
  QToolTip::add(lneLog,i18n("Path of log file"));
  connect(btnLog, SIGNAL(clicked()), this, SLOT(slotOpenLogFile()));
#endif  
}

/** check if dialog is in an acceptable state */
bool KDlgManager1::isAcceptable(){
  bool check;
  QString(lneMaxBand->text()).toInt(&check);
  if (!check)
    return false;
  QString(lneMaxConn->text()).toInt(&check);
  if (!check)
    return false;
  QString(lnePriority->text()).toInt(&check);
  if (!check)
    return false;
#ifndef KURLREQ_ERR
  QFileInfo d(cmbDDir->url());
#else
  QFileInfo d(lneDDir->text());
#endif
  if (!d.exists() || !d.isDir())
    return false;
#ifndef KURLREQ_ERR
  d = cmbWDir->url();
#else
  d = lneWDir->text();
#endif
  if (!d.exists() || !d.isDir())
    return false;
  return true;
}

#ifdef KURLREQ_ERR
void KDlgManager1::slotOpenDDir() {
  QString dir = lneDDir->text();
  dir = KFileDialog::getExistingDirectory(dir, this, 
					  i18n("Select Download Directory"));
  if (!dir.isEmpty())
    lneDDir->setText(dir);
}

void KDlgManager1::slotOpenWDir() {
  QString dir = lneWDir->text();
  dir = KFileDialog::getExistingDirectory(dir, this, 
					  i18n("Select Working Directory"));
  if (!dir.isEmpty())
    lneWDir->setText(dir);
}

void KDlgManager1::slotOpenLogFile() {
  QString file = lneLog->text();
  file = KFileDialog::getSaveFileName(QDir::currentDirPath(), 
				      QString::null,
				      this, 
				      i18n("Select Log File"));
  if (!file.isEmpty())
    lneLog->setText(file);
}
#endif

#include "kdlgmanager1.moc"
