/***************************************************************************
                          kmmanagerimpl.cpp  -  description
                             -------------------
    begin                : Wed Oct 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.5 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kdebug.h>
#include <qtextstream.h>
#include "utils.h"
#include "ktransferimpl.h"
#include "kfactoryimpl.h"
#include "ktmanagerimpl.h"
#include "kmmanagerimpl.h"

const char KMManagerImpl::DOCID[] = "MManager";
const char KMManagerImpl::MIMETYPE[][50] = { "application/" DOC "-mmanager",
					   "text/x-" DOC "-mmanager" };
const char KMManagerImpl::DOCTYPE[] = "<!DOCTYPE MManager >";


KMManagerImpl::KMManagerImpl(int type) : KContainerImpl(type), _callback(0),
  _needSaving(false) {
}

KMManagerImpl::~KMManagerImpl(){
  kdDebug(D_INI) << name() << ": MManager destroy" << endl;
  kdError(_needSaving, D_INI) << name() << ": destroying unsaved" << endl;
  delete _callback;
}

KObjectImpl * KMManagerImpl::clone() const {
  return new KMManagerImpl(type());
}

void KMManagerImpl::loadData() {
  KContainerImpl::loadData();
  kdDebug(D_INI) << name() << ": MManager loadData" << endl;
  _idCnt = dom().attribute("IdCnt", "1").toInt();
  _bandwidth = 0;
  _mediumBandwidth = 0;
}

void KMManagerImpl::itemChanged(KObjectImpl *item, ModType type, 
				PropMode prop) {
  KContainerImpl::itemChanged(item, type, prop);
  (*_callback)(KObject(item), type);
}

KTManagerImpl * KMManagerImpl::itemNew(const QString &title) {
  QString objDocId = KFactoryImpl::factory()->docId(TYP_TMANAGER);
  QString objTypeStr = KFactoryImpl::factory()->typeStr(TYP_TMANAGER);
  int objId = assignId();
  QString objStrId = 
    QString("%1-%2").arg(objTypeStr).arg(objId);
  kdDebug(D_INI) << name() << ": item new: " << objStrId << endl;
  QDomElement e = domDoc().createElement(objDocId);
  domItems().appendChild(e);
  e.setAttribute("Id", objId);
  e.setAttribute("Name", objStrId);
  e.setAttribute("Type", QString().setNum(TYP_TMANAGER));
  e.setAttribute("ItemType", QString().setNum(TYP_TRANSFER_T));
  e.setAttribute("Title", title);
  return dynamic_cast<KTManagerImpl*>(itemLoad(e));
}

KMManagerImpl * KMManagerImpl::managerLoad(const QString &fileName, 
					   bool createMode,
					   KNotifyChange *cb) {
  QFile file(fileName);
  if (!file.exists() && !createMode) {
    kdDebug(D_INI) << "Document File not Exist" << endl;
    return 0;
  }
  if (!file.open(IO_ReadWrite)) {
    kdDebug(D_INI) << "Document File Open Error" << endl;
    return 0;
  }
  QDomDocument doc(DOC);
  if (file.size() == 0)
    if (createMode) {
      QDomElement e = doc.createElement(DOC);
      doc.appendChild(e);
      /*
      QTextStream(&file) << "<!DOCTYPE " << DOC << " >"
			 << "<!-- document file for kmago -->" << endl
			 << "<" << DOCID << "/>" << endl;
      file.at(0);
      */
    } else {
      kdDebug(D_INI) << "Document File Empty" << endl;
      return 0;
    }
  else if (!doc.setContent(&file)) {
    kdError(D_INI) << "Error in reading document" << endl;
    file.close();
    return 0;
  }
  file.close();
  //FIXME!!!!
  if (doc.doctype().name() != DOC) {
    kdError(D_INI) << "Document type " << doc.doctype().name() << " != " 
	 	   << DOC << endl;
    return 0;
  }
  QDomElement e = doc.documentElement();
  e = e.namedItem(DOCID).toElement();
  if (e.isNull()) {
    e = doc.createElement(DOCID);
    doc.documentElement().appendChild(e);
    e.setAttribute("Id", 0);
    e.setAttribute("Name", DOCID);
    e.setAttribute("Type", QString().setNum(TYP_MMANAGER));
    e.setAttribute("ItemType", QString().setNum(TYP_TMANAGER_T));
    //kdDebug(D_INI) << "DOC: " << doc.toString() << endl;
  }
  KMManagerImpl *m = dynamic_cast<KMManagerImpl*>(KFactoryImpl::factory()->createObject(TYP_MMANAGER));
  m->setName(QString("MManager-%1").arg(QFileInfo(fileName).fileName()));
  m->setCallback(cb);
  m->_doc = doc;
  m->_fileName = fileName;
  m->load(0, e);
  //kdDebug(D_INI) << "D2:" << m->domDoc().toString() << endl;
  return m;
}

/** update managers */
void KMManagerImpl::runPeriodically() {
  KTransferImpl *best = 0;
  _bandwidth = 0;
  _mediumBandwidth = 0;
  for (KObjectImpl *obj = itemFirst(); obj != 0; obj = itemNext()) {
    KTManagerImpl *m = dynamic_cast<KTManagerImpl*>(obj);
    KTransferImpl *t = m->selectForRunning();
    if (t != 0 && (best == 0 || t->cmpPriority(best) == 1))
      best = t;
    _bandwidth += m->bandwidth();
    _mediumBandwidth += m->mediumBandwidth();
  }
  KContainerImpl::runPeriodically();
  if (needSaving()) {
    save();
  }
  if (best != 0)
    best->start();
  //itemChanged(this, MOD_STATE, false, false);
  //(*_callback)(this, MOD_STATE);
  setModified(MOD_VIEW, PRP_THIS);
}

bool KMManagerImpl::save(const QString &f) {
  kdDebug(D_RUN) << name() << ": save document" << endl;
  //<< domDoc().toString() << "END DOCUMENT" << endl;
  QString filename;
  if (f.isEmpty())
    filename = _fileName;
  else
    filename = f;
  QFile file(filename);
  if (!file.open(IO_WriteOnly | IO_Truncate))
    return false;
  QTextStream s(&file);
  //FIXME!!!!
  //s << domDoc().toString();
  s << "<?xml version = '1.0'?><!DOCTYPE " << DOC << " [] >";
  domDoc().documentElement().save(s, 0);
  file.close();
  _fileName = filename;
  setName(QString("MManager-%1").arg(QFileInfo(filename).fileName()));
  _needSaving = false;
  return true;
}

void KMManagerImpl::setModified(ModType type, PropMode prop, bool mod) {
  KContainerImpl::setModified(type, prop, mod);
  if (mod && prop != PRP_NONE)
    (*_callback)(this, type);
}

void KMManagerImpl::updateState() {
  _needSaving = true;
  KContainerImpl::updateState();
  dom().setAttribute("IdCnt", _idCnt);
}

#include "kmmanagerimpl.moc"
