/***************************************************************************
                          kmmanagerimpl.h  -  description
                             -------------------
    begin                : Wed Oct 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMMANAGERIMPL_H
#define KMMANAGERIMPL_H

#include "kcontainerimpl.h"
#include "knotifychange.h"
//#include "kmmanager.h"

class KTManagerImpl;
class KMManager;

/**container of KTManagerImpl objects
  *@author Sergio Moretti
  */

class KMManagerImpl : public KContainerImpl {

  Q_OBJECT

  friend class KMManager;
  friend class KObject;

public: 
  static const char DOCID[];
  static const char MIMETYPE[][50];
  static const char DOCTYPE[];

  /** document name */
  virtual const char * docId() const { return DOCID; }
  /** dom document type */
  virtual const char * docType() const { return DOCTYPE; }
  /** mime type */
  virtual const char * mimeType(int i) const { return MIMETYPE[i]; }

  /** static function to create a manager */
  static KMManagerImpl * managerLoad(const QString &fileName, bool createMode,
				     KNotifyChange *cb);
  /** new item */
  KTManagerImpl * itemNew(const QString &title);
  /** bandwidth */
  int bandwidth() const { return _bandwidth; }
  /** medium bandwidth */
  int mediumBandwidth() const { return _mediumBandwidth; }
  /** document file name */
  QString fileName() const { return _fileName; }
  /** save data */
  virtual bool save(const QString &filename = QString::null);
  virtual void setModified(ModType type, PropMode prop, bool mod = true);

protected:
  KMManagerImpl(int type);
  ~KMManagerImpl();
  virtual KObjectImpl * clone() const;

  virtual void loadData();
  virtual void updateState();
  virtual void itemChanged(KObjectImpl *item, ModType type, PropMode prop);
  virtual void runPeriodically();

  virtual int assignId() { return _idCnt++; }
  /** set callback */
  void setCallback(KNotifyChange *cb) { _callback = cb; }
  bool needSaving() const { return _needSaving; }

private:
  int _idCnt;
  KNotifyChange *_callback;
  int _bandwidth;
  int _mediumBandwidth;
  QString _fileName;
  bool _needSaving;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
