/***************************************************************************
                          ktmanagerimpl.cpp  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.4 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <qdir.h>
#include <qtextstream.h>
#include <kapp.h>
#include "utils.h"
#include "kfactoryimpl.h"
#include "ktransferimpl.h"
#include "ktmanagerimpl.h"


const char KTManagerImpl::DOCID[] = "TManager";
const char KTManagerImpl::MIMETYPE[][50] = { "application/" DOC "-tmanager",
					     "text/x-" DOC "-tmanager" };
const char KTManagerImpl::DOCTYPE[] = "<!DOCTYPE TManager >";


KTManagerImpl::KTManagerImpl(int type) : KContainerImpl(type), _title() {
}

KTManagerImpl::~KTManagerImpl(){
  //kdDebug(D_INI) << name() << ": TManager destroy" << endl;
  killAll();
}

KTransferImpl * KTManagerImpl::itemNew(int type, const KURL &rmt, 
				       const KURL &lcl) {
  QString docId = KFactoryImpl::factory()->docId(type);
  int objId = assignId();
  QString objStrId = 
    QString("%1-%2").arg(KFactoryImpl::factory()->typeStr(type)).arg(objId);
  kdDebug(D_INI) << name() << ": item new " << objStrId << endl;
  QDomElement e = domDoc().createElement(docId);
  domItems().appendChild(e);
  e.setAttribute("Id", objId);
  e.setAttribute("Name", objStrId);
  e.setAttribute("Type", QString().setNum(type));
  e.setAttribute("URL", rmt.url());
  e.setAttribute("File", lcl.path());
  return dynamic_cast<KTransferImpl*>(itemLoad(e));
}

void KTManagerImpl::itemRemove(KObjectImpl *obj) {
  KTransferImpl *t = dynamic_cast<KTransferImpl*>(obj);
  if (t->isRunning())
    t->kill();
  //FIXME!!!
  while (t->isRunning()) 
    kapp->processEvents();
  KContainerImpl::itemRemove(t);
}

bool KTManagerImpl::isItemInsertable(const KObjectImpl *item) {
  const KTransferImpl * t = dynamic_cast<const KTransferImpl*>(item);
  QFileInfo file(t->local().path());
  if (!t->isProtocolSupported(t->remote().protocol()) || file.isDir())
    return false;
  QString filepath = file.absFilePath();
  file.setFile(t->getTmpFile().path());
  if (file.isDir())
    return false;
  for (KObjectImpl *obj = itemFirst(); obj != 0; obj = itemNext()) {
    KTransferImpl *tt = dynamic_cast<KTransferImpl*>(obj);
    if (tt->remote() == t->remote() || tt->local().path() == filepath)
      return false;
  }
  return true;
}

/** kill all subprocess */
void KTManagerImpl::killAll() {
  for (KObjectImpl *obj = itemFirst(); obj != 0; obj = itemNext()) {
    KTransferImpl *t = dynamic_cast<KTransferImpl*>(obj);
    if (t->isRunning())
      t->kill();
  }
}

void KTManagerImpl::loadData() {
  KContainerImpl::loadData();
  kdDebug(D_INI) << name() << ": TManager loadData" << endl;
  // state
  _title = dom().attribute("Title");
  setGlobal(false); // override default global
  // config
  _cfg_autoDownload = dom().attribute("AutomaticDownload", "0").toInt();
  _cfg_maxBandwidth = dom().attribute("MaxBandwidth", "0").toInt();
  _cfg_maxConnection = dom().attribute("MaxOpenConnection", "3").toInt();
  _cfg_autoRemove = dom().attribute("RemoveTransferCompleted", "0").toInt();
  _cfg_downloadDir = dom().attribute("DownloadDirectory", QDir::homeDirPath());
  _cfg_workingDir = dom().attribute("WorkingDirectory", QDir::homeDirPath());
  _cfg_logFile = dom().attribute("LogFile", "");
  _cfg_priority = dom().attribute("Priority", "0").toInt();
  ObjDictIterator i(globals());
  int type = i.current() != 0 ? i.current()->type() : 0;
  _cfg_defaultType = dom().attribute("DefaultType", 
				     QString().setNum(type)).toInt();
  _bandwidth = 0;
  _mediumBandwidth = 0;
}

/*
KManager * KTManagerImpl::manager() const { 
  return dynamic_cast<KManager*>(parent()); 
}
*/

/** procedure called periodically to update the state */
void KTManagerImpl::runPeriodically(){
  KContainerImpl::runPeriodically();
  //kdDebug(KMAGO_CONFIG) << name() << " UPDATE" << endl;
  if (getAutoRemove())
    scanForRemoving();
}

/** scan transfer list to delete completed transfers */
void KTManagerImpl::scanForRemoving(){
  for (KObjectImpl *obj = itemFirst(); obj != 0; obj = itemNext()) {
    KTransferImpl *t = dynamic_cast<KTransferImpl*>(obj);
    if (t->isComplete() && !t->isRunning())
      // remove complete transfer
      itemRemove(t);
  }
}

/** scan list to find a transfer to run */
KTransferImpl* KTManagerImpl::selectForRunning() {
  KTransferImpl *best = 0;
  _bandwidth = 0L;
  _mediumBandwidth = 0;
  // get the bandwidth and the open transfers count, candidate for running
  for (KObjectImpl *obj = itemFirst(); obj != 0; obj = itemNext()) {
    KTransferImpl *t = dynamic_cast<KTransferImpl*>(obj);
    if (t->isRunnable(getAutoDownload()) 
	&& (best == 0 || t->cmpPriority(best) == 1))
      best = t;
    if (t->isRunning()) {
      _bandwidth += t->bandwidth();
      _mediumBandwidth += t->mediumBandwidth();
    }
  }
  //debug("band=%ld, mband=%ld, conn=%d", _bandwidth, _mediumBandwidth, _activeCount);
  setModified(MOD_VIEW, PRP_THIS);
  if (best == 0 
      || (getMaxConnection() && itemActiveCount() == getMaxConnection()) 
      || (getMaxBandwidth() && _bandwidth > getMaxBandwidth()))
    return 0;
  kdDebug(D_RUN) << name() << ": start transfer: " << best->name() <<endl;
  return best;
}

/** enable/disable autodownload */
void KTManagerImpl::setAutoDownload(bool m) {
  if (m != getAutoDownload()) {
    _cfg_autoDownload = m;
    if (m)
      // reset state of transfers: killed to runnable
      for (KObjectImpl *obj = itemFirst(); obj != 0; obj = itemNext()) {
	KTransferImpl *t = dynamic_cast<KTransferImpl*>(obj);
	if (t->cmdStatus() == CMD_KILLED) {
	  t->setStatus(TRN_READY);
	  t->setCmdStatus(CMD_RUNNABLE);
	  t->setModified(MOD_STATE, PRP_ALL);
	}
      }
    //setConfModified();
  }
}

void KTManagerImpl::updateConf() {
  KContainerImpl::updateConf();
  dom().setAttribute("AutomaticDownload", _cfg_autoDownload);
  dom().setAttribute("MaxBandwidth", _cfg_maxBandwidth);
  dom().setAttribute("MaxOpenConnection", _cfg_maxConnection);
  dom().setAttribute("RemoveTransferCompleted", _cfg_autoRemove);
  dom().setAttribute("DownloadDirectory", _cfg_downloadDir.absPath());
  dom().setAttribute("WorkingDirectory", _cfg_workingDir.absPath());
  dom().setAttribute("LogFile", _cfg_logFile);
  dom().setAttribute("Priority", _cfg_priority);
  dom().setAttribute("DefaultType", _cfg_defaultType);
}

void KTManagerImpl::updateState() {
  KContainerImpl::updateState();
  dom().setAttribute("Title", _title);
}

#include "ktmanagerimpl.moc"
