/**
 * configurationview.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef CONFIGURATIONVIEW_H
#define CONFIGURATIONVIEW_H

#include <klistview.h>

#include <qdict.h>

class KURL;

namespace KConfigEditor
{

    class GroupToken;
    class EntryToken;
    class Token;

    class ProtocolItem;
    class ConfItem;
    class ConfigurationView : public KListView
    {
        Q_OBJECT
    public:
        ConfigurationView( QWidget *parent );

        void attach( GroupToken * );
        void attach( EntryToken * );

        Token *token( const KURL & );
        ConfItem *item( const KURL & );
        ProtocolItem *protocolItem( const QString &protocol );

    private:
        QDict<Token> m_items;
        QDict<ProtocolItem> m_protocols;
    };

}

#endif
