/**
 * kconfproperty.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "kconfigproperty.h"

#include "entrytoken.h"

#include <kdebug.h>

using namespace PropertyLib;
using namespace KConfigEditor;

static int toPropertyType( EntryToken::Type type )
{
    switch( type ) {
    case EntryToken::String:
        return Property::String;
        break;
    case EntryToken::Password:
        return Property::String;
        break;
    case EntryToken::StringList:
        return Property::StringList;
        break;
    case EntryToken::Font:
        //adymo: it's better to use Property::String than Property::FontName
        return Property::String;
        break;
    case EntryToken::Rect:
        return Property::Rect;
        break;
    case EntryToken::Size:
        return Property::Size;
        break;
    case EntryToken::Color:
        return Property::Color;
        break;
    case EntryToken::Point:
        return Property::Point;
        break;
    case EntryToken::Int:
        return Property::Integer;
        break;
    case EntryToken::UInt:
        return Property::Integer;
        break;
    case EntryToken::Bool:
        return Property::Boolean;
        break;
    case EntryToken::Double:
        return Property::Double;
        break;
    case EntryToken::DateTime:
        return Property::DateTime;
        break;
    case EntryToken::Int64:
        return Property::Integer;
        break;
    case EntryToken::UInt64:
        return Property::Integer;
        break;
    case EntryToken::IntList:
        return Property::List;
        break;
    case EntryToken::Enum:
        return Property::ValueFromList;
        break;
    case EntryToken::Path:
        return Property::FileURL;
        break;
    case EntryToken::Invalid:
        return Property::String;
        break;
    }
    return Property::String;
}

KConfigProperty::KConfigProperty( EntryToken *token )
    : Property( toPropertyType( token->type() ), token->name(), token->label(),
                token->variant() ), m_token( token )
{
}


QString KConfigProperty::name() const
{
    return m_token->name();
}

void KConfigProperty::setName(const QString &name )
{
    m_token->setName( name );
}

int KConfigProperty::type() const
{
    return toPropertyType( m_token->type() );
}
void KConfigProperty::setType(int type)
{
    Q_UNUSED( type );
    Q_ASSERT( 0 );
}

QVariant KConfigProperty::value() const
{
    return m_token->variant();
}

void KConfigProperty::setValue(const QVariant &value, bool /*rememberOldValue*/ )
{
    m_token->setVariant( value );
}

QString KConfigProperty::description() const
{
    return m_token->name();
}
void KConfigProperty::setDescription( const QString &description )
{
    m_token->setName( description );
}

void KConfigProperty::setValueList( const QMap<QString, QVariant> &lst )
{
    Q_UNUSED( lst );
    Q_ASSERT( 0 );
}

bool KConfigProperty::allowSaving()
{
    return true;
}

bool KConfigProperty::isReadOnly()
{
    return m_token->readOnly();
}

EntryToken* KConfigProperty::token() const
{
    return m_token;
}
