/**
 * main.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "confwindow.h"
#include "kernel.h"

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kdebug.h>

using namespace KConfigEditor;

static const char *description =
	I18N_NOOP("Desktop Configuration Editor");

static const char *version = "0.9.6";

static KCmdLineOptions kconf_options[] =
{
    KCmdLineLastOption
};

int
main( int argc, char **argv )
{
    KAboutData aboutData( "kconfigeditor", I18N_NOOP("Config Editor"),
                          version, description,
                          KAboutData::License_LGPL,
                          "(C) 2004-2005 Zack Rusin" );
    aboutData.addAuthor( "Zack Rusin", I18N_NOOP("Author"), "zack@kde.org" );
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( kconf_options );

    KApplication a;

    //KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    ConfWindow *t = new ConfWindow( "KConfigEditor" );

    t->resize( 640, 480 );
    a.setMainWidget( t );
    t->show();

    return a.exec();
}
