/*
 * modify grants
 * this is realy mysql-stuff. other sql-servers have another
 * grant-table. Means - for another sql-server it should complete
 * rewritten.
 */ 

#include <qstring.h>
#include <qmsgbox.h>
#include <klocale.h>
#include <kapp.h>
#include <kglobal.h>

#include "globals.h"
#include "granttable.h"
#include "grantedit.h"
#include "my_sql.h"
#include "stringres.h"
#include "kmysqladmin/setup/settings.h"
#include "TabView.h"
#include "qlistview.h"

#include "stringres.h"

#ifndef rcsid
static const char rcsid[]="$Id: granttable.cpp,v 2.23 2003/02/09 17:54:35 ral Exp $";
//const char*granttable_rcs(){return rcsid;}
#endif

//strings, strings, strings....
const char* CGrantTable::DB_Name="mysql";
const char* CGrantTable::Host_Table="host";
const char* CGrantTable::User_Table="user";
const char* CGrantTable::DB_Table="db";
const char* CGrantTable::Pass_Entry="password";
const char* CGrantTable::Host_Title="Host:";

const char*CGrantTable::Se_Str="Select_priv";
const char*CGrantTable::In_Str="Insert_priv";
const char*CGrantTable::Up_Str="Update_priv";
const char*CGrantTable::De_Str="Delete_priv";
const char*CGrantTable::Cr_Str="Create_priv";
const char*CGrantTable::Dr_Str="Drop_priv";
const char*CGrantTable::Re_Str="Reload_priv";
const char*CGrantTable::Sh_Str="Shutdown_priv";
const char*CGrantTable::Pr_Str="Process_priv";
const char*CGrantTable::Fi_Str="File_priv";
const char*CGrantTable::No="N";

#define Inherited CGrantTableData

using namespace std;

CGrantTable::CGrantTable(smart_pointer<CMySql>& _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    sql_server = _sql_server;
    QString caption;
    User_Title=GET_TEXT(25);
    DB_Title=GET_TEXT(26);
    P_Title=GET_TEXT(27);
    P2_Title=GET_TEXT(28);
    caption = GET_TEXT(125);
    caption += GET_TEXT(29);
    setCaption(caption);
    setIcon(kapp->icon());
    FontChanged();
    DisableButtons();
    ReadHostTable();
    connect(&GlobalSettings,SIGNAL(fixfont_changed()),this,SLOT(FontChanged()));
    FontChanged();
}

CGrantTable::~CGrantTable()
{
    debug("Granttable: destruktor\n");
}

void CGrantTable::Refresh()
{
    ReadHostTable();
}

void CGrantTable::ReadHostTable()
{
    stringlist erg;
    int i = 0;
    HostList->clear();
    if (!sql_server)
	return;
    erg.push_back(std::string(Host_Table));
    erg.push_back(std::string(DB_Table));
    HostList->clear();
    list_vector result;
    i = sql_server->fetch_rows(DB_Name,Host_Table,Host_Table,&erg,result,0,0,0,true);
    if (result.size() > 0 && i==0) {
        QListViewItem * item = 0;
        list_vector::iterator result_iter = result.begin();
	stringlist::iterator iter;
	for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(HostList,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,iter->c_str());
                ++count;
                if (count == 2)break;
            }
	}
    } else {
    }
    HostList->setCurrentItem(HostList->firstChild());
    hosthilighted(HostList->firstChild());
    if (i == 0)
	AddHostButton->setEnabled(TRUE);
}

void CGrantTable::hosthilighted(QListViewItem*hostitem)
{
    if (hostitem==0)
        return;
    QString t = hostitem->text(0);
    ReadUserTable(t);
    ModifyHostButton->setEnabled(TRUE);
    if (UserList->childCount() > 0)
	DelHostButton->setEnabled(FALSE);
    else
        DelHostButton->setEnabled(TRUE);
}

void CGrantTable::userhilighted(QListViewItem*useritem)
{
    if (useritem==0)
        return;
    QString t,s;
    t = useritem->text(0);
    s = useritem->text(1);
    ReadDBTable(t,s);

    ModifyUserButton->setEnabled(TRUE);
    if (DBList->childCount() == 0)
	DelUserButton->setEnabled(TRUE);
    else
        DelUserButton->setEnabled(FALSE);
}

void CGrantTable::show()
{
    QDialog::show();
}

void CGrantTable::ReadUserTable(QString&Host)
{
    stringlist erg;
    PatternList Patterns;
    int i;

    UserList->clear();
    if (!sql_server)
	return;
    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    list_vector result;
    Patterns.push_back(CPatternPair(Host_Table,Host));
    i = sql_server->fetch_rows(DB_Name,User_Table,User_Table,&erg,result,0,0,&Patterns,true);

    if (result.size()) {
        QListViewItem* item=0;
        list_vector::iterator result_iter=result.begin();
	stringlist::iterator iter;
        for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(UserList,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,iter->c_str());
                ++count;
                if (count == 2)break;
            }
        }
    }
    if (UserList->childCount()>0 && i == 0) {
	UserList->setCurrentItem(UserList->firstChild());
    } else {
	ModifyUserButton->setEnabled(FALSE);
	DelUserButton->setEnabled(FALSE);
    }
    if (i == 0) 
	AddUserButton->setEnabled(TRUE);
    else
	AddUserButton->setEnabled(FALSE);
}

void CGrantTable::ReadDBTable(QString&Host,QString&User)
{
    stringlist erg;
    PatternList Patterns;
    
    int i;

    DBList->clear();
    if (!sql_server)
	return;

    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    erg.push_back(DB_Table);
    list_vector result;

    Patterns.push_back(CPatternPair(Host_Table,Host));
    Patterns.push_back(CPatternPair(User_Table,User));

    i = sql_server->fetch_rows(DB_Name,DB_Table,DB_Table,&erg,result,0,0,&Patterns,true);
    if (result.size() && i==0) {
        QListViewItem*item = 0;
        list_vector::iterator result_iter = result.begin();
	stringlist::iterator iter;
        for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(DBList,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,iter->c_str());
                ++count;
                if (count==3)break;
            }
        }
        DBList->setCurrentItem(DBList->firstChild());
    } else {
        ModifyDbButton->setEnabled(FALSE);
        DelDbButton->setEnabled(FALSE);        
    }
    if (i == 0) 
	AddDbButton->setEnabled(TRUE);
    else
	AddDbButton->setEnabled(FALSE);
}

void CGrantTable::DisableButtons()
{
    AddUserButton->setEnabled(FALSE);
    ModifyUserButton->setEnabled(FALSE);
    DelUserButton->setEnabled(FALSE);
    AddHostButton->setEnabled(FALSE);
    ModifyHostButton->setEnabled(FALSE);
    DelHostButton->setEnabled(FALSE);
    AddDbButton->setEnabled(FALSE);
    ModifyDbButton->setEnabled(FALSE);
    DelDbButton->setEnabled(FALSE);
}

void CGrantTable::dbhilighted(QListViewItem*)
{
    QListViewItem*item = DBList->currentItem();
    if (item) {
        ModifyDbButton->setEnabled(TRUE);
        DelDbButton->setEnabled(TRUE);
    } else {
        ModifyDbButton->setEnabled(FALSE);
        DelDbButton->setEnabled(FALSE);
    }
}

void CGrantTable::ModifyHost()
{
    QString db = "";
    QString host = "";
    stringlist erg;
    PatternList*Patterns = 0;
    PatternList*modify = 0;
    
    CPatternPair pat2;
    CGrantEdit edit(this);
    edit.setCaption("Edit Host");
    int i = 0;

    append_Sel(&erg);

    Patterns = break_hoststring();
    if (Patterns == 0 || Patterns->size() < 2)
	return;

    pat2 = (*Patterns)[0];
    host = (*Patterns)[0].get_pattern();
    if (host == "%")
	(*Patterns)[0].set_pattern("%%");
    pat2 = (*Patterns)[1];
    db = (*Patterns)[1].get_pattern();
    if (db == "%")
	(*Patterns)[1].set_pattern("%%");
    
    i = sql_server->fetch_rows(DB_Name,Host_Table,0,&erg,0,0,Patterns,true);

    if (i == -1 || Patterns->size() == 0) {
	Error();
	delete Patterns;
	return;
    }
    Patterns->insert(Patterns->begin(),CPatternPair(DB_Table,db));
    Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,host));
    if (UserList->childCount() > 0)
	(*Patterns)[0].setIsNumeric(TRUE);
    erg.clear();
    erg.push_back(Host_Title);
    erg.push_back(DB_Title.latin1());
    edit.set_entries(Patterns,&erg);

    if (edit.exec()) {
	modify = edit.get_entries();
	if (modify && modify->size() > 0) {
	    Patterns->resize(0);
	    Patterns->push_back(CPatternPair(Host_Table,host));
	    Patterns->push_back(CPatternPair(DB_Table,db));
	    i = sql_server->update_row(DB_Name,Host_Table,modify,Patterns);
	    UpdateGrants(i);
	}
    }

    delete Patterns;
    if (modify)
	delete modify;
}

void CGrantTable::ModifyUser()
{
    QString Host = "";
    QString User = "";
    QString result;
    std::string Old_Pass;
    std::string p1,p2;
    stringlist erg;
    PatternList*Patterns = 0;
    PatternList*modify = 0;
    CPatternPair pat2;
    CGrantEdit edit(this);
    edit.setCaption(GET_TEXT(30));
    int i = 0;
    int j = 0;

    erg.push_back(Pass_Entry);

    append_Sel(&erg);
    erg.push_back(Re_Str);
    erg.push_back(Sh_Str);
    erg.push_back(Pr_Str);
    erg.push_back(Fi_Str);
    Patterns = break_userstring();
    if (Patterns == 0 || Patterns->size()<2)
	return;

    Host = (*Patterns)[0].get_pattern();
    if (Host == "%")
	(*Patterns)[0].set_pattern("%%");
    User = (*Patterns)[1].get_pattern();
    if (User == "%")
	(*Patterns)[1].set_pattern("%%");

    i = sql_server->fetch_rows(DB_Name,User_Table,0,&erg,0,0,Patterns,true);
    if (i == -1 || Patterns->size() == 0) {
	Error();
        if (Patterns->size()==0) 
            qWarning("Patternsize == 0");
	delete Patterns;
	return;
    }
    (*Patterns)[0].setIsPassword(TRUE);
    Old_Pass = (*Patterns)[0].get_pattern();
    std::string inhalt = (*Patterns)[0].get_pattern();
    Patterns->insert(Patterns->begin(),CPatternPair("pass2",inhalt));
    (*Patterns)[0].setIsPassword(TRUE);

    Patterns->insert(Patterns->begin(),CPatternPair(User_Table,User));
    (*Patterns)[0].setIsNumeric( (DBList->childCount() > 0) );
    Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,Host));
    (*Patterns)[0].setIsNumeric(TRUE);

    erg.clear();
    erg.push_back(Host_Title);
    erg.push_back(User_Title.latin1());
    erg.push_back(P_Title.latin1());
    erg.push_back(P2_Title.latin1());
    edit.set_entries(Patterns,&erg);
    erg.clear();
    j = DBList->childCount() > 0?0:1;
    if (edit.exec()) {
	modify = edit.get_entries();
	if (modify && modify->size()>0) {
	    p1 = (*modify)[j].get_pattern();
	    p2 = (*modify)[j+1].get_pattern();
	    if (p1 != p2) {
		pass_error();
	    } else {
		if (p1 == "") {
		    Old_Pass = "";
		} else if (p1 != Old_Pass) {
		    sql_server->scramble_password(p1);
		}
		pat2 = (*modify)[0];
		modify->erase(modify->begin());
		modify->erase(modify->begin());
		modify->erase(modify->begin());
		if (p1 == string("user"))
		    modify->insert(modify->begin(),pat2);
                modify->insert(modify->begin(),CPatternPair(Pass_Entry,p1));
		Patterns->clear();
		Patterns->push_back(CPatternPair(Host_Table,Host));
		Patterns->push_back(CPatternPair(User_Table,User));
		i = sql_server->update_row(DB_Name,User_Table,modify,Patterns);
		UpdateGrants(i);
		ReadUserTable(Host);
	    }
	}
    }
    delete Patterns;
    if (modify)
	delete modify;
}

void CGrantTable::ModifyDb()
{
    QString hostentry = "";
    QString userentry = "";
    QString dbentry = "";

    stringlist erg;
    PatternList*Patterns = 0;
    PatternList*modify = 0;
    
    CGrantEdit edit(this);
    edit.setCaption(GET_TEXT(31));

    append_Sel(&erg);
    Patterns = break_dbstring();
    if (Patterns == 0)
        return;

    hostentry = (*Patterns)[0].get_pattern();
    userentry = (*Patterns)[1].get_pattern();
    dbentry = (*Patterns)[2].get_pattern();

    int i = sql_server->fetch_rows(DB_Name,DB_Table,0,&erg,0,0,Patterns,true);

    if (i == -1 || Patterns->size() == 0) {
        Error();
        delete Patterns;
        return;
    }
    Patterns->insert(Patterns->begin(),CPatternPair(DB_Table,dbentry));
    Patterns->insert(Patterns->begin(),CPatternPair(User_Table,userentry));
    (*Patterns)[0].setIsNumeric(TRUE);
    Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,hostentry));
    (*Patterns)[0].setIsNumeric(TRUE);
    erg.clear();
    erg.push_back(Host_Title);
    erg.push_back(User_Title.latin1());
    erg.push_back(DB_Title.latin1());
    edit.set_entries(Patterns,&erg);

    if (edit.exec()) {
 	modify = edit.get_entries();
 	if (modify && modify->size() > 0) {
            Patterns->clear();
 	    Patterns->push_back(CPatternPair(Host_Table,hostentry));
 	    Patterns->push_back(CPatternPair(User_Table,userentry));
 	    Patterns->push_back(CPatternPair(DB_Table,dbentry));
 	    i = sql_server->update_row(DB_Name,DB_Table,modify,Patterns);
 	    UpdateGrants(i);
            QListViewItem*item = UserList->selectedItem();
            if (item) {
                userhilighted(item);
            }
 	}
    }
    delete Patterns;
    if (modify)
        delete modify;
}

void CGrantTable::append_Sel(stringlist*List)
{
    if (!List)
	return;
    List->push_back(Se_Str);
    List->push_back(In_Str);
    List->push_back(Up_Str);
    List->push_back(De_Str);
    List->push_back(Cr_Str);
    List->push_back(Dr_Str);
}

void CGrantTable::append_Add(PatternList*List)
{
    if (!List)
	return;
    List->push_back(CPatternPair(Se_Str,No));
    List->push_back(CPatternPair(In_Str,No));
    List->push_back(CPatternPair(Up_Str,No));
    List->push_back(CPatternPair(De_Str,No));
    List->push_back(CPatternPair(Cr_Str,No));
    List->push_back(CPatternPair(Dr_Str,No)); 
}

void CGrantTable::AddHost()
{
    PatternList*Patterns = 0;
    stringlist erg;
    QString host = "";
    QString db = "";
    int i;
    CGrantEdit edit(this);
    Patterns=new PatternList;
    edit.setCaption(GET_TEXT(32));
    Patterns->push_back(CPatternPair(Host_Table,""));
    Patterns->push_back(CPatternPair(DB_Table,""));
    
    erg.push_back(Host_Title);
    erg.push_back(DB_Title.latin1());
    append_Add(Patterns);
    edit.set_entries(Patterns,&erg);
    delete Patterns; Patterns = 0;
    if (edit.exec()) {
	Patterns = edit.get_entries();
	host = Patterns->begin()->get_pattern();
	db = (*Patterns)[1].get_pattern();
	if (!db.isEmpty() && !host.isEmpty()) {
	    i = sql_server->insert_row(DB_Name,Host_Table,Patterns);
	    UpdateGrants(i);
	    if (i > 0) {
		ReadHostTable();
	    }
	}
    }
    if (Patterns) {
	delete Patterns;
    }
}

void CGrantTable::AddUser()
{
    QString Host = "";
    PatternList*Patterns = 0;
    stringlist erg;
    CGrantEdit edit(this);
    std::string p1, p2;
    int i = 0;
    edit.setCaption(GET_TEXT(33));
    Patterns = break_hoststring();
    PatternList::iterator p_iter;
    if (Patterns == 0)
        return;
    (*Patterns)[0].setIsNumeric(TRUE);
    Host = (*Patterns)[0].get_pattern();
    p_iter = Patterns->begin();
    ++p_iter;
    Patterns->erase(p_iter);
    Patterns->push_back(CPatternPair(User_Table,""));
    Patterns->push_back(CPatternPair("pass",""));
    PatternIterator p_iter2;
    p_iter2 = Patterns->end();
    --p_iter2;
    p_iter2->setIsPassword(TRUE);
    Patterns->push_back(CPatternPair("pass2",""));
		p_iter2 = Patterns->end();
		--p_iter2;
    p_iter2->setIsPassword(TRUE);

    append_Add(Patterns);
    Patterns->push_back(CPatternPair(Re_Str,No));
    Patterns->push_back(CPatternPair(Sh_Str,No));
    Patterns->push_back(CPatternPair(Pr_Str,No));
    Patterns->push_back(CPatternPair(Fi_Str,No)); 

    erg.push_back(Host_Title);
    erg.push_back(User_Title.latin1());
    erg.push_back(P_Title.latin1());
    erg.push_back(P2_Title.latin1());
    edit.set_entries(Patterns,&erg);
    erg.clear();
    delete Patterns; Patterns = 0;
    if (edit.exec()) {
	Patterns = edit.get_entries();
	p1 = (*Patterns)[0].get_pattern();
	if (p1.size()==0) {
	    user_error();
	} else {
	    p1 = (*Patterns)[1].get_pattern();
	    p2 = (*Patterns)[2].get_pattern();
	    if (p1 != p2) {
		pass_error();
	    } else {
		if (p1.size()) {
		    sql_server->scramble_password(p1);
		} else {
                }
		p_iter = Patterns->begin();
		p_iter++;
		Patterns->erase(p_iter);
		p_iter = Patterns->begin();
		p_iter++;
		Patterns->erase(p_iter);
                if (p1.size()) 
                    Patterns->insert(Patterns->begin(),CPatternPair(Pass_Entry,p1));
		Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,Host));
		i = sql_server->insert_row(DB_Name,User_Table,Patterns);
		UpdateGrants(i);
		if (i > 0) {
                    QListViewItem*item = HostList->selectedItem();
		    if (item) {
			hosthilighted(item);
		    }
		}
	    }
	}
    }
    delete Patterns;
}

void CGrantTable::AddDb()
{
        int i = 0;
        QString Host = "";
        QString User = "";
        QString Title = GET_TEXT(34);
        stringlist titles;
        PatternList*Patterns;
        CGrantEdit edit(this);

        Patterns = break_userstring();
        if (Patterns == 0)
            return;

        Host = (*Patterns)[0].get_pattern();
        (*Patterns)[0].setIsNumeric(TRUE);
        User = (*Patterns)[1].get_pattern();
        (*Patterns)[1].setIsNumeric(TRUE);
        Patterns->push_back(CPatternPair(DB_Table,""));
        append_Add(Patterns);
        Title+=User;
        edit.setCaption(Title);

        titles.push_back(Host_Title);
        titles.push_back(User_Title.latin1());
        titles.push_back(DB_Title.latin1());
        edit.set_entries(Patterns,&titles);
    
        delete Patterns; Patterns = 0;

        if (!edit.exec())
            return;
        Patterns = edit.get_entries();
        if (!Patterns)
            return;
        Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,Host));
        Patterns->insert(Patterns->begin(),CPatternPair(User_Table,User));
        i = sql_server->insert_row(DB_Name,DB_Table,Patterns);
        UpdateGrants(i);
        if (i > 0) {
            userhilighted(UserList->selectedItem());
        }
}

void CGrantTable::pass_error()
{
    QString msg = GET_TEXT(35);
    msg+=",\n";
    msg+=GET_TEXT(36);
    QMessageBox::warning(this,GET_TEXT(37), msg );
}

void CGrantTable::user_error()
{
    QMessageBox::warning(this,GET_TEXT(38),GET_TEXT(39));
}

void CGrantTable::DeleteUser()
{
    if (DBList->childCount() != 0)
	return;
    PatternList*KeyList=0;
    int i = Ask_delete();
    if (i != QMessageBox::Yes)
        return;

    KeyList = break_userstring();
    if (!KeyList)
        return;
    i = sql_server->delete_row(DB_Name,User_Table,KeyList);

    delete KeyList;

    if (i < 0) {
        Error();
        return;
    }
    QListViewItem*item = HostList->selectedItem();
    if (item)
        hosthilighted(item);
}

void CGrantTable::DeleteHost()
{
    if (UserList->childCount() != 0)
	return;
    PatternList*KeyList=0;
    int i = Ask_delete();
    if (i != QMessageBox::Yes)
	return;
    KeyList = break_hoststring();
    if (KeyList == 0)
	return;
    i = sql_server->delete_row(DB_Name, Host_Table, KeyList);
    delete KeyList;
    if (i < 0){
	Error();
	return;
    }
    ReadHostTable();
}

void CGrantTable::DeleteDb()
{
    PatternList*KeyList = 0;
    int i = Ask_delete();
    if (i != QMessageBox::Yes)
	return;
    KeyList = break_dbstring();
    if (KeyList == 0)
	return;
    i = sql_server->delete_row(DB_Name,DB_Table,KeyList);
    delete KeyList;
    if (i < 0) {
	Error();
	return;
    }
    userhilighted(UserList->selectedItem());
}

PatternList* CGrantTable::break_hoststring()
{
    QListViewItem * item = HostList->selectedItem();
    if (!item)
        return 0;
    QString db,Host;
    PatternList*KeyList = new PatternList;
    db = item->text(1);
    Host=item->text(0);
    KeyList->push_back(CPatternPair(Host_Table,Host));
    KeyList->push_back(CPatternPair(DB_Table,db));
    return KeyList;
}

PatternList* CGrantTable::break_userstring()
{
   QListViewItem * item = UserList->selectedItem();
   if (!item)
       return 0;
   PatternList*KeyList = 0;
   QString user = item->text(1);
   QString host = item->text(0);
   host = host.stripWhiteSpace();
   user = user.stripWhiteSpace();
   KeyList = new PatternList;
   KeyList->push_back(CPatternPair(Host_Table,host));
   KeyList->push_back(CPatternPair(User_Table,user));
   return KeyList;
}

PatternList* CGrantTable::break_dbstring()
{
    QListViewItem * item = DBList->selectedItem();
    PatternList*KeyList = 0;
    if (!item)
	return KeyList;
    QString db = item->text(2);
    QString host = item->text(0);
    QString user = item->text(1);
    user = user.stripWhiteSpace();
    db = db.stripWhiteSpace();
    KeyList = new PatternList;
    KeyList->push_back(CPatternPair(Host_Table,host));
    KeyList->push_back(CPatternPair(User_Table,user));
    KeyList->push_back(CPatternPair(DB_Table,db));
    return KeyList;
}

int CGrantTable::Ask_delete()
{
    return QMessageBox::warning(this,"Delete Entry",
				"Do you realy want to delete this entry?",
				QMessageBox::Yes | QMessageBox::Default,
				QMessageBox::Abort | QMessageBox::Escape);
}

void CGrantTable::Error()
{
    display_error_box();
}

void CGrantTable::hostselected(QListViewItem*)
{
    ModifyHost();
}

void CGrantTable::userselected(QListViewItem*)
{
    ModifyUser();
}

void CGrantTable::dbselected(QListViewItem*)
{
    ModifyDb();
}

void CGrantTable::UpdateGrants(int count)
{
    if (count < 0) {
	Error();
    } else if (count > 0) {
	sql_server->refresh_grants();
    }
}

void CGrantTable::FontChanged()
{
    QFont font = GlobalSettings.get_fixed_font();
    HostList->setFont(font);
    UserList->setFont(font);
    DBList->setFont(font);
}
