// getopt.c --- parsing commandline arguments
// returns charakter with the switch
// args are:
// first : argv-liste
// second: parameters without any arguments (like -?)
// third : parameters with second argumend (like -u alwin)
// last  : a charakter string (allocated or null) for returning the second argument
// if the last is reached, it returns -1, the zero argument is skipped (the prog-name)
// returns 0 if a non-existing argument was giving
// returns -2 if a argument only was given with "-" or "/"
// returns -3 if only a string was reached and copied into the buffer
// in this case, buffer MUST allocated
// singlepara MUST given
// buffer can be NULL, than no second para will return
// if doublepara is NULL, no check for it is given
// example:
// getopt (argc, argv, "?cd", NULL, NULL)
// getopt (argc, argv, "?cd", "und", NULL)
// getopt (argc, argv, "?cd", "und", buffer)

#include <string.h>

#ifdef WIN32
#pragma warning ( disable : 4786 )
#endif

#include "cmdline.h"
#include <stdlib.h>

#ifndef rcsid
static const char rcsid[]="$Id: cmdline.cpp,v 2.2 2000/09/02 14:10:33 ral Exp $";
#endif

using namespace std;

#define _MAX_BUFFER_SIZE 4096

getOptions::getOptions(int how_many, char*argv[], char*singlepara, char*doublepara)
{
    newOptions(how_many,argv,singlepara,doublepara);
}

getOptions::getOptions()
{
    Reset();
}

void getOptions::newOptions(int how_many, char*argv[], char*singlepara, char*doublepara)
{
    Reset();
    _singlepara = singlepara;
    _doublepara = doublepara;
    _how_many = how_many;
    _args = argv;
}

void getOptions::StartParsing()
{
    char Buffer[_MAX_BUFFER_SIZE+1];
    Reset();
    char c;
    while ( (c=getopt(_how_many,_args,_singlepara,_doublepara,Buffer,0)) != -1) {
	switch (c) {
	case -3:
	    names.push_back(Buffer);
	    break;
	case 0:
	    unknown.push_back(c);
	    break;
	case -2:
	    wrong_argument = true;
	    break;
	default:
	    parameters[c] = Buffer;
	    break;
	}
	memset(Buffer,0,_MAX_BUFFER_SIZE+1);
    }
}

void getOptions::Reset()
{
    count = 0;
    more_than_one = 0; // if a flag like "-abc" is given
    parameters.clear();
    unknown.clear();
    names.resize(0);
    wrong_argument = false;
}

char getOptions::getopt (int how_many, char*argv[], char*singlepara, char*doublepara, char*buffer, int*wo)
{
    int i,j;

    if (singlepara == NULL)
	return -1;

    if (!more_than_one) {
	if ( !(++count < how_many))
	    return -1;
    }

    if (wo)
	*wo = count;
    if ((argv[count][0] == '-') || (argv[count][0] == '/')) {
	if (strlen(argv[count]) == 1) {
	    return -2;
	}
	if (strchr(singlepara, argv[count][more_than_one+1])) {
	    i = 0;
	    if (strlen(argv[count]) > 2) {
		i = more_than_one;
		more_than_one++;
		j = strlen(argv[count]);
		if ( (j) == (1+more_than_one)) {
		    more_than_one = 0;
		}
	    } else {
		more_than_one = 0;
	    }
	    return argv[count][i+1];
	}
	if (doublepara != NULL) {
	    if (strchr(doublepara, argv[count][more_than_one+1])) {
		i = more_than_one;
		more_than_one = 0;
		count++;
		if (wo) {
		    *wo=count;
		}
		if (count == how_many){
		    strcpy(buffer, "");
		    return(argv[count-1][i+1]);
		}
		strcpy(buffer,argv[count]);
		return(argv[count-1][i+1]);
	    }
	}
	if (strlen(argv[count]) > 2) {
	    more_than_one++;
	    j = strlen(argv[count]);
	    if ( (j) == (1+more_than_one))
		more_than_one=0;
	} else {
	    more_than_one = 0;
	}
	return 0;
    }
    else {
	if (buffer) {
	    strcpy(buffer, argv[count]);
	    return -3;
	}
	return 0;
    }
    return -1;
}

const std::string getOptions::get_value(const char which)const
{
    if (which == 0)
	return "";
    map<char,std::string>::const_iterator p = parameters.find(which);
    if (p == parameters.end())
	return "";
    return p->second;
}

bool getOptions::contains(const char which)const
{
    return (parameters.find(which) != parameters.end());
}
