#ifdef _WIN32
#pragma warning ( disable : 4786 )
#endif

#include "tabledescr.h"
#include "pairs.h"
#include <algorithm>

#ifndef rcsid
static const char rcsid[]="$Id: tabledescr.cpp,v 2.15 2003/02/12 16:52:20 ral Exp $";
//const char*tabledescr_rcs(){return rcsid;}
#endif

CKeyDescriptor::CKeyDescriptor(const CKeyDescriptor&old) 
{
    name = old.name;
    ColumnsList = old.ColumnsList;
    type = old.type;
    compound = old.is_compound();
}

CKeyDescriptor&CKeyDescriptor::operator=(const CKeyDescriptor&old)
{
    name = old.name;
    ColumnsList = old.ColumnsList;
    type = old.type;
    compound = old.is_compound();
    return *this;
}

int CKeyDescriptor::add_column_name(const std::string&column,const unsigned int size)
{
    if (column.size()==0)
	return 0;

    pairIlist::iterator iter;
    string_int_pair p(column,size);

    //iter = ColumnsList.find(p);
    iter = std::find(ColumnsList.begin(),ColumnsList.end(),p);
    if (iter != ColumnsList.end()) {
	return -1;
    }
    ColumnsList.push_back(p);
    return 1;
}

int CKeyDescriptor::add_column_name(const char*column,const unsigned int size)
{
    if (!column || !strlen(column))
	return 0;
    std::string s(column);
    return add_column_name(s,size);
}

void CKeyDescriptor::remove_column_name(const std::string&column)
{
    if (column.size() == 0)
	return;
    pairIlist::iterator iter;

    string_int_pair p(column,0);

    iter = std::find(ColumnsList.begin(),ColumnsList.end(),p);

    if (iter != ColumnsList.end())
	ColumnsList.erase(iter);    

}

void CKeyDescriptor::remove_column_name(const char*column)
{
    if (!column || !strlen(column) )
	return;

    std::string s(column);

    remove_column_name(s);
}


bool CKeyDescriptor::contains_column_name(const std::string&column)
{
    if (column.size()==0)
	return false;
    string_int_pair p(column,0);
    return (std::find(ColumnsList.begin(),ColumnsList.end(),p)!=ColumnsList.end());
}

bool CKeyDescriptor::contains_column_name(const char*column)
{
    if (!column || !strlen(column))
	return false;

    std::string s(column);
    return contains_column_name(s);
}

unsigned int CKeyDescriptor::column_size(const std::string&column)
{
    if (column.size() == 0)
	return 0xFFFFFFFF;
    pairIlist::iterator iter;

    string_int_pair p(column,0);

    iter = std::find(ColumnsList.begin(),ColumnsList.end(),p);
    if (iter==ColumnsList.end())
	return 0xFFFFFFFF;
    return iter->second;
}

unsigned int CKeyDescriptor::column_size(const char*column)
{
    if (!column)
	return 0xFFFFFFFF;
    std::string s = column;
    return column_size(s);
}

CColumnDescriptor::CColumnDescriptor()
{
    name = "";
    Def = "";
    table = "";
    
    FieldType = 0;
    MaxLength = 0;
    MaxDecimals = 0;
    
    AutoIncrement = false;
    PrimaryField = false;
    Binary = false;
    TimeStamp = false;
    ZeroFill = false;
    NotNull = false;
    Blob = false;
    PartOfMultiple = false;
    Numeric = false;
    UniqueValue = false;
}

void CColumnDescriptor::copy_old(const CColumnDescriptor*old)
{
    name = old->name;
    Def = old->Def;
    table = old->table;
    
    FieldType = old->FieldType;
    MaxLength = old->MaxLength;
    MaxDecimals = old->MaxDecimals;
    
    AutoIncrement = old->AutoIncrement;
    PrimaryField = old->PrimaryField;
    Binary = old->Binary;
    TimeStamp = old->TimeStamp;
    ZeroFill = old->ZeroFill;
    NotNull = old->NotNull;
    Blob = old->Blob;
    PartOfMultiple = old->PartOfMultiple;
    Numeric = old->Numeric;
    UniqueValue = old->UniqueValue;
    Enums = old->Enums;
    Unsigned = old->Unsigned;
}

CColumnDescriptor::CColumnDescriptor(const CColumnDescriptor&old)
{
    copy_old(&old);
}

CColumnDescriptor& CColumnDescriptor::operator=(const CColumnDescriptor&old)
{
    copy_old(&old);
    return *this;
}

void CColumnDescriptor::remove_enum(const std::string&what)
{
    stringIlist::iterator iter;
    iter = Enums.find(what);
    if (iter!=Enums.end()) {
	Enums.erase(iter);
    }
}
