// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#ifndef __KDETVMIXER_PLUGIN_H
#define __KDETVMIXER_PLUGIN_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>
#include "kdetvpluginbase.h"

class KdetvMixerPluginPrivate;

/**
 * Mixer plugin base class
 */
class KdetvMixerPlugin : public KdetvPluginBase
{
    Q_OBJECT

public:
    KdetvMixerPlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent = 0, const char* name = 0);
    virtual ~KdetvMixerPlugin();

    virtual const QStringList& mixerList() const;
    const QString& mixer() const;

    // return 0 on success.  This is called to indicate that you should probe
    // for devices and populate _mixers.
    // It may be called more than once.
    virtual int probeDevices() = 0;

    /*
     *   Set the volume of the current mixer to vol.  This must be normalized
     *   to [0..100].  Returns -1 on a system error otherwise 0.
     */
    virtual int setVolume(int left, int right) = 0;
    virtual int volumeLeft() = 0;
    virtual int volumeRight() = 0;

    virtual int setMuted(bool mute) = 0;
    virtual bool muted() = 0;

signals:
    void volumeChanged(int left, int right);


protected:
    QStringList _mixers;
    QString _currentMixer;

private:
    KdetvMixerPluginPrivate *d;
};

#endif

