/***************************************************************************
                          transaction.cpp  -  description
                             -------------------
    begin                : Sat Aug 10 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "transaction.h"
#include "kbudgetdoc.h"

Transaction::Transaction() {
}

Transaction::Transaction(KBudgetDoc* d, int i, int from, int to, float val, QDate dt, QString desc)
{
	m_from = from;
	m_to = to;
	m_value = val;
	m_date = dt;
	m_description = desc;
	m_doc = d;
	m_id = i;
}

Transaction::~Transaction() {
}

int Transaction::id() const
{
  return m_id;
}

int Transaction::from() const
{
  return m_from;
}

int Transaction::to() const
{
  return m_to;
}

float Transaction::value() const
{
  return m_value;
}

QDate Transaction::date() const
{
  return m_date;
}

QString Transaction::description() const
{
  return m_description;
}

void Transaction::setData(float val, QDate d, QString desc)
{
  m_doc->getAccount(m_from).removeTransaction(m_id);
  m_doc->getAccount(m_to).removeTransaction(m_id);
  m_value = val;
  m_date = d;
  m_description = desc;
  m_doc->getAccount(m_from).addTransaction(m_id);
  m_doc->getAccount(m_to).addTransaction(m_id);
}
