/***************************************************************************
                          ktransactionwidget.cpp  -  description
                             -------------------
    begin                : Sat Sep 7 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: ktransactionwidget.cpp,v 1.7 2002/09/13 02:25:16 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qdatetime.h>
#include <klistview.h>
#include <klocale.h>
 
#include "ktransactionwidget.h"
#include "ktransactionwidget.moc"
#include "kbudgetdoc.h"
#include "ktransactionlistitem.h"

KTransactionWidget::KTransactionWidget(KBudgetDoc* doc, int account, QWidget *parent, const char *name)
  : QVBox(parent,name), m_sMonth(0), m_sYear(0)
{
  list = new KListView(this, "transaction_list");
  list->addColumn("Date");
  list->addColumn("Debits");
  list->setColumnAlignment(1, Qt::AlignRight);
  list->addColumn("Credits");
  list->setColumnAlignment(2, Qt::AlignRight);
  list->addColumn("Description");
  
  connect(list, SIGNAL(contextMenuRequested(QListViewItem*,const QPoint&,int)), SLOT(slotContextMenuRequested(QListViewItem*, const QPoint&, int)));
  connect(list, SIGNAL(selectionChanged()), SLOT(slotSelectionChanged()));
  connect(doc, SIGNAL(accountChanged(int)), SLOT(slotAccountChanged(int)));

  m_doc = doc;
  m_account = account;
}

KTransactionWidget::~KTransactionWidget()
{
}

void KTransactionWidget::selectMonth(QDate month)
{
  select(month.year(), month.month());
  slotSelectionChanged();
}

void KTransactionWidget::selectAll()
{
  select(0, 0);
  slotSelectionChanged();
}

int KTransactionWidget::getCurrent()
{
  if ( (KTransactionListItem*)list->selectedItem() )
    return ((KTransactionListItem*)list->selectedItem())->tid();
  else
    return -1;
}

void KTransactionWidget::slotDeleteTransaction()
{
  if ( (KTransactionListItem*)list->selectedItem() )
    m_doc->deleteTransaction(((KTransactionListItem*)list->selectedItem())->tid());
  slotSelectionChanged();
}

void KTransactionWidget::slotAccountChanged(int id)
{
  if ( id == m_account )
    select(m_sMonth, m_sYear);
  slotSelectionChanged();
}

void KTransactionWidget::slotContextMenuRequested(QListViewItem*, const QPoint &p, int)
{
  emit contextMenuRequested(p);
}

void KTransactionWidget::slotTransactionRename()
{
  list->selectedItem()->startRename(3);
}

void KTransactionWidget::slotSelectionChanged()
{
  if ( list->selectedItem() )
    emit transactionFuncsEnabled(true);
  else
    emit transactionFuncsEnabled(false);
}

void KTransactionWidget::select(int month, int year)
{
  list->clear();

  // TODO: set caption appropriately when month || year
  
  QValueList<int> txids;
  float dTotal=0, cTotal=0;
  if ( m_account >= 0 ) {
    Account& acct = m_doc->getAccount(m_account);
    txids = acct.getTransactions(month, year);
    for ( unsigned int i = 0; i < txids.size(); i++ ) {
      Transaction& tx = m_doc->getTransaction(txids[i]);
      new KTransactionListItem(list, &tx, m_account);
      if ( tx.from() == m_account )
        dTotal += tx.value();
      else if ( tx.to() == m_account )
        cTotal += tx.value();
    }
  }

  KTransactionListItem* s = new KTransactionListItem(list);
  s->setSortPriority(1);
  s->setSelectable(false);
  total = new KTransactionListItem(list);
  total->setSortPriority(2);
  total->setTotals(dTotal, cTotal);
  total->setSelectable(false);

  list->setSorting(0);
  list->sort();

  m_sMonth = month;
  m_sYear = year;
}
