#ifndef __KMTRACE_SUPPRESSION__H__
#define __KMTRACE_SUPPRESSION__H__

// Qt includes
#include <qobject.h>
#include <qstring.h>

// kmtraceviewer includes

typedef enum {
   MatchByString,
   Comment
} KMtraceSuppressionMethod;

class KMtraceSuppression : public QObject
{
   Q_OBJECT
   
   public:
      KMtraceSuppression( QString string, KMtraceSuppressionMethod method );

      QString getLeakType( );
      KMtraceSuppressionMethod getMethod( );
      QString getMethodAsString( );
      QString getDescription( );

      void setView( QObject *view );
      QObject *getView( );

   protected:
      // method to match, only strings and comments are supported at the
      // moment
      KMtraceSuppressionMethod method;

      // only string matching is supported at the moment
      QString string;

      // the view to the model (only one)
      QObject *view;
};

#endif
