#!/usr/bin/perl -w

# adapt author list here:
%emails = (
   'abaumann'=> 'andreas_baumann@users.sourceforge.net'
);

%names = (
   'abaumann' => 'Andreas Baumann'
);

@log = ( );
@loglines = ( );
$version = 0;

# our ChangeLog is stored in PRCS
open INFO, "prcs info -l KMTRACEVIEWER |";
while( 1 ) {
   $line = <INFO>;
   last if( !( defined $line ) );
   
   # filter what we don't want
   next if( $line =~ /^Parent-Version:/ );
   next if( $line =~ /^Version-Log:/ );
   next if( $line =~ /^Project-Description:/ );
   next if( $line =~ /^$/ );
   
   if( $line =~ /^KMTRACEVIEWER\s([\S]+)\s\S+,\s+(\d{2,2} \S{3,3} \d{4,4}).*by\s(\S+)/ ) {
      $revision = $1;
      $date = $2;
      $id = $3;
      $version++;
      
      $line = "$date  ";
      foreach $prcsId ( keys %names ) {
         if( $id eq $prcsId ) {
	    $line = "$date, $revision  $names{$prcsId}  <$emails{$prcsId}>\n";
	 }
      }
   }
   
   $loglines[$version]++;
   $log[$version] .= $line;
}
close INFO;

open CHANGELOG, "> ChangeLog";
for( $i = $#log; $i > 0; $i-- ) {
   if( $loglines[$i] > 1 ) {
      print CHANGELOG "$log[$i]\n";
   }
}
close CHANGELOG;
