/**
 * buttons.c
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include <stdlib.h>
#include <gtk/gtk.h>

#include <kfiledialog.h>
#include <kmessagebox.h>
#include <qinputdialog.h>
#include <qstring.h>
#include "qtgtk.h"


/* Our usual callback function */
void callback( GtkWidget */*widget*/,
               gpointer   data )
{
    QString text = KFileDialog::getOpenFileName();

    if ( !text.isEmpty() ) {
        KMessageBox::information( 0, text, "Your Path" );
        g_print( "Hello again - %s was pressed, dialog returned: %s\n", (char *) data, text.latin1() );
    }
    else {
        g_print( "Error!" );
    }
}

void callback2( GtkWidget */*widget*/,
                gpointer   /*data*/ )
{
    KMessageBox::information( 0, "Hey sample message box", "Message box" );
    g_print( "k" );
}

int main( int   argc,
          char *argv[] )
{
    /* GtkWidget is the storage type for widgets */
    GtkWidget *window;
    GtkWidget *button1;
    GtkWidget *button2;
    GtkWidget *box;

    gtk_init( &argc, &argv );
    qtgtk_init( 0 );
    /* Create a new window */
    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );

    gtk_window_set_title( GTK_WINDOW( window ), "KDE Integration Buttons!");

    /* It's a good idea to do this for all windows. */
    g_signal_connect( G_OBJECT( window ), "destroy",
	              G_CALLBACK( gtk_main_quit ), NULL );

    g_signal_connect( G_OBJECT( window ), "delete_event",
	 	      G_CALLBACK( gtk_main_quit ), NULL );

    /* Sets the border width of the window. */
    gtk_container_set_border_width( GTK_CONTAINER( window ), 10 );

    /* Create a new button */
    button1 = gtk_button_new_with_label( "File dialog" );
    button2 = gtk_button_new_with_label( "Message box" );

    /* Connect the "clicked" signal of the button to our callback */
    g_signal_connect( G_OBJECT( button1 ), "clicked",
		      G_CALLBACK( callback ), (gpointer)"cool button" );
    g_signal_connect( G_OBJECT( button2 ), "clicked",
		      G_CALLBACK( callback2 ), (gpointer)"cool button" );

    box = gtk_hbox_new( FALSE, 0 );
    gtk_container_set_border_width( GTK_CONTAINER( box ), 2 );

    gtk_box_pack_start( GTK_BOX( box ), button1, FALSE, FALSE, 3 );
    gtk_box_pack_start( GTK_BOX( box ), button2, FALSE, FALSE, 3 );

    gtk_widget_show( button1 );
    gtk_widget_show( button2 );
    gtk_widget_show( box );

    gtk_container_add( GTK_CONTAINER( window ), box );

    gtk_widget_show( window );

    /* Rest in gtk_main and wait for the fun to begin! */
    gtk_main();

    return 0;
}
