/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kgenericfactory.h>

// WorKflow includes
#include "filelibrary.h"
#include "commandfactory.h"

// commands
#include "askforfilescommand.h"
#include "askforfolderscommand.h"
#include "getfilescommand.h"
#include "copyfilescommand.h"
#include "movefilescommand.h"
#include "listfoldercontentscommand.h"
#include "deletefilescommand.h"

using namespace WorKflow;

typedef KGenericFactory<FileLibrary> LibraryFactory;
K_EXPORT_COMPONENT_FACTORY(libworkflow_filecommands, LibraryFactory("libworkflow_filecommands"))

FileLibrary::FileLibrary(QObject* parent, const char* name, const QStringList& args)
  : Library(parent, name, args)
{
}

FileLibrary::~FileLibrary()
{
}

void FileLibrary::init()
{
  addCommandFactory(new CommandFactory<AskForFilesCommand>("org.kde.File.AskForFiles"));
  addCommandFactory(new CommandFactory<AskForFoldersCommand>("org.kde.File.AskForFolders"));
  addCommandFactory(new CommandFactory<GetFilesCommand>("org.kde.File.GetFiles"));
  addCommandFactory(new CommandFactory<CopyFilesCommand>("org.kde.File.CopyFiles"));
  addCommandFactory(new CommandFactory<MoveFilesCommand>("org.kde.File.MoveFiles"));
  addCommandFactory(new CommandFactory<ListFolderContentsCommand>("org.kde.File.ListFolderContents"));
  addCommandFactory(new CommandFactory<DeleteFilesCommand>("org.kde.File.DeleteFiles"));
}

#include "filelibrary.moc"
