/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>
#include <ktrader.h>
#include <kregexpeditorinterface.h>
#include <kparts/componentfactory.h>

// Qt includes
#include <qdialog.h>
#include <qpushbutton.h>

// WorKflow includes
#include "lineedit.h"

// command includes
#include "filterlistwidget.h"

using namespace WorKflow;

FilterListWidget::FilterListWidget(Command* command)
  : FilterListWidgetBase(0)
{
  setCommand(command);
  bool installed = !KTrader::self()->query("KRegExpEditor/KRegExpEditor").isEmpty();
  if (!installed) {
    m_editRegExpButton->hide();
  }
}

FilterListWidget::~FilterListWidget()
{
}

void FilterListWidget::editRegExp()
{
  QDialog* editorDialog = KParts::ComponentFactory::createInstanceFromQuery<QDialog>("KRegExpEditor/KRegExpEditor");
  if (editorDialog) {
    KRegExpEditorInterface* editor = static_cast<KRegExpEditorInterface*>(editorDialog->qt_cast("KRegExpEditorInterface"));
    Q_ASSERT(editor);

    editor->setRegExp(m_filterEdit->text());
    if (editorDialog->exec()) {
      m_filterEdit->setText(editor->regExp());
    }
  } else {
    kdWarning() << "Could not run regexp editor!" << endl;
  }
}

#include "filterlistwidget.moc"
