/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#include "result.h"
#include "parameter.h"
#include "document.h"

#include "foreachcommand.h"

using namespace WorKflow;

ForEachCommand::ForEachCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  setContainer(true);
}

ForEachCommand::~ForEachCommand()
{
}

void ForEachCommand::execute()
{
  QStringList list = value("input").asStringList();
  Value out(output()->typeId());

  int rows = childDocument()->numRows();
  if (!rows) {
    Command::execute();
    return;
  }

  for (QStringList::ConstIterator i = list.begin(); i != list.end(); ++i) {
    Command* first = childDocument()->commandAt(0);
    if (first->input())
      first->input()->setStaticValue(Value::singleString(parameter("input")->typeId(), *i));

    childDocument()->execute();

    Command* last = childDocument()->commandAt(rows - 1);
    if (last->output())
      out.addStringList(last->output()->value().asStringList());
  }

  setResult("output", out);
}

#include "foreachcommand.moc"
