/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// designer includes
#include "servicelistitem.h"

ServiceListItem::ServiceListItem(QListView* parent)
  : QListViewItem(parent, parent->lastItem()), m_kind(HandleDrops)
{
  update();
}


ServiceListItem::~ServiceListItem()
{
}

ServiceListItem::Kind ServiceListItem::kind()
{
  return m_kind;
}

QString ServiceListItem::mimeType()
{
  return m_mimeType;
}

QString ServiceListItem::parameter()
{
  return m_parameter;
}

QString ServiceListItem::application()
{
  return m_application;
}

QString ServiceListItem::command()
{
  return m_command;
}

QString ServiceListItem::message()
{
  return m_message;
}

QString ServiceListItem::addButton()
{
  return m_addButton;
}

QString ServiceListItem::dontAddButton()
{
  return m_dontAddButton;
}

void ServiceListItem::setKind(Kind kind)
{
  m_kind = kind;
  update();
}

void ServiceListItem::setMimeType(const QString& mimeType)
{
  m_mimeType = mimeType;
  update();
}

void ServiceListItem::setParameter(const QString& param)
{
  m_parameter = param;
  update();
}

void ServiceListItem::setApplication(const QString& app)
{
  m_application = app;
  update();
}

void ServiceListItem::setCommand(const QString& cmd)
{
  m_command = cmd;
  update();
}

void ServiceListItem::setMessage(const QString& msg)
{
  m_message = msg;
  update();
}

void ServiceListItem::setAddButton(const QString& add)
{
  m_addButton = add;
  update();
}

void ServiceListItem::setDontAddButton(const QString& dont)
{
  m_dontAddButton = dont;
  update();
}

void ServiceListItem::update()
{
  switch (m_kind) {
    case HandleDrops:
      setText(0, i18n("Handles drops of type \"%1\" (stored in parameter \"%2\")").arg(m_mimeType).arg(m_parameter));
      break;
    case StartApplication:
      setText(0, i18n("Starts application \"%1\"").arg(m_application));
      break;
    case ModifyData:
      setText(0, i18n("Modifies data (Helper Command: \"%1\")").arg(m_command));
      break;
  }
}
