/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include <workflow/document.h>
#include <workflow/applicationmanager.h>

// command includes
#include "setselectedtextinkatecommand.h"
#include "setselectedtextinkatewidget.h"
#include "kateapplication.h"

using namespace WorKflow;

SetSelectedTextInKateCommand::SetSelectedTextInKateCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  SetSelectedTextInKateWidget* w = new SetSelectedTextInKateWidget(this);
  setWidget(w);
}

SetSelectedTextInKateCommand::~SetSelectedTextInKateCommand()
{
}

void SetSelectedTextInKateCommand::execute()
{
  bool allIfNoSelection = value("allifnoselection").nextBoolean();

  Application* app = document()->appManager()->findRunning("org.kde.kate");
  if (app) {
    QStringList text = value("input").asStringList();
    KateApplication* kate = static_cast<KateApplication*>(app);

    // original text
    QString orig = kate->currentText();

    // replace text
    QString str = text.join("\n");
    if (!kate->setSelectedText(str) && allIfNoSelection)
      kate->setCurrentText(str);

    setResult("original", Value::stringList("org.kde.public.text", QStringList::split('\n', orig, true)));
  } else {
    // error
  }

  Command::execute();
}

#include "setselectedtextinkatecommand.moc"
