/***************************************************************************
 *   Copyright (C) 2004 by Enrico Ros <eros.kde@email.it>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _OKULAR_SEARCHWIDGET_H_
#define _OKULAR_SEARCHWIDGET_H_

#include <qtoolbar.h>

namespace Okular {
class Document;
}

class KLineEdit;
class QAction;
class QTimer;

/**
 * @short A widget for find-as-you-type search. Outputs to the Document.
 *
 * This widget accepts keyboard input and performs a call to findTextAll(..)
 * in the Okular::Document class when there are 3 or more chars to search for.
 * It supports case sensitive/unsensitive(default) and provieds a button
 * for switching between the 2 modes.
 */
class SearchWidget : public QToolBar
{
    Q_OBJECT
    public:
        SearchWidget( QWidget *parent, Okular::Document *document );
        void clearText();

    private:
        Okular::Document * m_document;
        QMenu * m_menu;
        QTimer * m_inputDelayTimer;
        int m_searchType;
        QAction *m_matchPhraseAction, *m_caseSensitiveAction, * m_marchAllWordsAction, *m_marchAnyWordsAction;
        KLineEdit *m_lineEdit;

    private slots:
        void slotTextChanged( const QString & text );
        void slotMenuChaged( QAction * );
        void startSearch();
};

#endif
