/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef RECEIVER_H
#define RECEIVER_H


#include <QtNetwork>
#include <QtGui>
#include <QtDBus>
#include <KIcon>
#include <KMessageBox>
#include <KNotification>
#include <klocale.h>

#include "receiverinfo.h"


class KDE_EXPORT Receiver : public QWidget
{
Q_OBJECT

public:
	 Receiver(QWidget* parent = 0);
	 ~Receiver();

	 void setTargetPath(QString);
	 QString getTargetPath();
	 

private:
	 quint16 peerPort;
	 QString peerAddr;
	 QTcpSocket* m_sock;
	 QHttp* http;
	

	 QString userName;
	 QString fileName;
	 QString fileSize;
	 QString hostName;
	 QString uuid;
	 QString fullclip;

	 QString targetPath;

	 QMessageBox* dialog;
	 QPushButton* acceptButton;
	 QPushButton* denyButton;
	 QProgressDialog* progress;
	
	 QFile* saveTo;
	 QDBusConnection* dbus;
	 
	 QVector<ReceiverInfo*>* recVec;
	 ReceiverInfo* info;
	 ReceiverInfo* infoFound;
	 KNotification* recNotify;
	 long readall;
	
//	 QWidget* m_parent;

	 bool createNewPeer(QHttpRequestHeader& header, QString ip);
	 
	 void notifyUser(QHttpRequestHeader& header, QTcpSocket*);
	 void notifyClipAccess(QHttpRequestHeader& header, QTcpSocket* sock);
	 void notifyClipReceived(QHttpRequestHeader& header, QTcpSocket* sock);

	 bool checkID(QHttpRequestHeader&);
	 void sendPayloadReceived(QTcpSocket* sock);
	 void sendClipBoard(QTcpSocket* sock, QString id);
	 void setClipActive(QString clipEntry);




public slots:
	void hostLookedUp(QHostInfo);
	void sendOKToPayLoad(QTcpSocket*);
	void sendOKToPayLoadClip(QTcpSocket*);
	void sendDeny(QTcpSocket*);
	void slotDataReceiveProgress(long);
	void slotReceiveData();
	void defReqType(QTcpSocket* sock);
	void headRead();
	void slotTransferAccepted(unsigned int);
	void slotClipAccepted(unsigned int);






};

#endif
