<?php
/**
 * Login screen for IMP.
 *
 * The following parameters for 'reasons' are recognized:
 *   'failed'   --  Login failed for some reason
 *   'login'    --  Perform login (DEFAULT)
 *   'logout'   --  Logout due to user request
 *   'session'  --  Logout due to session expiration
 *
 * $Horde: imp/login.php,v 2.184 2003/07/16 22:06:01 slusarz Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('IMP_BASE', dirname(__FILE__));
$authentication = 'none';
require_once IMP_BASE . '/lib/base.php';
require IMP_BASE . '/config/servers.php';

/* Map the various values for $reason to more descriptive status messages. */
$reasons = array(
    'session' => sprintf(_("Your %s session has expired. Please login again."), $registry->getParam('name')),
    'logout'  => _("You have been logged out.<br />Thank you for using the system."),
    'failed'  => _("Login failed for some reason. Most likely your username or password was entered incorrectly.")
);

/* Get an Auth object. */
$imp_auth = (Auth::getProvider() == 'imp');
$auth = &Auth::singleton($conf['auth']['driver']);

/* Get the actionID, checking for the action=compose variable. */
$actionID = Horde::getFormData('actionID');
if (Horde::getFormData('action') == 'compose') {
    $actionID = 'login_compose';
}

/* Default the reason to 'login'. */
$reason = Horde::getFormData('reason', 'login');

/* Handle cases where we already have a session. */
if (!empty($_SESSION['imp']) && is_array($_SESSION['imp'])) {
    switch ($reason) {
    case 'logout':
    case 'session':
        $entry = sprintf('Logout for %s [%s] from {%s:%s}',
                         $_SESSION['imp']['uniquser'],
                         $_SERVER['REMOTE_ADDR'], $_SESSION['imp']['server'],
                         $_SESSION['imp']['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_NOTICE);

        $language = (isset($prefs)) ? $prefs->getValue('language') : NLS::select();

        unset($_SESSION['imp']);

        if ($imp_auth) {
            $prefs->cleanup(true);
            Auth::clearAuth();
            session_destroy();
            Horde::setupSessionHandler();
            @session_start();
        } else {
            $prefs->cleanup();
        }

        NLS::setLang($language);

        /* Hook to preselect the correct language in the widget. */
        $_GET['new_lang'] = $language;

        $registry->loadPrefs('horde');
        $registry->loadPrefs();

        break;

    case 'failed':
        unset($_SESSION['imp']);
        if ($imp_auth) {
            Auth::clearAuth();
        }
        break;

    default:
        $url = Horde::applicationUrl('mailbox.php', true);
        if ($actionID == 'login_compose') {
            $url = Horde::addParameter($url, 'actionID', 'login_compose');
            $url = Horde::addParameter($url, IMP::getComposeArgs());
        }
        header('Location: ' . $url);
        exit;
        break;
    }
}

/* Log session timeouts. */
if ($reason == 'session') {
    $entry = sprintf('Session timeout for client [%s]', $_SERVER['REMOTE_ADDR']);
    Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_INFO);

    /* Make sure everything is really cleared. */
    Auth::clearAuth();
    unset($_SESSION['imp']);
}

/* Redirect the user on logout if redirection is enabled. */
if (($reason == 'logout') && $conf['user']['redirect_on_logout']) {
    $url = Horde::addParameter($conf['user']['redirect_on_logout'], 'reason', 'logout');
    header('Location: ' . $url);
    exit;
}

/* Redirect the user if an alternate login page has been specified. */
if (in_array($reason, array('login', 'failed', 'session', 'logout')) &&
    $conf['user']['alternate_login']) {
    $url = Horde::addParameter($conf['user']['alternate_login'], 'reason', $reason);
    header('Location: ' . $url);
    exit;
}

/* Initialize the password key(s). If we are doing Horde auth as well,
 * make sure that the Horde auth key gets set. */
Secret::setKey('imp');
if ($imp_auth) {
    Secret::setKey('auth');
}

$title = 'Welcome to the Kolab WebClient'; //sprintf(_("Welcome to %s"), $registry->getParam('name', ($imp_auth) ? 'horde' : null));
$js_onLoad = 'setFocus()';
$formAction = 'redirect.php';
$formData = null;

require IMP_TEMPLATES . '/common-header.inc';
require IMP_TEMPLATES . '/login/login.inc';
if (@is_readable(IMP_BASE . '/config/motd.php')) {
    require IMP_BASE . '/config/motd.php';
}
require IMP_TEMPLATES . '/common-footer.inc';
