<?php
/**
 * $Horde: imp/search.php,v 2.103 2003/08/20 23:58:59 jan Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * URL Parameters:
 * ---------------
 * 'mailbox'  --  If exists, don't show the folder selection list; use the
 *                passed in mailbox value instead.
 */

/* Defines used to determine what kind of field query we are dealing with. */
define('IMP_SEARCH_HEADER', 1);
define('IMP_SEARCH_BODY', 2);
define('IMP_SEARCH_DATE', 3);

/* Defines used to identify the flag input. */
define('IMP_SEARCH_FLAG_SEEN', 1);
define('IMP_SEARCH_FLAG_ANSWERED', 2);
define('IMP_SEARCH_FLAG_FLAGGED', 3);
define('IMP_SEARCH_FLAG_DELETED', 4);

/* The base search fields. */
$fields = array(
    'from' => array(
        'label' => _("From"),
        'type' => IMP_SEARCH_HEADER
    ),
    'to' => array(
        'label' => _("To"),
        'type' => IMP_SEARCH_HEADER
    ),
    'cc' => array(
        'label' => _("Cc"),
        'type' => IMP_SEARCH_HEADER
    ),
    'bcc' => array(
        'label' => _("Bcc"),
        'type' => IMP_SEARCH_HEADER
    ),
    'subject' => array(
        'label' => _("Subject"),
        'type' => IMP_SEARCH_HEADER
    ),
    'body' => array(
       'label' => _("Body"),
       'type' => IMP_SEARCH_BODY
    ),
    'received_on' => array(
        'label' => _("Received On"),
        'type' => IMP_SEARCH_DATE
    ),
    'received_until' => array(
        'label' => _("Received Until"),
        'type' => IMP_SEARCH_DATE
    ),
    'received_since' => array(
        'label' => _("Received Since"),
        'type' => IMP_SEARCH_DATE
    )
);

define('IMP_BASE', dirname(__FILE__));
$authentication = OP_HALFOPEN;
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Folder.php';
require_once HORDE_BASE . '/lib/Widgets.php';

/* Get URL parameter data. */
$search_field = Horde::getFormData('field', array());
if (!empty($search_field) && !end($search_field)) {
    array_pop($search_field);
}
$search_field_end = count($search_field);
$mbox_param = Horde::getFormData('mailbox');

$search_match = Horde::getFormData('search_match');
$search_text = Horde::getFormData('search_text');
$search_text_not = Horde::getFormData('search_text_not');
$search_date = Horde::getFormData('search_date');
$search_flag = Horde::getFormData('search_flag');
$search_folders = Horde::getFormData('search_folders', array());

$curr_date = getdate();

/* Run through the action handlers. */
$actionID = Horde::getFormData('actionID');
switch ($actionID) {
case 'do_search':
    /* Create the search query. */
    require_once HORDE_BASE . '/lib/IMAP/Search.php';
    $query = &new IMAP_Search_Query();

    /* Flag searches. */
    $flag_names = array(
        IMP_SEARCH_FLAG_SEEN => 'seen',
        IMP_SEARCH_FLAG_ANSWERED => 'answered',
        IMP_SEARCH_FLAG_FLAGGED => 'flagged',
        IMP_SEARCH_FLAG_DELETED => 'deleted'
    );
    foreach ($search_flag as $key => $val) {
        $flag = $flag_names[$key];
        switch ($val) {
        case 0:
            $query->$flag(false);
            break;
        case 1:
            $query->$flag(true);
            break;
        }
    }

    /* Field searches. */
    $search_array = array();
    foreach ($search_field as $key => $val) {
        $ob = &new IMAP_Search_Query();
        switch ($fields[$val]['type']) {
        case IMP_SEARCH_HEADER:
            if (!empty($search_text[$key])) {
                $ob->header($val, $search_text[$key], $search_text_not[$key]);
                $search_array[] = &$ob;
            }
            break;

        case IMP_SEARCH_BODY:
            if (!empty($search_text[$key])) {
                $ob->body($search_text[$key], $search_text_not[$key]);
                $search_array[] = &$ob;
            }
            break;

        case IMP_SEARCH_DATE:
            if (!empty($search_date[$key]['day']) &&
                !empty($search_date[$key]['month']) &&
                !empty($search_date[$key]['year'])) {
                if ($val == 'received_on') {
                    $ob->on($search_date[$key]['day'], $search_date[$key]['month'], $search_date[$key]['year']);
                } elseif ($val == 'received_until') {
                    $ob->before($search_date[$key]['day'], $search_date[$key]['month'], $search_date[$key]['year']);
                } elseif ($val == 'received_since') {
                    $ob->since($search_date[$key]['day'], $search_date[$key]['month'], $search_date[$key]['year']);
                }
                $search_array[] = &$ob;
            }
            break;
        }
    }

    /* Search match. */
    if ($search_match == 'and') {
        $query->imapAnd($search_array);
    } elseif ($search_match == 'or') {
        $query->imapOr($search_array);
    }

    /* Set the search query in the imp session. */
    require_once IMP_BASE . '/lib/Search.php';
    IMP_Search::createSearchQuery($query, $search_folders);

    /* Redirect to the Mailbox Screen. */
    $url = Horde::applicationUrl('mailbox.php');
    $url = Horde::addParameter($url, 'mailbox', IMP_SEARCH_MBOX);
    header('Location: ' . $url);
    exit;
    break;

case 'reset_search':
    $search_field = array();
    $search_field_end = 0;
    $search_match = null;
    $search_date = $search_text = $search_text_not = $search_flag = array();
    $search_folders = array();
    break;

case 'delete_field':
    $key = Horde::getFormData('delete_field_id');

    /* Unset all entries in array input and readjust ids. */
    $vars = array('search_field', 'search_text', 'search_text_not',
                  'search_date');
    foreach ($vars as $val) {
        unset(${$val}[$key]);
        if (!empty($$val)) {
            $$val = array_values($$val);
        }
    }
    $search_field_end = count($search_field);
    break;
}

$title = _("Message Search");
$js_onLoad = null;

require IMP_TEMPLATES . '/common-header.inc';
IMP::menu();
IMP::status();
require_once IMP_TEMPLATES . '/search/javascript.inc';
require IMP_TEMPLATES . '/search/header.inc';

/* Process the list of fields. */
for ($i = 0; $i <= $search_field_end; $i++) {
    $last_field = ($i == $search_field_end);
    $curr_field = (isset($search_field[$i])) ? $search_field[$i] : null;
    require IMP_TEMPLATES . '/search/fields.inc';
}

$newcol = 1;
$numcolumns = 1;
$folderlist = '';
$imp_folder = &IMP_Folder::singleton();

if (!$mbox_param) {
    $mailboxes = $imp_folder->flist_IMP();
    $total = ceil(count($mailboxes) / 3);

    if (empty($search_folders)) {
        $search_folders[] = 'INBOX';
    }

    foreach ($mailboxes as $mbox) {
        if (!empty($mbox['val'])) {
            $newcol++;
            $label = htmlspecialchars($mbox['val']);
            $folderlist .= '<input id="' . $label . '" type="checkbox" name="search_folders[]" value="' . $label . '"';
            if (in_array($mbox['val'], $search_folders)) {
                $folderlist .= ' checked="checked"';
            }
            $folderlist .= " />\n" . Horde::label($label, str_replace(' ', '&nbsp;', htmlspecialchars($mbox['label'])), '') . "<br />\n";

            if (($newcol > $total) && ($numcolumns != 3)) {
                $newcol = 1;
                $numcolumns++;
                $folderlist .= "</td>\n" . '<td class="control" valign="top" align="left">';
            }
        }
    }
}

require IMP_TEMPLATES . '/search/main.inc';
require IMP_TEMPLATES . '/common-footer.inc';
