<?php
/**
 * $Horde: horde/lib/Block/time.php,v 1.3 2003/08/19 21:36:34 jan Exp $
 *
 * @package Horde
 */
class Horde_Block_time extends Horde_Block {

    /**
     * Constructor.
     */
    function Horde_Block_time($params = array())
    {
        $this->_params = $params;
        $this->_app = 'horde';
        $this->_type = 'time';
    }

    /**
     * Does this block have any user editable parameters?
     *
     * @return boolean  True is there are editable parameters.
     *                  False if there are not.
     */
    function isEditable()
    {
        return true;
    }

    /**
     * The title to go in this block.
     *
     * @return string   The title text.
     */
    function _title()
    {
        return _("Current Time");
    }

    /**
     * The content to go in this block.
     *
     * @return string   The content
     */
    function _content()
    {
        $html = '<table width="100%" height="100%"><tr><td style="font-family:verdana;font-size:18px;" align="center" valign="center">';
        $html .= strftime('%A, %B %d, %Y ');
        if ($this->_params['time'] == '24-hour') {
            $html .= strftime('%H:%M');
        } else {
            $html .= strftime('%l:%M %p');
        }
        $html .= '</td></tr></table>';

        return $html;
    }

}
