<?php
/**
 * The MIME_Viewer_ooo class renders out OpenOffice.org
 * documents in HTML format.
 *
 * $Horde: horde/lib/MIME/Viewer/ooo.php,v 1.7 2003/05/10 13:36:19 jan Exp $
 *
 * Copyright 2003 Marko Djukic <marko@oblo.com>
 * Copyright 2003 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Marko Djukic <marko@oblo.com>
 * @author  Jan Schneider <jan@horde.org>
 * @version $Revision: 1.7 $
 * @since   Horde 3.0
 * @package horde.mime.viewer
 */
class MIME_Viewer_ooo extends MIME_Viewer {

    /**
     * Render out the current data.
     *
     * @access public
     *
     * @param optional array $params  Any parameters the Viewer may need.
     *
     * @return string  The rendered contents.
     */
    function render($params = array())
    {
        $use_xslt = Horde::extensionExists('xslt') || function_exists('domxml_xslt_stylesheet_file');
        if ($use_xslt) {
            $tmpdir = Horde::createTempDir(true);
        }

        require_once HORDE_BASE . '/lib/Compress.php';
        $xml_tags  = array('text:p', 'table:table ', 'table:table-row', 'table:table-cell', 'table:number-columns-spanned=');
        $html_tags = array('p', 'table border="0" cellspacing="1" cellpadding="0" ', 'tr bgcolor="#cccccc"', 'td', 'colspan=');
        $zip = &Horde_Compress::singleton('zip');
        $list = $zip->decompress($this->mime_part->getContents(),
            array('action' => HORDE_COMPRESS_ZIP_LIST));
        foreach ($list as $key => $file) {
            if ($file['name'] == 'content.xml' ||
                $file['name'] == 'styles.xml' ||
                $file['name'] == 'meta.xml') {
                $content = $zip->decompress($this->mime_part->getContents(),
                    array('action' => HORDE_COMPRESS_ZIP_DATA,
                          'info'   => $list,
                          'key'    => $key));
                if ($use_xslt) {
                    $fp = fopen($tmpdir . $file['name'], 'w');
                    fwrite($fp, $content);
                    fclose($fp);
                } elseif ($file['name'] == 'content.xml') {
                    $content = str_replace($xml_tags, $html_tags, $content);
                    return $content;
                }
            }
        }
        if (!Horde::extensionExists('xslt')) {
            return;
        }

        if (function_exists('domxml_xslt_stylesheet_file')) {
            // Use DOMXML
            $xslt = domxml_xslt_stylesheet_file(HORDE_BASE . '/lib/MIME/Viewer/ooo/main_html.xsl');
            $dom  = domxml_open_file($tmpdir . 'content.xml');
            $result = $xslt->process($dom, array('metaFileURL' => $tmpdir . 'meta.xml', 'stylesFileURL' => $tmpdir . 'styles.xml', 'disableJava' => true));
            return $xslt->result_dump_mem($result);
        } else {
            // Use XSLT
            $xslt = xslt_create();
            $result = @xslt_process($xslt, $tmpdir . 'content.xml',
                                    HORDE_BASE . '/lib/MIME/Viewer/ooo/main_html.xsl', null, null,
                                    array('metaFileURL' => $tmpdir . 'meta.xml', 'stylesFileURL' => $tmpdir . 'styles.xml', 'disableJava' => true));
            if (!$result) {
                $result = xslt_error($xslt);
            }
            xslt_free($xslt);
            return $result;
        }
    }

    /**
     * Return the MIME content type of the rendered content.
     *
     * @access public
     *
     * @return string  The content type of the output.
     */
    function getType()
    {
        return 'text/html';
    }

}
