<?php
/**
 * $Horde: turba/addobject.php,v 1.29 2003/07/23 15:21:12 chuck Exp $
 *
 * Turba: Copyright 2000-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Form.php';
require_once TURBA_BASE . '/lib/Renderer.php';
require_once TURBA_BASE . '/lib/Source.php';
require_once TURBA_BASE . '/lib/ObjectView.php';
require_once TURBA_BASE . '/lib/AbstractObject.php';
require_once TURBA_BASE . '/lib/SelectSource.php';
require_once TURBA_BASE . '/lib/ObjectForm.php';

$renderer = &new Turba_Renderer();
$vars = &Horde_Form::getDefaultVars();
$target = null;

$source = $vars->getVar('source');
if (is_null($source) || !isset($cfgSources[$source])) {
    $default_source = $prefs->getValue('default_dir');

    foreach ($cfgSources as $key => $curSource) {
        if (empty($curSource['readonly']) || (isset($curSource['admin']) && in_array(Auth::getAuth(), $curSource['admin']))) {
            $sources[$key] = $curSource['title'];
        }
    }
    if (count($sources) == 0) {
        $notification->push(_("There are no writeable address books. None of the available address books are configured to allow you to add new entries to them. If you believe this is an error, please contact your system administrator."), 'horde.error');
    } elseif (count($sources) > 1) {
        $formobject = &Horde_Form::singleton('SelectSourceForm', $vars);
        $target = 'addobject.php';
    } else {
        $source = key($sources);
    }
}

if (!empty($source)) {
    $driver = &Turba_Source::singleton($source, $cfgSources[$source]);
    if (is_a($driver, 'PEAR_Error')) {
        $notification->push(_("Failed to connect to the specified directory."), 'horde.error');
    } else {
        $object = &new Turba_AbstractObject($driver);
        $view = &new Turba_ObjectView($object);

        $formname = $vars->getVar('formname');

        /* Get the form and set up the variables. */
        $formobject = &Horde_Form::singleton('ObjectForm', $vars, _("Add Object"));
        $view->setFormVariables($formobject);
        $vars->setVar('source', $source);

        /* Validate the form. */
        $formobject->validate($vars);

        if (!$formobject->isValid()) {
            /* Not valid, but if not yet submitted clear errors. */
            if ($formname != 'objectform') {
                $formobject->clearValidation();
            }

            $target = 'addobject.php';
        } else {
            /* Form valid, save data. */
            $formobject->getInfo($vars, $info);

            $source = $info['source'];
            $object = $info['object'];

            /* Create Object. */
            $key = $driver->addObject($object);
            if (!is_a($key, 'PEAR_Error')) {
                $vars->setVar('key', $key);
                $name = isset($object['name']) ? $object['name'] : _("Address book entry");
                $notification->push(sprintf(_("%s added."), $name), 'horde.success');
                $formobject->setTitle(sprintf(_("Edit %s"), $name));
                $target = 'editobject.php';
            } else {
                Horde::logMessage($key, __FILE__, __LINE__, PEAR_LOG_ERR);
                $notification->push(_("There was an error adding this object. Contact your system administrator for further help.") . $key->getMessage(), 'horde.error');

                $target = 'addobject.php';
            }
        }
    }
}

$title = _("Add a new contact");
$js_onLoad = 'var i = 0; while (document.forms[0].elements[i].type == \'hidden\') i++; document.forms[0].elements[i].focus();';
require TURBA_TEMPLATES . '/common-header.inc';
Turba::menu();

if (!empty($target)) {
    $formobject->renderActive($renderer, $vars, $target, 'post');
}

require TURBA_TEMPLATES . '/common-footer.inc';
