<?php
/**
 * $Horde: turba/advanced.php,v 1.45 2003/07/23 15:18:30 chuck Exp $
 *
 * Turba: Copyright 2000-2003 Charles J. Hagenbuch <chuck@horde.org>
 *        Copyright 2000-2003 Alcove, Christian Couder <christian@alcove.fr>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

$title = _("Advanced Search");
$js_onLoad = 'document.dirsearch.name.focus();';
require TURBA_TEMPLATES . '/common-header.inc';

/* Make sure the search session variable is registered in the session,
   and obtain a global-scope reference to it. */
if (!array_key_exists('turba_search_results', $_SESSION)) {
    $_SESSION['turba_search_results'] = null;
} else {
    if (Horde::getFormData('clear')) {
        $_SESSION['turba_search_results'] = null;
    } elseif (!empty($_SESSION['turba_search_results'])) {
        require_once TURBA_BASE . '/lib/List.php';
        require_once TURBA_BASE . '/lib/Object.php';
        $_SESSION['turba_search_results'] = Turba_List::unserialize($_SESSION['turba_search_results']);
    }
}

/* Run search if there is one. */
$source = Horde::getFormData('source');
if (!isset($source) && isset($cfgSources) && is_array($cfgSources) && count($cfgSources) > 0) {
    $source = $prefs->getValue('default_dir');
}
if (!isset($cfgSources[$source])) {
    reset($cfgSources);
    $source = key($cfgSources);
}

/* Build the directory sources select widget. */
if (count($cfgSources) > 1) {
    $source_options  = '<tr><td class="light" align="right"><b>' . _("Directory") . '</b></td>';
    $source_options .= '<td align="left"><select name="source" onchange="dirsearch.submit()">';
    foreach ($cfgSources as $key => $entry) {
        $selection = (isset($source) && $source == $key) ? ' selected="selected"' : '';
        $source_options .= "<option value=\"$key\"$selection>";
        $source_options .= $entry['title'] . "</option>\n";
    }
    $source_options .= '</select></td></tr>';
} else {
    $source_options = '<input type="hidden" name="source" value="';
    reset($cfgSources);
    $source_options .= key($cfgSources);
    $source_options .= '" />';
}

$driver = &Turba_Source::singleton($source, $cfgSources[$source]);
if (PEAR::isError($driver)) {
    $notification->push(_("Failed to connect to the specified directory."), 'horde.error');
    $map = array();
} else {
    $map = $driver->getCriteria();

    $criteria = array();
    foreach ($map as $key => $value) {
        if ($key != '__key') {
            $val = Horde::getFormData($key);
            if (!empty($val)) {
                $criteria[$key] = $val;
            }
        }
    }

    if (count($criteria)) {
        if (is_object($results = $driver->search($criteria))) {
            if (!is_object($_SESSION['turba_search_results'])) {
                $_SESSION['turba_search_results'] = new Turba_List();
            }
            $_SESSION['turba_search_results']->merge($results);
        } else {
            $notification->push(sprintf(_("Failed to search the directory: %s"), ''), 'horde.error');
        }
    }
}

// Read the columns to display from the preferences.
$sources = Turba::string2Columns($GLOBALS['prefs']->getValue('columns'));
$columns = isset($sources[$source]) ? $sources[$source] : array();
$width = floor(100 / (count($columns) + 1));

Turba::menu();
require TURBA_TEMPLATES . '/advanced/head.inc';

foreach ($map as $name => $v) {
    if ($name != '__owner' &&
        $name != '__type' &&
        $name != '__members') {
        require TURBA_TEMPLATES . '/advanced/criteria.inc';
    }
}

$addresses = Horde::getFormData('addresses');
if (is_object($_SESSION['turba_search_results']) &&
    ($_SESSION['turba_search_results']->count() > 0)) {
    require TURBA_TEMPLATES . '/advanced/results_head.inc';
}

$numDisplayed = 0;
if (is_object($_SESSION['turba_search_results']) &&
    ($_SESSION['turba_search_results']->count() > 0)) {
    require_once TURBA_BASE . '/lib/ListView.php';
    $display = new Turba_ListView($_SESSION['turba_search_results'], TURBA_TEMPLATES . '/browse/contactrow.inc');
    $numDisplayed = $display->display();
    $_SESSION['turba_search_results'] = $_SESSION['turba_search_results']->serialize();
}

require TURBA_TEMPLATES . '/advanced/foot.inc';
require TURBA_TEMPLATES . '/common-footer.inc';
