/* multi.c -- local hacks at UNINETT by Sigmund Austigard 1992 */
/*
 *                         COPYRIGHT 1992
 *                            UNINETT
 *                       TRONDHEIM, NORWAY
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY UNINETT. UNINETT MAKES NO
 * REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Uninett not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission.
 *
 */

/* 
 * Some parts of this file is code modified from code copyright 1987, 1989
 * Digital Equipment Corporation, and copyright 1991 Carnegie Mellon
 * University, Software Engineering Institute.
 */


#ifdef MULTI

#include <malloc.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/Xaw/Cardinals.h>
#include "xmh.h"

#include "multi.h"
#include "tocintrnl.h"

static Switches *InitSwitches()
{
    Switches *switches = (Switches *)XtMalloc(sizeof(Switches));

    switches->contentType  = text;
    switches->contentSub   = plain;
    switches->encoding     = bit7;
    switches->charset      = usascii;
    switches->needBoundary = FALSE;
    switches->boundary     = NULL;
    
    return switches;
}


static void decodeQuotedString(here)
String here;
{
    char *res;
    
    for (res = here; *here; here++, res++) {
	if (*here == '=') {
	    char tmp[3];
	    char *help;
	    int i = 0;
	    int hexbuf;
	    

	    help = here + 1;
	    while (isxdigit(*help) && i < 2)
		tmp[i++] = *help++;

	    tmp[i] = '\0';

	    if (i != 2) {
		if (i == 0 && *(help) == '\n') {
		    here++;
		    res--;
		    continue;
		}
		else {
		    *res = *here;
		    continue;
		}
	    }
	    sscanf(tmp, "%x", &hexbuf);
	    *res = (u_char)hexbuf;
	    here = help - 1;
	
	}
	else {
	*res = *here;
	}

    }
	*(res) = '\0';

    return;
}

static String encodeQuotedString(buf)
unsigned char *buf;
{
    String res;
    String here;
    Cardinal left;
    Cardinal segs;
    Cardinal curlen = 0;

    here = res = XtMalloc(SEGMENTSIZE);
    segs = 1;
    left = SEGMENTSIZE;

    while(*buf) {
	if (left < 8) {
	    long diff;

	    diff = here - res;
 	    res = XtRealloc(res, (long)(++segs * SEGMENTSIZE));
	    left = left + SEGMENTSIZE;
	    here = res + diff;
	}
	if (*buf == '=' || *buf >= 127) {
	    if (curlen >= 73) {
		*here++ = '=';
		*here++ = '\n';
		left -= 2;
		curlen = 0;
	    }
	    *here++ = '=';
	    sprintf(here, "%X", *buf++);
	    here += 2;
	    left -= 3;
	    curlen += 3;
	}
	else if (*buf == '\n') {
	    if (curlen && (*(here - 1) == ' ' || *(here - 1) == '\t')) {
		char tmp;
		here--;
		tmp = *here;
		
		if (curlen >= 74) {
		    *here++ = '=';
		    *here++ = '\n';
		    left -= 2;
		}
		else {
		    *here++ = '=';
		    sprintf(here, "%X", tmp);
		    here += 2;
		    left -= 2;
		}
	    }
	    *here++ = *buf++;
	    left--;
	    curlen = 0;
	}
	else {
	    if (curlen >= 75) {
		*here++ = '=';
		*here++ = '\n';
		left -= 2;
		curlen = 0;
	    }
	    *here++ = *buf++;
	    left--;
	    curlen++;
	}
    }
    *here = '\0';
    return res;
} 


static Cardinal decodeBase64(start)
unsigned char *start;
{
    unsigned char *res, *help, *here;
    Cardinal cnt = 0;
    int value, modulo;
            
/*
 * These values are not fully utilized at present
 */
#define B64PAD -1
#define B64ERR -2

    static int lookup[128] = { 
	B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, 
	B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, 
	B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, 
	B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR,
	B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR, B64ERR,
	B64ERR, B64ERR, B64ERR, 62,     B64ERR, B64ERR, B64ERR, 63,
	52,     53,     54,     55,     56,     57,     58,     59,
	60,     61,     B64ERR, B64ERR, B64ERR, B64PAD, B64ERR, B64ERR, 
	B64ERR, 0,      1,      2,      3,      4,      5,      6,
	7,      8,      9,      10,     11,     12,     13,     14,
	15,     16,     17,     18,     19,     20,     21,     22,
	23,     24,     25,     B64ERR, B64ERR, B64ERR, B64ERR, B64ERR,
	B64ERR, 26,     27,     28,     29,     30,     31,     32,
	33,     34,     35,     36,     37,     38,     39,     40,
	41,     42,     43,     44,     45,     46,     47,     48,
	49,     50,     51,     B64ERR, B64ERR, B64ERR, B64ERR, B64ERR
    };
    
    for (help = here = start; *here &&  *here != '='; here++, help++) {
	while (*here == '\n' && *(here+1))
	    here++;
	if (*here != '\n' && *here)
	    *help = *here;
	else
	    *help = '\0';
    }
    
    *help = '\0';

    res = here = start;

    while (*here) {
	value = lookup[*here] << 2;
	if (*(++here)) {
	    modulo = lookup[*here] >> 4;
	    *res++ = (u_char)((value + modulo) & 0xFF);
	    cnt++;
	    value = lookup[*here] << 4;
	    if (*(++here)) {
		modulo = lookup[*here] >> 2;
		*res++ = (u_char)((value + modulo) & 0xFF);
		cnt++;
		value = lookup[*here] << 6;
		if (*(++here)) {
		    modulo = lookup[*here];
		    *res++ = (u_char)((value + modulo) & 0xFF);
		    cnt++;
		    here++;
		}
		else {
		    *res++ = (u_char)((value) & 0xFF);
		    cnt++;
		}
	    }
	    else {
		*res++ = (u_char)((value) & 0xFF);
		cnt++;
	    }
	}
	else {
	    *res++ = (u_char)((value) & 0xFF);
	    cnt++;
	}
    }
    
    *res = '\0';
    
    return (cnt);
#undef B64PAD
#undef B64ERR
}

static String encodeBase64(buf, cnt)
unsigned char *buf;
Cardinal cnt;
{
    static unsigned char lookup[65] = 
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    char tmp[5]; 
    int value;
    int modulo;
    unsigned char *here;
    String res;
    String out;
    int len = 0;
    
    here = buf;
    out = res = XtMalloc((int)(cnt * 1.5));
    
    while (cnt) {
	cnt--;
	value = (*here & 0xFF) >> 2;
	modulo = *here & 0x3;
	*res++ = lookup[value];
	if (cnt) {
	    here++;
	    cnt--;
	    value = ((*here & 0xFF) >> 4) + (modulo << 4);
	    modulo = *here & 0xF;
	    *res++ = lookup[value];
	    if (cnt) {
		here++;
		cnt--;
		value = ((*here & 0xFF) >> 6) + (modulo << 2);
		*res++ = lookup[value];
		value = *here & 0x3F;
		*res++ = lookup[value];
	    }
	    else {
		value = modulo << 2;
		*res++ = lookup[value];
		*res++ = '=';
	    }
	}
	else {
	    value = modulo << 4;
	    *res++ = lookup[value];
	    *res++ = '=';
	    *res++ = '=';
	}
	len += 4;
	if (len >= 73) {
	    *res++ = '\n';
	    len = 0;
	}
	here++;
    }
    
    *res = '\0';
    
    return (out);
} 

#undef D
#ifdef Debug
#define D(s) s
#else /* Debug */
#define D(s)
#endif /* Debug */

static UString findPart(buf, switches, i)
UString buf;
Switches *switches;
Cardinal *i;
{
    UString here;
    String boundary;
    UString begin = NULL, end = NULL;
    Cardinal boundlen;
    UString res;
    char string[512];
    
    
    
    here = buf + *i;
    boundary = switches->boundary;
    boundlen = strlen(boundary);
    
    if (strlen(here) <= boundlen + 7)
	return ((UString)NULL);
    
    if (!strncmp(here, "--", 2) && !strncmp(here+2, boundary, boundlen))
	if (!strncmp(here+2+boundlen, "--", 2))
	    return ((UString)NULL);
	else {
	    begin = here+2+boundlen+1;
	    here = begin;
	}

    if (!begin)
	while (*here) {
	    while (*here && *here != '\n')
		here++;
	    if (!*here)
		break;
	    here++;
	    if (!strncmp(here, "--", 2))
		if(!strncmp(here+2, boundary, boundlen))
		    if (!strncmp(here+2+boundlen, "--", 2))
			return ((UString)NULL);
		    else {
			begin = here+2+boundlen+1;
			here = begin;
			break;
		    }
	}
    
    while (*here) {
	while (*here && *here != '\n')
	    here++;
	if (!*here)
	    break;
	here++;
	if (!strncmp(here, "--", 2))
	    if (!strncmp(here+2, boundary, boundlen)) {
		end = here;
		break;
	    }
    }
    if (end) {
	*i = end - buf;
	res = (UString)XtMalloc(end - begin + 1);
	strncpy(res, begin, end - begin);
	*(res + (end - begin)) = '\0';
	return (res);
    }
    else
	return ((UString)NULL);
}

	


static void cutSpace(s)
char *s;
{
    char *t;
    
    if (!*s)
	return;
    t = s;
    
    while (*t)
	t++;
    if (*(--t) != '\n')
	return;
    while (t != s && isspace(*(--t)))
	;
    if (*t != '\n')
	*(++t) = '\n';
    *(++t) = '\0';
    return;
}
    
static ChooseFont(w, switches)
Widget w;
Switches *switches;
{
    Arg args[1];
/*
    switch (switches->charset) {
      case iso88591:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_1_font); break;
      case iso88592:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_2_font); break;
      case iso88593:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_3_font); break;
      case iso88594:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_4_font); break;
      case iso88595:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_5_font); break;
      case iso88596:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_6_font); break;
      case iso88597:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_7_font); break;
      case iso88598:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_8_font); break;
      case iso88599:
	XtSetArg(args[0], XtNfont, app_resources.iso_8859_9_font); break;
      case usascii:
	XtSetArg(args[0], XtNfont, app_resources.usascii_font);	break;
    }
    
    XtSetValues(w, args, ONE);
*/
}    
     

static void messPlaintext(w, buf, switches)
Widget w;
UString buf;
Switches *switches;
{
    Cardinal len;

    if (w)
	ChooseFont(w, switches);

    switch (switches->encoding) {
      case quoted:
	decodeQuotedString(buf);
	break;
      case base64:
	len = decodeBase64(buf); 
	break;
      default:
	break;
    }

    return;
    
}


static Multi_Part *buildPartialList();

/*ARGSUSED*/
static Multi_Part *messMulti(w, buf, switches)
Widget w;
UString buf;
Switches *switches;
{
    UString res;
    Cardinal ind = 0;
    Multi_Part *list=NULL, *listhere=NULL, *help=NULL;
    

    while (res = findPart(buf, switches, &ind)) {
	buf += ind;
	ind = 0;
	help = buildPartialList(w, res);
	if (!list)
	    list = help;
	else {
	    for (listhere = list; listhere->next; listhere = listhere->next)
		;
	    listhere->next = help;
	}
    }
	
    return list;
    
}

/*ARGSUSED*/
static void messHeaders(w, buf, switches)
Widget w;
UString buf;
Switches *switches;
{
    UString here, begin, first, second, end, endline;
    String charset = NULL;
    
    here = buf; 

    while (*here) {
	while (*here && *here != '=')
	    here++;
	if (!*here) 
	    continue;
	
	begin = here++;
	if (!*here || *here != '?')
	    continue;
	here++;
	endline = (UString)strchr(here, (int)'\n');
	first = (UString)strchr(here, '?');
	if (!first || first > endline) {
	    here = begin + 1;
	    continue;
	}
	second = (UString)strchr(first+1, (int)'?');
	if (!second || second > endline) {
	    here = begin + 1;
	    continue;
	}
	end = (UString)strchr(second+1, (int)'?');
	if (!end || end > endline || *(end+1) != '=') {
	    here = begin + 1;
	    continue;
	}
	
	/* OK, now we've found and surrounded you! */
	switch (switches->charset) {
	  case iso88591: charset = "iso-8859-1"; break;
	  case iso88592: charset = "iso-8859-2"; break;
	  case iso88593: charset = "iso-8859-3"; break;
	  case iso88594: charset = "iso-8859-4"; break;
	  case iso88595: charset = "iso-8859-5"; break;
	  case iso88596: charset = "iso-8859-6"; break;
	  case iso88597: charset = "iso-8859-7"; break;
	  case iso88598: charset = "iso-8859-8"; break;
	  case iso88599: charset = "iso-8859-9"; break;
	  default:       charset = (String)NULL; break;
	}

	if (!charset) {
	    if (!strncasecmp(begin+2, "iso-8859-1", 10)) {
		switches->charset = iso88591;
		charset = "iso-8859-1";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-2", 10)) {
		switches->charset = iso88592;
		charset = "iso-8859-2";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-3", 10)) {
		switches->charset = iso88593;
		charset = "iso-8859-3";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-4", 10)) {
		switches->charset = iso88594;
		charset = "iso-8859-4";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-5", 10)) {
		switches->charset = iso88595;
		charset = "iso-8859-5";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-6", 10)) {
		switches->charset = iso88596;
		charset = "iso-8859-6";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-7", 10)) {
		switches->charset = iso88597;
		charset = "iso-8859-7";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-8", 10)) {
		switches->charset = iso88598;
		charset = "iso-8859-8";
	    }
	    else if (!strncasecmp(begin+2, "iso-8859-9", 10)) {
		switches->charset = iso88599;
		charset = "iso-8859-9";
	    }
	    else if (!strncasecmp(begin+2, "us-ascii", 8)) {
		switches->charset = usascii;
		charset = "us-ascii";
	    }
	}
	if (charset)
	    if(!strncasecmp(begin+2, charset, strlen(charset)) ||
	       !strncasecmp(begin+2, "us-ascii", 8)) {
		second++;
		*end = '\0';
		switch (*(first+1)) {
		  case 'b':
		  case 'B':
		    *end = '\0';
		    decodeBase64(second);
		    break;
		  default:
		    *end = '\0';
		    decodeQuotedString(second);
		    for (first = second; *first; first++)
			if (*first == '_')
			    *first = ' ';
		    break;
		}
		while(*second)
		    *begin++ = *second++;
		here = begin;
		
		end += 2;
		while(*end)
		    *begin++ = *end++;
		*begin = '\0';
		if (*here == ' ' || *here == '\t' || *here == '\n')
		    here++;
	    }
    }
}


/*ARGSUSED*/
static String encodePlaintext(w, buf, switches)
Widget w;
UString buf;
Switches *switches;
{
    String res;
    
    switch (switches->encoding) {
      case quoted:
	res = encodeQuotedString(buf);
	break;
      case base64:
	res = encodeBase64(buf, strlen(buf));
	break;
      default:
	res = XtNewString(buf);
	break;
    }

    return (res);
}


/*ARGSUSED*/
static String encodeHeaders(w, buf, switches)
Widget w;
UString buf;
Switches *switches;
{
    String res, reshere, tmpstring;
    UString here, help, first, last;
    Cardinal len, num, left;
    Boolean startline = TRUE;
    u_char tmpchar;
    
    here = buf;
    reshere = res = XtMalloc(strlen(buf) * 5);
    bzero(res, strlen(buf) * 5);
    *reshere = '\0';
    
    while (*here) {
	help = here;
	while (*help && (!startline || *help != ':') && *help != ' ' 
	       && *help != '\t' && *help != '\n' && !(*(help) & 0x80))
	    help++;
	if (!*help || *help == '\n') {
	    startline = TRUE;
	    while (help >= here)
		*reshere++ = *here++;
	    continue;
	}
	if (startline && *help == ':') {
	    startline = FALSE;
	    while (help >= here || *here == ' ' || *here == '\t')
		*reshere++ = *here++;
	    continue;
	}
	if (*help == ' ' || *help == '\t') {
	    startline = FALSE;
	    while (help >= here || *here == ' ' || *here == '\t')
		*reshere++ = *here++;
	    continue;
	}
	
	first = last = help++;
	while (*help && *help != '\n' && !(*(help) & 0x80))
	    help++;
	if (*help & 0x80) {
	    while (*help && help - first <= 20) {
		last = help++;
		while (*help && *help != '\n' && 
		       *help != ' ' && *help != '\t')
		    help++;
	    }
	}
	if (first == last) {
	    help = last;
	    help = (UString)strpbrk(help, " \t\n");
	    if (help)
		if (help - first < 40)
		    last = help;
		else
		    last += 20;
	    else
		if (strlen(last) < 40)
		    last += strlen(last);
		else
		    last += 20;
	}
	help = last;
	while (help-first < 20 && *help && *help != ' ' && *help != '\t' && 
	       *help != '\n' )
	    help++;
	if (help-first < 20)
	    if (*help == ' ' || *help == '\t' || *help == '\n' ) {
		while (*help && 
		       (*help == ' ' || *help == '\t') && *help != '\n' )
		    help++;
		last = help;
	    }
	    else
		last = help;
	
	tmpchar = *last;
	*last = '\0';
	tmpstring = encodeQuotedString(first);
	*last = tmpchar;
	if (strlen(tmpstring) > 58)
	    printf("Quoted header string too long:\n%s\n", tmpstring);
	for (help = (UString)tmpstring; *help; help++)
	    if (*help == ' ') 
		*help = '_';

	*reshere = '\0';
	strcat(reshere, "=?");
	switch (switches->charset) {
	  case iso88591: strcat(reshere, "ISO-8859-1"); break;
	  case iso88592: strcat(reshere, "ISO-8859-2"); break;
	  case iso88593: strcat(reshere, "ISO-8859-3"); break;
	  case iso88594: strcat(reshere, "ISO-8859-4"); break;
	  case iso88595: strcat(reshere, "ISO-8859-5"); break;
	  case iso88596: strcat(reshere, "ISO-8859-6"); break;
	  case iso88597: strcat(reshere, "ISO-8859-7"); break;
	  case iso88598: strcat(reshere, "ISO-8859-8"); break;
	  case iso88599: strcat(reshere, "ISO-8859-9"); break;
	}
	strcat(reshere, "?Q?");
	strcat(reshere, tmpstring);
	strcat(reshere, "?=");
	XtFree(tmpstring);
	here = last;
	while (*reshere)
	    reshere++;
    }


    return (res);
}



static void parseHeaders(buf, switches)
String buf;
Switches *switches;
{
    String here = buf;
    String help;
    Boolean doublequote;
    Boolean singlequote;
    
    while (*here) {

	doublequote = singlequote = FALSE;

	/* Is this line a Content-Type or Content-Transfer-Encoding? */
	if (!strncasecmp(here, "Content-", 8)) {
	    
	    /* More spesific, Content-Type */
	    if (!strncasecmp(here + 8, "Type:", 5)) {
		here += strspn(here + 13, " \t") + 13;
		if (!strncasecmp(here, "text/", 5)) {
		    switches->contentType = text;
		    here += 5;
		    if (!strncasecmp(here, "plain", 5)) {
			here = &here[strspn(here+5, " \t")+5];
			switches->contentSub = plain;
		    }
		    else if (!strncasecmp(here, "richtext", 8)) {
			here += strspn(here+8, " \t") + 8;
			switches->contentSub = richtext;
		    }
		    while (*here && *here != '\n')
			switch (here[0]) {
			  case ';':
			    here = &here[strspn(here+1, " \t")+1];
			    if (!strncasecmp(here, "charset=", 8)) {
				here += 8;
                                if (*here == '"') {
				    doublequote = TRUE;
				    here++;
				}
				if (!strncasecmp(here, "us-ascii", 8)) {
				    switches->charset = usascii;
				    here += 8;
				}
				else if (!strncasecmp(here, "iso-8859-", 9) 
					 && (here[10] == '\n' 
					     || here[10] == '\0'
					     || here[10] == ' '
					     || here[10] == '\t'
					     || (here[10] == '"'
						 && doublequote)
					     || (here[10] == '\''
						 && singlequote))) {
				    if (here[10] == '"') 
					doublequote = FALSE;
				    else if (here[10] == '\'') 
					singlequote = FALSE;
				    here += 9;
				    switch (*here) {
				      case '\n':
				      case '\0': 
					printf("invalid charset\n"); 
					break; /* ERROR */
				      case '1': switches->charset = iso88591;
					here++; break;
				      case '2': switches->charset = iso88592;
					here++; break;
				      case '3': switches->charset = iso88593;
					here++; break;
				      case '4': switches->charset = iso88594;
					here++; break;
				      case '5': switches->charset = iso88595;
					here++; break;
				      case '6': switches->charset = iso88596;
					here++; break;
				      case '7': switches->charset = iso88597;
					here++; break;
				      case '8': switches->charset = iso88598;
					here++; break;
				      case '9': switches->charset = iso88599;
					here++; break;
				      default:  
					printf("unknown iso set %c\n", *here); 
					here++; 
					break; /* ERROR */
				    }
				}
				/* else  ERROR */
				if (*here == '"') here++;
			    }
			    else {
				printf("not charset=, but %s\n", here);
				here = "\0";
			    }
			    
			    break;
			    
			  default: 
			    {
				char *eoln;
				char tmp;
				eoln = strchr(here, '\n');
				if (eoln) {
				    tmp = *eoln;
				    *eoln = '\0';
				    printf("unrecognized string <%s>\n", here);
				    *eoln = tmp;
				    here = eoln;
				}
			    }
			    break;
			}
		    
		    if (*here)
			here++;
		    
		}
		else if (!strncasecmp(here, "multipart/", 10)) {
		    switches->contentType = multipart;
		    switches->needBoundary = TRUE;
		    here += 10;
		    if (!strncasecmp(here, "mixed", 5)) {
			here = &here[strspn(here+5, " \t")+5];
			switches->contentSub = mixed;
		    }
		    else if (!strncasecmp(here, "alternative", 11)) {
			here += strspn(here+8, " \t") + 11;
			switches->contentSub = alternative;
		    }
		    else if (!strncasecmp(here, "digest", 6)) {
			here += strspn(here+8, " \t") + 6;
			switches->contentSub = digest;
		    }
		    else if (!strncasecmp(here, "parallel", 8)) {
			here += strspn(here+8, " \t") + 8;
			switches->contentSub = parallel;
		    }
		    while (*here && *here != '\n')
			switch (here[0]) {
			  case ';':
			    here += strspn(here+1, " \t") + 1;
			    if (!strncasecmp(here, "boundary=", 9)) {
				here += 9;
				for (help = here; *help && *help != ';' && *help != '\n'; help++)
				    ;
				help--;
				if (*help) {
				    int left = help-here+1;
				    Boolean dquoted = FALSE;
				    
				    switches->boundary = XtMalloc(left+1);
				    for (help = switches->boundary; left; here++) {
					switch (*here) {
					  case '"':
					    if (dquoted)
						dquoted = FALSE;
					    else
						dquoted = TRUE;
					    break;
					  case '\\':
					    if (*(here+1)) {
						here++;
						left--;
						*help++ = *here;
					    }
					    else
						*help++ = *here;
					    break;
					  default:
					    *help++ = *here;
					    break;
					}
					left--;
				    }
				    *help = '\0';
				    
/*				    *(switches->boundary + (help-here)) = '\0';
				    here = help+2; */
				}
				else
				    printf("error reading boundary\n");
			    }
			    else {
				printf("not boundary=, but %s\n", here);
				here = "\0";
			    }
			    
			    break;
			    
			  default:
			    printf("unrecognized string <%s>\n", here);
			    here = "\0";
			    break;
			}
		    
		    if (*here)
			here++;
		    
		}
		else if (!strncasecmp(here, "message/", 8)) {
		    switches->contentType = message;
		}
		else if (!strncasecmp(here, "message", 7)) {
		    switches->contentType = message;
		}
		else if (!strncasecmp(here, "application/", 12)) {
		    switches->contentType = application;
		}
		else if (!strncasecmp(here, "application", 11)) {
		    switches->contentType = application;
		}
		else if (!strncasecmp(here, "image/", 6)) {
		    switches->contentType = image;
		    here += 6;
		    if (!strncasecmp(here, "xpm", 3)) {
			here = &here[strspn(here+3, " \t")+3];
			switches->contentSub = xpm;
		    }
		    while (*here && *here != '\n')
			if (*here) here++;
		}
		else if (!strncasecmp(here, "image", 5)) {
		    switches->contentType = image;
		}
		else if (!strncasecmp(here, "audio/", 6)) {
		    switches->contentType = audio;
		}
		else if (!strncasecmp(here, "audio", 5)) {
		    switches->contentType = audio;
		}
		else if (!strncasecmp(here, "video/", 6)) {
		    switches->contentType = video;
		}
		else if (!strncasecmp(here, "video", 5)) {
		    switches->contentType = video;
		}
	    }
	    /* Well, perhaps Content-Transfer-Encoding? */
	    else if (!strncasecmp(&here[8], "Transfer-Encoding:", 18)) {
		here =  &here[strspn(&here[26], " \t")+26];
		if (!strncasecmp(here, "7bit", 4)) {
		    here += 4;
		    switches->encoding = bit7;
		}
		else if (!strncasecmp(here, "8bit", 4)) {
		    here += 4;
		    switches->encoding = bit8;
		}
		else if (!strncasecmp(here, "binary", 6)) {
		    here += 6;
		    switches->encoding = binary;
		}
		else if (!strncasecmp(here, "base64", 6)) {
		    here += 6;
		    switches->encoding = base64;
		}
		else if (!strncasecmp(here, "quoted-printable", 16)) {
		    here += 16;
		    switches->encoding = quoted;
		}
		else 
		    printf("unknown encoding %s\n", here);
	    }
	    else
		while (*here && *here++ != '\n')
		    ;
	}
	else {
	    while (*here && *here++ != '\n')
		;
	}
    }
    return;
}


static UString ReadFileIntoBuffer(filename) 
String filename;
{
    FILEPTR fid;
    UString buf;
    size_t size, ret;
    struct stat statstruct;
        
    stat(filename, &statstruct);
    size = statstruct.st_size;
    
    fid = fopen(filename, "r");

    buf = (UString)XtMalloc(size+1);
    ret = fread(buf, sizeof(u_char), size+1, fid);

    *(buf+size) = '\0';

    fclose(fid);

    return (buf);
}    

/*
 * SplitBufferInto4();
 *
 * Splits a message as read from disk into four separate strings.
 *
 * Arguments:
 * hdr:		On entry, a pointer to a string
 *		(i.e. 'unsigned char **hdr')
 *		containing the buffer that is to be split.
 *		On return, the same pointer, but the string is now
 *		containing the unmodified headers of the message only.
 *		The 'msg' string resides in the same buffer, see below.
 * hdr2:	On entry a pointer to a pointer to NULL (hopefully)
 *		On return, a pointer to a string containing
 *		the headers, where all continuated headers have been
 *		joined. This makes the parsing in parseHeaders()
 *		easier.
 * bdr:		On entry a pointer to a pointer to NULL
 *		On return, a pointer to a string containing
 *		the line separating the headers and the body
 * msg:		On entry a pointer to a pointer to NULL
 *		On return, a pointer to a string containing
 *		the body of the message.
 *
 * Returns:
 * Void, but leaves the results in the memomry locations pointed to
 * by the arguments.
 *
 * WARNING:
 * This version splits the 'msg' part inplace, i.e. it is never malloc'ed
 * memory for a copy nor actually copied, but it is returned as a part of
 * the 'hdr' buffer. This should be considered when freeing 'hdr', and
 * when attempting to free 'msg'. THE RESULTS OF THIS OPERATION IS VERY
 * UNPREDICTABLE AND SHOULD NOT BE ATTEMPTED. Free 'hdr' instead, if
 * you don't need them anymore.
 *
 * The major benefit of implementing it this way is that you don't waste 
 * cpu cycles and memory duplicating the possibly large body part of the
 * message yet another time. This is important, as MIME messages
 * tend to be large.
 * We have to duplicate this buffer a few times later on, anyhow :(
 */
static void SplitBufferInto4(hdr, hdr2, bdr, msg)
UString *hdr, *hdr2, *bdr, *msg;
{
    UString buf = *hdr;
    UString hdrbuf, hdr2buf, bdrbuf, msgbuf, help, help2;
    u_char temp;

    for (help = buf; *help; help++)
	if (*help == '\n')
	    if (*(help + 1) == '\n' ||
		(*(help+1) == '-' && *(help+2) == '-' && *(help+3) == '-')) {
		for (help2 = ++help; *help2 && *help2 != '\n'; help2++)
		    ;

		help2++;
		temp = *help2;
		*help2 = '\0';
		    
		bdrbuf = (UString)XtNewString((String)help);
		*help2 = temp;
		*help = '\0';
		break;
	    }
    
    hdrbuf = buf;

    hdr2buf = (UString)XtNewString((String)hdrbuf);
    for (help = hdr2buf; *help; help++)
	if (*help == '\n')
	    if (*(help + 1) == ' ' || *(help + 1) == '\t') 
		*help = ' ';

    *hdr  = hdrbuf;
    *hdr2 = hdr2buf;
    *bdr  = bdrbuf;
    *msg  = help2;

    return;
}

#undef D
#ifdef Debug
#define D(s) s
#else /* Debug */
#define D(s)
#endif /* Debug */


UString MixmhMakeViewBuffer(w, filename)
Widget w;
String filename;
{

    UString border, buf, hdrbuf2, msgbuf, out;
    int fd;
    Switches *switches = NULL;
    u_char tmp;

    if (!strcmp(filename, "/dev/null"))
	return((UString)NULL);
    
    switches = InitSwitches();
    
    buf = ReadFileIntoBuffer(filename);
    
    SplitBufferInto4(&buf, &hdrbuf2, &border, &msgbuf);

    parseHeaders(hdrbuf2, switches);
    
    XtFree((String)hdrbuf2);

    messHeaders(w, buf, switches);
    
    switch (switches->contentType) {
      case text:
	messPlaintext(w, msgbuf, switches);
	D(printf("Contents: text\n"));	
	switch (switches->contentSub) {
	  case plain:
	    D(printf("Subtype: plain\n")); break;
	  case richtext:
	    D(printf("Subtype: richtext\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case multipart:
	ChooseFont(w, switches);
	D(printf("Contents: multipart\n"));
	switch (switches->contentSub) {
	  case mixed:
	    D(printf("Subtype: mixed\n")); break;
	  case alternative:
	    D(printf("Subtype: alternative\n")); break;
	  case digest:
	    D(printf("Subtype: digest\n")); break;
	  case parallel:
	    D(printf("Subtype: parallel\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case message:
	ChooseFont(w, switches);
	D(printf("Contents: message\n"));
	switch (switches->contentSub) {
	  case rfc822:
	    D(printf("Subtype: rfc822\n")); break;
	  case partial:
	    D(printf("Subtype: partial\n")); break;
	  case externalbody:
	    D(printf("Subtype: externalbody\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case application:
	ChooseFont(w, switches);
	D(printf("Contents: application\n"));
	switch (switches->contentSub) {
	  case octetstream:
	    D(printf("Subtype: octetstream\n")); break;
	  case postscript:
	    D(printf("Subtype: postscript\n")); break;
	  case oda:
	    D(printf("Subtype: oda\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	} 
	break;
      case image:
	ChooseFont(w, switches);
	D(printf("Contents: image\n"));
	switch (switches->contentSub) {
	  case jpeg:
	    D(printf("Subtype: jpeg\n")); break;
	  case gif:
	    D(printf("Subtype: gif\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case audio:
	ChooseFont(w, switches);
	D(printf("Contents: audio\n"));
	switch (switches->contentSub) {
	  case basic:
	    D(printf("Subtype: basic\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	} 
	break;
      case video:
	ChooseFont(w, switches);
	D(printf("Contents: video\n"));
	switch (switches->contentSub) {
	  case mpeg:
	    D(printf("Subtype: mpeg\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      default:
	D(printf("Unknown contents\n")); break;
    }
    
    switch (switches->encoding) {
      case bit7:
	D(printf("Encoding: 7 bit\n")); break;
      case bit8:
	D(printf("Encoding: 8 bit\n")); break;
      case binary:
	D(printf("Encoding: binary\n")); break;
      case base64:
	D(printf("Encoding: base64\n")); break;
      case quoted:
	D(printf("Encoding: quoted-printable\n")); break;
      default:
	D(printf("Unknown encoding\n")); break;
    }

    switch (switches->charset) {
      case usascii:
	D(printf("Charset: us-ascii\n")); break;
      case iso88591:
 	D(printf("Charset: iso-8859-1\n")); break;
      case iso88592:
 	D(printf("Charset: iso-8859-2\n")); break;
      case iso88593:
 	D(printf("Charset: iso-8859-3\n")); break;
      case iso88594:
 	D(printf("Charset: iso-8859-4\n")); break;
      case iso88595:
 	D(printf("Charset: iso-8859-5\n")); break;
      case iso88596:
 	D(printf("Charset: iso-8859-6\n")); break;
      case iso88597:
	D(printf("Charset: iso-8859-7\n")); break;
      case iso88598:
	D(printf("Charset: iso-8859-8\n")); break;
      case iso88599:
	D(printf("Charset: iso-8859-9\n")); break;
      default:
	D(printf("Unknown charset\n")); break;
    }

    if (switches->needBoundary)
	D(printf("Need boundary\n"));
    else
	D(printf("Don't need boundary\n"));
    if (switches->boundary)
	D(printf("Boundary: ->%s<-\n\n", switches->boundary));
    else
	D(printf("No boundary found\n\n"));
    
    out = (UString)XtMalloc(strlen(buf) + strlen(border) + strlen(msgbuf) + 1);
    strcpy(out, buf);
    strcat(out, border);
    strcat(out, msgbuf);
    

    XtFree((String)buf);
    XtFree((String)border);

    if (switches->boundary)
        XtFree(switches->boundary);
    XtFree((String)switches);
    
    return(out);
}


void
PrintSwitches(switches)
     Switches *switches;
{
    
    switch (switches->contentType) {
      case text:
	D(printf("Contents: text\n"));	
	switch (switches->contentSub) {
	  case plain:
	    D(printf("Subtype: plain\n")); break;
	  case richtext:
	    D(printf("Subtype: richtext\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case multipart:
	D(printf("Contents: multipart\n"));
	switch (switches->contentSub) {
	  case mixed:
	    D(printf("Subtype: mixed\n")); break;
	  case alternative:
	    D(printf("Subtype: alternative\n")); break;
	  case digest:
	    D(printf("Subtype: digest\n")); break;
	  case parallel:
	    D(printf("Subtype: parallel\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case message:
	D(printf("Contents: message\n"));
	switch (switches->contentSub) {
	  case rfc822:
	    D(printf("Subtype: rfc822\n")); break;
	  case partial:
	    D(printf("Subtype: partial\n")); break;
	  case externalbody:
	    D(printf("Subtype: externalbody\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case application:
	D(printf("Contents: application\n"));
	switch (switches->contentSub) {
	  case octetstream:
	    D(printf("Subtype: octetstream\n")); break;
	  case postscript:
	    D(printf("Subtype: postscript\n")); break;
	  case oda:
	    D(printf("Subtype: oda\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	} 
	break;
      case image:
	D(printf("Contents: image\n"));
	switch (switches->contentSub) {
	  case jpeg:
	    D(printf("Subtype: jpeg\n")); break;
	  case gif:
	    D(printf("Subtype: gif\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      case audio:
	D(printf("Contents: audio\n"));
	switch (switches->contentSub) {
	  case basic:
	    D(printf("Subtype: basic\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	} 
	break;
      case video:
	D(printf("Contents: video\n"));
	switch (switches->contentSub) {
	  case mpeg:
	    D(printf("Subtype: mpeg\n")); break;
	  default:
	    D(printf("Unknown subtype\n")); break;
	}
	break;
      default:
	D(printf("Unknown contents\n")); break;
    }
    
    switch (switches->encoding) {
      case bit7:
	D(printf("Encoding: 7 bit\n")); break;
      case bit8:
	D(printf("Encoding: 8 bit\n")); break;
      case binary:
	D(printf("Encoding: binary\n")); break;
      case base64:
	D(printf("Encoding: base64\n")); break;
      case quoted:
	D(printf("Encoding: quoted-printable\n")); break;
      default:
	D(printf("Unknown encoding\n")); break;
    }

    switch (switches->charset) {
      case usascii:
	D(printf("Charset: us-ascii\n")); break;
      case iso88591:
 	D(printf("Charset: iso-8859-1\n")); break;
      case iso88592:
 	D(printf("Charset: iso-8859-2\n")); break;
      case iso88593:
 	D(printf("Charset: iso-8859-3\n")); break;
      case iso88594:
 	D(printf("Charset: iso-8859-4\n")); break;
      case iso88595:
 	D(printf("Charset: iso-8859-5\n")); break;
      case iso88596:
 	D(printf("Charset: iso-8859-6\n")); break;
      case iso88597:
	D(printf("Charset: iso-8859-7\n")); break;
      case iso88598:
	D(printf("Charset: iso-8859-8\n")); break;
      case iso88599:
	D(printf("Charset: iso-8859-9\n")); break;
      default:
	D(printf("Unknown charset\n")); break;
    }

    if (switches->needBoundary)
	D(printf("Need boundary\n"));
    else
	D(printf("Don't need boundary\n"));
    if (switches->boundary)
	D(printf("Boundary: ->%s<-\n\n", switches->boundary));
    else
	D(printf("No boundary found\n\n"));
}



Boolean MixmhSaveStringToFile(file, buf)
String file, buf;
{
    FILE *out;

    if ((out = fopen(file, "w")) == NULL)
	return (FALSE);
    fputs(buf, out);
    fclose(out);
    return (TRUE);
}

/*
 * MixmhEncodeMessage()
 *
 * Encodes a message according to its headers.
 *
 * Arguments:
 * w:           widget of the source widget, could be ignored by passing NULL
 *              not used at present, but necessary when manipulating fonts
 * inbuf:       the buffer containing the message in uncoded text
 * retswithces: pointer to a memory location to store the new switches
 *              obtained during parsing of the headers, or NULL
 *
 * Returns:
 * A pointer to a new buffer, containing the results of the encoding
 */

String MixmhEncodeMessage(w, inbuf, retswitches)
Widget w;
UString inbuf;
Switches **retswitches;
{
    UString buf, hdrbuf2, help, help2, hdrbuf, msgbuf, border;
    Switches *switches;
    String hdrres, msgres, res;
    
    buf = (UString)XtNewString((String)inbuf);
    
    switches = InitSwitches();
    
    SplitBufferInto4(&buf, &hdrbuf2, &border, &msgbuf);

    hdrbuf = buf;
    
    parseHeaders(hdrbuf2, switches);
    XtFree((String)hdrbuf2);

    hdrres = encodeHeaders(w, hdrbuf, switches);
    
    switch (switches->contentType) {
      case text:
	msgres = encodePlaintext(w, msgbuf, switches);
	break;
      case multipart:
	msgres = XtNewString(msgbuf);
	break;
      case message:
	msgres = XtNewString(msgbuf);
	break;
      case application:
	msgres = XtNewString(msgbuf);
	break;
      case image:
	msgres = XtNewString(msgbuf);
	break;
      case audio:
	msgres = XtNewString(msgbuf);
	break;
      case video:
	msgres = XtNewString(msgbuf);
	break;
      default:
	msgres = XtNewString(msgbuf);
	break;
    }

    res = XtMalloc(strlen(hdrres) + strlen(border) + strlen(msgres) + 1);
    strcpy(res, hdrres);
    strcat(res, border);
    strcat(res, msgres);
    
    XtFree(hdrres);
    XtFree(msgres);
    XtFree((String)border);
    XtFree((String)buf);
    
    if (retswitches)
	*retswitches = switches;
    else {
	if (switches->boundary)
	    XtFree(switches->boundary);
	XtFree((String)switches);
    }
        
    return (res);
}


Widget initPartstable(partstable, list, tocwidget, parts, curno)
Multi_Part **partstable;
Multi_Part *list;
Widget tocwidget;
int parts, curno;
{
    Multi_Part *help, *next;
    int i;
    UString end;
    char indent[80];
    int indents = 0;
    char mark;
    Widget tocsource;
    Cardinal num_args = 0;
    Arg arglist[3];
    UString toc;
    

    end = toc = (UString)XtMalloc(80 * parts);
    *end = '\0';
    indent[0] = '\0';

    for (i = 0, help = list; help; i++, help = next) {
	partstable[i] = help;
	if (i == curno)
	    mark = '+';
	else
	    mark = ' ';
	if (partstable[i]->deleted)
	    mark = 'D';
	switch (partstable[i]->switches->contentType) {
	  case text:
	    sprintf(end, "  %3i%c %sText\n", i+1, mark, indent); break;
	  case multipart:
	    sprintf(end, "  %3i%c %sMultipart header\n", i+1, mark, indent); break;
	  case message:
	    sprintf(end, "  %3i%c %sMessage\n", i+1, mark, indent); break;
	  case application:
	    sprintf(end, "  %3i%c %sApplication\n", i+1, mark, indent); break;
	  case image:
	    sprintf(end, "  %3i%c %sImage\n", i+1, mark, indent); break;
	  case audio:
	    sprintf(end, "  %3i%c %sAudio\n", i+1, mark, indent); break;
	  case video:
	    sprintf(end, "  %3i%c %sVideo\n", i+1, mark, indent); break;
	  default:
	    sprintf(end, "  %3i%c %sUnknown type\n", i+1, mark, indent); break;
	}
	if (!help->multi)
	    if (help->next)
		next = help->next;
	    else 
		if (help->multihead) {
		    indents -= 3;
		    indent[indents] = '\0';
		    next = help->multihead->next;
		}
		else
		    next = NULL;
	else {
	    next = help->multi;
	    indent[indents++] = ' ';
	    indent[indents++] = ' ';
	    indent[indents++] = ' ';
	    indent[indents] = '\0';
	}
	end += strlen(end);
    }
    
    XtSetArg(arglist[num_args], XtNtype, XawAsciiString);    num_args++;
    XtSetArg(arglist[num_args], XtNstring, toc);      num_args++;
    XtSetArg(arglist[num_args], XtNeditType, XawtextRead); num_args++;
    
    tocsource = XtCreateWidget(XtNtextSource, asciiSrcObjectClass,
			       tocwidget, arglist, num_args);
    XawTextSetSource(tocwidget, tocsource, 0);
    
    XtFree((String)toc);

    return (tocsource);
}

#define SrcScan XawTextSourceScan

static Multi_Part *buildPartialList(w, buf)
Widget w;
UString buf;
{     
    UString border, hdrbuf2, msgbuf, out;
    int fd;
    Switches *switches = NULL;
    u_char tmp;
    Multi_Part *list = NULL, *listhere = NULL;
    
    switches = InitSwitches();

    list = (Multi_Part *)XtMalloc(sizeof(Multi_Part));
    bzero(list, sizeof(Multi_Part));
    
    SplitBufferInto4(&buf, &hdrbuf2, &border, &msgbuf);

    parseHeaders(hdrbuf2, switches);
    
    XtFree((String)hdrbuf2);

    messHeaders(w, buf, switches);

    switch (switches->contentType) {
      case text:
	messPlaintext((Widget)NULL, msgbuf, switches);
	break;
      case multipart:
	listhere = messMulti((Widget)NULL, msgbuf, switches);
	break;
      case message:
	break;
      case application:
	break;
      case image:
	break;
      case audio:
	break;
      case video:
	break;
      default:
	D(printf("Unknown contents\n")); break;
    }
    
    switch (switches->contentType) {
      case text:
      case message:
	out = (UString)XtMalloc(strlen(buf)+strlen(border)+strlen(msgbuf)+1);
	strcpy(out, buf);
	strcat(out, border);
	strcat(out, msgbuf);
	list->body = out;
	list->size = 0;
	break;
      case multipart:
      case application:
      case image:
      case audio:
      case video:
	out = (UString)XtMalloc(strlen(buf)+strlen(border)+1);
	strcpy(out, buf);
	strcat(out, border);
	if (switches->contentType == multipart) {
	    list->multi = listhere;
	    list->body = out;
	    list->size = 0;
	}
	else {
	    list->data = (UString)XtNewString((String)msgbuf);
	    list->size = strlen(msgbuf);
	    list->body = out;
	}
	break;
      default:
	D(printf("Unknown contents\n")); break;
    }
    list->switches = switches;
    
    XtFree((String)buf);
    XtFree((String)border);

    return (list);
}


Multi_Part *MixmhMakeMultiView(filename)
String filename;
{     
    UString border, buf, hdrbuf2, msgbuf, out;
    int fd;
    u_char tmp;
    Multi_Part *list = NULL, *listhere = NULL;
    
    if (!strcmp(filename, "/dev/null"))
	return((Multi_Part *)NULL);
    
    buf = ReadFileIntoBuffer(filename);
    
    list = buildPartialList((Widget)NULL, buf);
    XtFree((String)buf);
    
    return(list);
}

#endif
