/* CoreResourceEditor.C */

#include "CoreResourceEditor.h"
// Super Class : None

/*oodB%CoreResourceEditor*** Global Declarations and Stuffs ****/
 
/*oodE**********************************************************/

CoreResourceEditor::CoreResourceEditor()
{
	init();
}

CoreResourceEditor::~CoreResourceEditor()
{
	// Empty
}

void CoreResourceEditor::init()
{
  _CoreResource = NULL;
  _is_popped = False;
  create_window();
}

void CoreResourceEditor::create_window()
{
  Arg al[10];
  int ac = 0;
  int index;
  XrmValue from_value, to_value; /* For resource conversion */
  int fg, bg;                    /* colour values for pixmaps */ 
  DesignEditor * d = guide->get_DesignEditor();
  bool use_pixmap = True;
  bool no_pixmap = False;
  XmString xmstr;
  Widget parent = guide->get_top_widget();
  Factory * _factory = guide->get_Factory();
  Widget prev = NULL;
  Widget SW = NULL;
  Widget frame = NULL;
  Widget form1 = NULL;
  Widget form2 = NULL;

  XtSetArg(al[ac],XmNminWidth,441);ac++;
  XtSetArg(al[ac],XmNminHeight,476);ac++;
  _CoreResource = _factory->create_widget(parent,
					"CoreResource",
					toplevelshell_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
  ac = 0;
  form1 = _factory->create_widget(_CoreResource,
				 "XmForm",
				 form_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomOffset,50);ac++;
  XtSetArg(al[ac],XmNscrollingPolicy,XmAUTOMATIC);ac++;
  SW = _factory->create_widget(form1,
				  "XmScrolledWindow",
				  scrolledwindow_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  frame = _factory->create_widget(SW,
				  "XmFrame",
				  frame_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  form2 = _factory->create_widget(frame,
				 "XmForm",
				 form_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  // create a frame and stuff for each core resource
  for(index=0;index<19;index++){
    create_resource_frames(form2,&prev,index);
  }
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,SW);ac++;
  XtSetArg(al[ac],XmNtopOffset,10);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,20);ac++;
  XtSetArg(al[ac],XmNwidth,70);ac++;
  XtSetArg(al[ac],XmNheight,30);ac++;
 _factory->create_widget(form1,
			 "Apply",
			 pushbutton_v,
			 CoreResourceEditor::button_CB,
			 (XtPointer) core_apply_v,
			 activate_v,
			 no_pixmap,
			 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,SW);ac++;
  XtSetArg(al[ac],XmNtopOffset,10);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,100);ac++;
  XtSetArg(al[ac],XmNwidth,70);ac++;
  XtSetArg(al[ac],XmNheight,30);ac++;
 _factory->create_widget(form1,
			 "Close",
			 pushbutton_v,
			 CoreResourceEditor::button_CB,
			 (XtPointer) core_close_v,
			 activate_v,
			 no_pixmap,
			 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,SW);ac++;
  XtSetArg(al[ac],XmNtopOffset,10);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightOffset,20);ac++;
  XtSetArg(al[ac],XmNwidth,70);ac++;
  XtSetArg(al[ac],XmNheight,30);ac++;
 _factory->create_widget(form1,
			 "Help",
			 pushbutton_v,
			 CoreResourceEditor::button_CB,
			 (XtPointer) core_help_v,
			 activate_v,
			 no_pixmap,
			 al,ac);
  ac = 0;
}

void CoreResourceEditor::create_resource_frames(Widget form,Widget *prev,int i)
{
  Arg al[10];
  int ac = 0;
  XrmValue from_value, to_value; /* For resource conversion */
  int fg, bg;                    /* colour values for pixmaps */ 
  DesignEditor * d = guide->get_DesignEditor();
  bool use_pixmap = True;
  bool no_pixmap = False;
  XmString xmstr;
  Factory * _factory = guide->get_Factory();
  Widget name;
  Widget text;
  Widget toggle;
  Widget form2;
  Widget pulldown;

  // first resource
  if(i==0){
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  }
  else{
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
    XtSetArg(al[ac],XmNtopWidget,*prev);ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  }
    *prev =_factory->create_widget(form,
				 "XmFrame",
				 frame_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
    ac = 0;
    form2 =  _factory->create_widget(*prev,
			   "XmForm",
			   form_v,
			   NULL,
			   NULL,
			   no_callback_v,
			   no_pixmap,
			   al,ac);
    ac = 0;
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;    
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;    
    if(resource_array[core_resource_index[i]].tool){
      cw[i].button = _factory->create_widget(form2,
			   resource_array[core_resource_index[i]].name,
			   pushbutton_v,
			   CoreResourceEditor::modified_button_CB,
			   (XtPointer) i,
			   activate_v,
			   no_pixmap,
			   al,ac);
    }
    else{
      cw[i].button = _factory->create_widget(form2,
			   resource_array[core_resource_index[i]].name,
			   label_v,
			   NULL,
			   NULL,
			   no_callback_v,
			   no_pixmap,
			   al,ac);
    }
    ac = 0;
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;    
    XtSetArg(al[ac],XmNleftOffset,200);ac++;
    XtSetArg(al[ac],XmNselectColor,d->get_color("red"));ac++;    
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;    
    xmstr = XmStringCreateLtoR(" ", 
				   (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
    XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
    cw[i].toggle =  _factory->create_widget(form2,
			   "XmToggleButton",
			   togglebutton_v,
			   CoreResourceEditor::modified_toggle_CB,
			   (XtPointer) i,
			   value_changed_v,
			   no_pixmap,
			   al,ac);
    XmStringFree (xmstr);
    
    ac = 0;
    if(resource_array[core_resource_index[i]].options != NULL){
      XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
      XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;    
      XtSetArg(al[ac],XmNleftWidget,cw[i].toggle);ac++;    
      XtSetArg(al[ac],XmNleftOffset,15);ac++;
      XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;    
      xmstr = XmStringCreateLtoR("Options", 
				   (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
      XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
      cw[i].menu =  _factory->create_widget(form2,
					    "XmOptionMenu",
					    optionmenu_v,
					    NULL,
					    NULL,
					    no_callback_v,
					    no_pixmap,
					    al,ac);
      XmStringFree (xmstr);
      ac = 0;
      pulldown = _factory->create_widget(cw[i].menu,
					    "XmPulldownMenu",
					    pulldownmenu_v,
					    NULL,
					    NULL,
					    no_callback_v,
					    no_pixmap,
					    al,ac);

      ac = 0;
      XtSetArg(al[ac], XmNsubMenuId,pulldown);ac++;
      XtSetValues(XmOptionButtonGadget(cw[i].menu),al,ac);
      ac = 0;
      cw[i].opt[0] = _factory->create_widget(pulldown,
					    "True",
					    pushbutton_v,
					    NULL,
					    NULL,
					    no_callback_v,
					    no_pixmap,
					    al,ac);

      ac = 0;
      cw[i].opt[1] = _factory->create_widget(pulldown,
					    "False",
					    pushbutton_v,
					    NULL,
					    NULL,
					    no_callback_v,
					    no_pixmap,
					    al,ac);

      ac = 0;
      XtSetArg(al[ac],XmNmenuHistory,cw[i].opt[0]);ac++;
      XtSetValues(cw[i].menu,al,ac);
      ac = 0;
    }
    else{
      XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
      XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;    
      XtSetArg(al[ac],XmNleftWidget,cw[i].toggle);ac++;    
      XtSetArg(al[ac],XmNleftOffset,15);ac++;
      XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
      cw[i].text =  _factory->create_widget(form2,
					    "XmText",
					    text_v,
					    CoreResourceEditor::modified_text_CB,
					    (XtPointer) i,
					    value_changed_v,
					    no_pixmap,
					    al,ac);  
      ac = 0;
    }
}

void CoreResourceEditor::popup(void)
{
  XtPopup(_CoreResource,XtGrabNone);
  _is_popped = True;
}

void CoreResourceEditor::popdown(void)
{
  XtPopdown(_CoreResource);
  _is_popped = False;
}

void CoreResourceEditor::button_CB(Widget w,
				   XtPointer clientdata,
				   XtPointer calldata)
{
  CoreResourceEditor *cre;
  cre = guide->get_CoreResourceEditor();

  switch((core_menu_enum)clientdata)
  {
  case core_apply_v:
    cre->apply();
    break;
  case core_close_v:
    cre->popdown();
    break;
  case core_help_v:
    cre->help();
    break;
  }
}

void CoreResourceEditor::clear(void)
{
  Arg al[10];
  int ac = 0;
  XmString xmstr;
  char text_str[MAX_STRING];

  // reset all toggle buttons
  for(int i=0;i<19;i++){
    ac = 0;
    XtSetArg(al[ac],XmNset,False);ac++;
    XtSetValues(cw[i].toggle,al,ac);
  }

  if(_is_popped)
  {    
    // 0 accelerators
    XmTextSetString(cw[0].text,"");
    // 1 ancestersensitive
    // 2 background
    XmTextSetString(cw[2].text,"");
    // 3 backgroundPixmap
    XmTextSetString(cw[3].text,"");
    // 4 borderColor
    XmTextSetString(cw[4].text,"");
    // 5 borderPixmap
    XmTextSetString(cw[5].text,"");
    // 6 borderWidth
    sprintf(text_str,"%d",0);
    XmTextSetString(cw[6].text,text_str);
    // 7 colorMap
    XmTextSetString(cw[7].text,"");
    // 8 depth
    sprintf(text_str,"%d",0);
    XmTextSetString(cw[8].text,text_str);
    // 9 destroyCallback
    XmTextSetString(cw[9].text,"");
    // 10 height
    sprintf(text_str,"%d",0);
    XmTextSetString(cw[10].text,text_str);
    // 11 initialResourcesPersistent
    // 12 mappedWhenManaged
    // 13 screen
    XmTextSetString(cw[13].text,"");
    // 14 sensitive
    // 15 translations
    XmTextSetString(cw[15].text,"");
    // 16 width
    sprintf(text_str,"%d",0);
    XmTextSetString(cw[16].text,text_str);
    // 17 x
    sprintf(text_str,"%d",0);
    XmTextSetString(cw[17].text,text_str);
    // 18 y
    sprintf(text_str,"%d",0);
    XmTextSetString(cw[18].text,text_str);
  }
}

void CoreResourceEditor::update(void)
{
  Arg al[10];
  int ac = 0;
  XmString xmstr;
  char text_str[MAX_STRING];
  
  WidgetObj * wc = guide->get_current_widget();
  Widget w = NULL;

  clear();

  if((wc != NULL)&&(_is_popped))
  {
    w = wc->get_widget();
    // update each field width the core values
    
    // 0 accelerators
    XmTextSetString(cw[0].text,"Dynamic");
    // 1 ancestersensitive
    // 2 background
    XmTextSetString(cw[2].text,"Dynamic");
    // 3 backgroundPixmap
    XmTextSetString(cw[3].text,"XmUNSPECIFIED_PIXMAP");
    // 4 borderColor
    XmTextSetString(cw[4].text,"XtDefaultForeground");
    // 5 borderPixmap
    XmTextSetString(cw[5].text,"XmUNSPECIFIED_PIXMAP");
    // 6 borderWidth
    sprintf(text_str,"%d",w->core.border_width);
    XmTextSetString(cw[6].text,text_str);
    // 7 colorMap
    XmTextSetString(cw[7].text,"Dynamic");
    // 8 depth
    sprintf(text_str,"%d",w->core.depth);
    XmTextSetString(cw[8].text,text_str);
    // 9 destroyCallback
    XmTextSetString(cw[9].text,"Dynamic");
    // 10 height
    sprintf(text_str,"%d",w->core.height);
    XmTextSetString(cw[10].text,text_str);
    // 11 initialResourcesPersistent
    // 12 mappedWhenManaged
    // 13 screen
    XmTextSetString(cw[13].text,"Dynamic");
    // 14 sensitive
    // 15 translations
    XmTextSetString(cw[15].text,"Dynamic");
    // 16 width
    sprintf(text_str,"%d",w->core.width);
    XmTextSetString(cw[16].text,text_str);
    // 17 x
    sprintf(text_str,"%d",w->core.x);
    XmTextSetString(cw[17].text,text_str);
    // 18 y
    sprintf(text_str,"%d",w->core.y);
    XmTextSetString(cw[18].text,text_str);
  }
}

void CoreResourceEditor::apply(void)
{
  // check all core resources for modifications
  for(int i =0; i< 19; i++){
    if(cw[i].modified){
      cout << "Found modified resource -> " 
	   << resource_array[core_resource_index[i]].name << "\n";
      cout << "  New value = " << _core_value[i] << "\n";
      if(cw[i].toggle_on)
        cout << "Create X-Resources for " 
	     << resource_array[core_resource_index[i]].name << ".\n";

      // set the resources for the current widget
      ResourceConverter * rc = guide->get_ResourceConverter();
      if(strcmp(resource_array[core_resource_index[i]].access_method,"CSG")==0)
      {
        rc->set_resource((guide->get_current_widget())->get_widget(),
			 &resource_array[core_resource_index[i]],
			 _core_value[i]);
        // store resource in WidgetObj
	(guide->get_current_widget())->set_resource(
	    resource_array[core_resource_index[i]].name,  // name
	    _core_value[i],                               // value
	    resource_array[core_resource_index[i]].type); // type
      }
    }
  }
}

void CoreResourceEditor::help(void)
{
  cout << "Help button pressed \n";
}

void CoreResourceEditor::get_text_value(int i)
{
  char * temp = NULL;
  temp = XmTextGetString(cw[i].text);

  if(temp == NULL)
    return;

  if((strlen(temp)!= 0)&&(strcmp(temp,"Dynamic")!=0)){
    if(strcmp(temp,resource_array[core_resource_index[i]].default_value)!=0){
      cw[i].modified = True;
    
      strcpy(_core_value[i],temp);
    }
    else{
      cw[i].modified = False;
      _core_value[i][0]='\0';
    }
  }
  else{
    cw[i].modified = False;
    _core_value[i][0]='\0';
  }
    
  XtFree(temp);
}

void CoreResourceEditor::get_toggle_value(int i)
{
  cw[i].toggle_on = !cw[i].toggle_on;
}

void CoreResourceEditor::get_tool(int i)
{
  cout << "Tool button <" << i << "> pressed \n";
}

void CoreResourceEditor::modified_text_CB(Widget w,
					  XtPointer clientdata,
					  XtPointer calldata)
{
  CoreResourceEditor *cre;
  cre = guide->get_CoreResourceEditor();
 
  cre->get_text_value((int)clientdata);  
}

void CoreResourceEditor::modified_toggle_CB(Widget w,
					  XtPointer clientdata,
					  XtPointer calldata)
{
  CoreResourceEditor *cre;
  cre = guide->get_CoreResourceEditor();
 
  cre->get_toggle_value((int)clientdata);  
}

void CoreResourceEditor::modified_button_CB(Widget w,
					  XtPointer clientdata,
					  XtPointer calldata)
{
  CoreResourceEditor *cre;
  cre = guide->get_CoreResourceEditor();
 
  cre->get_tool((int)clientdata);  
}

