/* Guide.C */

#include "Guide.h"
// Super Class : None

/*oodB%Guide*** Global Declarations and Stuffs ****/
 
/*oodE*********************************************/

Guide::~Guide()
{
	// Empty
}

void Guide::init(void)
{
     int i = 0;
     strcpy(_application,"XApplication");
     _wc = NULL;
     _ic = NULL;
     _wbuffer = NULL;
     _winsert = NULL;
     _ibuffer = NULL;
     _factory = NULL;
     _pixmap_server = NULL;
     _design_editor = NULL;
     _option_editor = NULL;
     _core_resource_editor = NULL;
     _resource_converter = NULL;
     _widget_resource_editor = NULL;
     _constraint_editor = NULL;
     _code_generator = NULL;
     _options_found = get_options_file();
     _layout_found = get_layout_file();
     for(i=0;i<last_code_v;i++)
       code[i]= False;
}

void Guide::set_project_name(char * name)
{
  strcpy(_application,name);
}

char * Guide::get_project_name(void)
{
  return _application;
}

void Guide::build_menu(int argc,char* argv[])
{
   Widget children[6];
   Arg al[16];
   int ac = 0;
   bool use_pixmap = True;
   bool no_pixmap = False;
   int number_of_widgets = 0;
   Widget form = NULL;
   Widget menu = NULL;
   Widget pullmenu = NULL;
   Widget cascade = NULL;
   _factory = get_Factory();

//   Widget parent,
//   char * name,
//   widget_type_enum wtype,
//   void CALLBACK_FUNCTION, 
//   XtPointer callbackdata, 
//   callback_type_enum cbtype
//   bool use_pixmap
//   Arg al
//   int ac
     ac = 0;
     XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
     XtSetArg(al[ac], XmNargc, argc); ac++;
     XtSetArg(al[ac], XmNargv, argv); ac++;
     if(_layout_found){
       XtSetArg(al[ac], XmNx, new_layout.Main_x); ac++;
       XtSetArg(al[ac], XmNy, new_layout.Main_y); ac++;
     }
     else{
       XtSetArg(al[ac], XmNx, 1); ac++;
       XtSetArg(al[ac], XmNy, 1); ac++;
     }
     _Guide = XtAppCreateShell ( "Motif Guide 0.3", 
			       "MotifGuide", 
			       applicationShellWidgetClass, 
			       display, al, ac );

     _factory = get_Factory();
     _pixmap_server = get_PixmapServer();

     ac = 0;
     XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
     form = _factory->create_widget(_Guide,
				    "XmForm",
				    form_v,
				    NULL,
				    NULL,
				    no_callback_v,
				    no_pixmap,
				    al,ac);
     ac = 0;
     XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
     menu = _factory->create_widget(form,
				    "XmMenuBar",
				    menubar_v,
				    NULL,
				    NULL,
				    no_callback_v,
				    no_pixmap,
				    al,ac);
     ac = 0;
     cascade = _factory->create_widget(menu,
				       "File",
				       cascadebutton_v,
				       NULL,
				       NULL,
				       no_callback_v,
				       no_pixmap,
				       al,ac);
     ac = 0;
     pullmenu = _factory->create_widget(cascade,
					"XmPulldownMenu",
					pulldownmenu_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "New",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_new_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Save",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_save_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Save as ...",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_save_as_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Exit",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_exit_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     cascade = _factory->create_widget(menu,
				       "Edit",
				       cascadebutton_v,
				       NULL,
				       NULL,
				       no_callback_v,
				       no_pixmap,
				       al,ac);
     ac = 0;
     pullmenu = _factory->create_widget(cascade,
					"XmPulldownMenu",
					pulldownmenu_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Undo",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_undo_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Cut",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_cut_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Copy",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_copy_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Paste",
			     pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_paste_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     cascade = _factory->create_widget(menu,
				       "Editors",
				       cascadebutton_v,
				       NULL,
				       NULL,
				       no_callback_v,
				       no_pixmap,
				       al,ac);
     ac = 0;
     pullmenu = _factory->create_widget(cascade,"XmPulldownMenu",pulldownmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Design Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_design_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Widget Resource Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_widget_resource_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Core Resource Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_core_resource_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Constraint Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_constraint_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Option Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_option_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Translation Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_translation_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Callback Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_callback_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Pixmap Editor",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_pixmap_editor_v,activate_v,no_pixmap,al,ac);
     ac = 0;

     cascade = _factory->create_widget(menu,"Code",cascadebutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     ac = 0;
     pullmenu = _factory->create_widget(cascade,"XmPulldownMenu",pulldownmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Default Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_default_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"C Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_c_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"C++ Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_cpp_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"X-Resource Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_resource_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Smalltalk Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_smalltalk_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"main.c Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_main_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"callback.c Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_callback_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"event.c Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_event_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"public.h Code",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_include_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Makefile",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_generate_makefile_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     cascade = _factory->create_widget(menu,"Help",cascadebutton_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     ac = 0;
     XtSetArg(al[ac],XmNmenuHelpWidget,cascade);ac++;
     XtSetValues(menu,al,ac);
     ac = 0;
     pullmenu = _factory->create_widget(cascade,"XmPulldownMenu",pulldownmenu_v,NULL,NULL,no_callback_v,no_pixmap,al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Version",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_help_version_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Index",pushbutton_v,Guide::menu_button_CB,(XtPointer)menu_help_index_v,activate_v,no_pixmap,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,"Contextual",pushbutton_v,
			     Guide::menu_button_CB,
			     (XtPointer)menu_help_context_v,
			     activate_v,no_pixmap,al,ac);
     ac = 0;
     XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
     XtSetArg(al[ac], XmNtopWidget,menu); ac++;
     XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
     _frame = _factory->create_widget(form,"XmFrame",frame_v,
				     NULL,NULL,no_callback_v,
				     no_pixmap,al,ac);
     ac = 0;
     form = _factory->create_widget(_frame,"XmFrame",form_v,
				    NULL,NULL,no_callback_v,
				    no_pixmap,al,ac);
     ac = 0;
     XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
     _variable_name  = _factory->create_widget(form,"Variable Name",
					       label_v,NULL,NULL,
					       no_callback_v,
					       no_pixmap,al,ac);
     ac = 0;
     XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
     XtSetArg(al[ac], XmNleftWidget, _variable_name); ac++;
     _variable_text = _factory->create_widget(form,"Variable Text",
					      text_v,
					      Guide::set_variable_name_CB,
					      NULL,value_changed_v,
					      no_pixmap,al,ac);
     ac = 0;
     XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
     XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNleftWidget, _variable_text); ac++;
     _widget_name  = _factory->create_widget(form,"Widget Name",
					     label_v,NULL,NULL,
					     no_callback_v,
					     no_pixmap,al,ac);
     ac = 0;
     XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
     XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
     XtSetArg(al[ac], XmNleftWidget, _widget_name); ac++;
     _widget_text = _factory->create_widget(form,"Widget Text",
					    text_v,
					    Guide::set_widget_name_CB,
					    NULL,value_changed_v,
					    no_pixmap,al,ac);
}

bool Guide::get_options_file(void)
{
  ifstream ifile(".guide_options");
  bool found;

  if(ifile != NULL){
    ifile.read((char *)&new_options, sizeof(option_rec));
  }
  else{
    cout << "Could not find <.guide_options> file \n";
    found = False;
  }
  return found;
}

bool Guide::get_layout_file(void)
{
  ifstream ifile(".guide_layout");
  bool found;

  if(ifile != NULL){
    ifile.read((char *)&new_layout, sizeof(layout_rec));
  }
  else{
    cout << "Could not find <.guide_layout> file \n";
    found = False;
  }
  return found;
}

Guide::Guide(int argc,char* argv[])
{
  int c;

  while ((c = getopt(argc, argv, "D:h:")) != -1)
    switch (c) 
    {
      case 'h':
       cout << " Print Help line here... \n";
      break;
      case 'D':
       cout << "Debug mode set to <value>\n";
      break;
      case '?':
       cout << " Option ? \n";
      break;
    }
  XtSetLanguageProc((XtAppContext) NULL, 
                    (XtLanguageProc) NULL, 
                    (XtPointer) NULL );
  XtToolkitInitialize ();
  app_context = XtCreateApplicationContext ();

  display = XtOpenDisplay (app_context, NULL, argv[0], "MotifGuide",
                                 NULL, 0, &argc, argv);
  if (!display)
  {
    printf("%s: can't open display, exiting...\n", argv[0]);
    exit (-1);
  }
}

void Guide::run(int argc,char* argv[])
{
  XFontStruct * font_struct;
  char * font_name;
  DesignEditor * d;

  init();

  font_struct = 
    XLoadQueryFont(display, "-schumacher-clean-*-*-*-*-6-*-*-*-*-*-*-*");

  build_menu(argc,argv);

  gc = XCreateGC(display, 
                 RootWindowOfScreen(XtScreen(_Guide)), 
                 0,
                 NULL);

  font_gc = XCreateGC(display, 
                 RootWindowOfScreen(XtScreen(_Guide)), 
                 0,
                 NULL);

  color_gc = XCreateGC(display, 
                 RootWindowOfScreen(XtScreen(_Guide)), 
                 0,
                 NULL);

  XSetForeground(display,color_gc,(get_DesignEditor())->get_color("white"));

  if(font_struct == (XFontStruct*) NULL){
    cout << "Could not find font \n";
  }
  else{
    XSetFont(display,font_gc,font_struct->fid);
  }

  XSetForeground(display,font_gc,(get_DesignEditor())->get_color("black"));
  
  
  update_variable_name();
  XtRealizeWidget (_Guide);
  set_handlers();
  XtAppMainLoop (app_context);
}

Widget Guide::get_top_widget(void)
{
	return _Guide;
}

Factory* Guide::get_Factory(void)
{
   if(_factory == NULL)
     _factory = new Factory;

   return _factory;
}

PixmapServer* Guide::get_PixmapServer(void)
{
   if(_pixmap_server == NULL)
     _pixmap_server = new PixmapServer;
	
   return _pixmap_server;
}

DesignEditor* Guide::get_DesignEditor(void)
{
   if(_design_editor == NULL)
      _design_editor= new DesignEditor;
	
   return _design_editor;
}

OptionEditor* Guide::get_OptionEditor(void)
{
   if(_option_editor == NULL)
     _option_editor = new OptionEditor;

   return _option_editor;
}

ConstraintEditor* Guide::get_ConstraintEditor(void)
{
   if(_constraint_editor == NULL)
     _constraint_editor = new ConstraintEditor;

   return _constraint_editor;
}

CoreResourceEditor* Guide::get_CoreResourceEditor(void)
{
   if(_core_resource_editor == NULL)
     _core_resource_editor = new CoreResourceEditor;

   return _core_resource_editor;
}

ResourceConverter* Guide::get_ResourceConverter(void)
{
   if(_resource_converter == NULL)
     _resource_converter = new ResourceConverter;

   return _resource_converter;
}

WidgetResourceEditor* Guide::get_WidgetResourceEditor(void)
{
   if(_widget_resource_editor == NULL)
     _widget_resource_editor = new WidgetResourceEditor;

   return _widget_resource_editor;
}

CodeGenerator* Guide::get_CodeGenerator(void)
{
   if(_code_generator== NULL)
     _code_generator = new CodeGenerator(_application);

   return _code_generator;
}

void Guide::menu_button_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  int i = 0;
  DesignEditor * de;
  CoreResourceEditor *cre;
  WidgetResourceEditor *wre;
  ConstraintEditor *ce;
  //CallbackEditor *cbe;
  //TranslationEditor *te;
  OptionEditor *oe;
  //PixmapEditor *pe;
  CodeGenerator *cg;

  switch((menu_enum) clientdata)
  {
  // File menu
    case menu_new_v:
      guide->new_interface();
    break;
    case menu_save_v:
      guide->save_interface();
    break;
    case menu_save_as_v:
      guide->save_interface_as();
    break;
    case menu_exit_v:
      guide->clean_up();
      exit(0);
    break;
  // Edit menu
    case menu_undo_v:
      guide->undo();
    break;
    case menu_cut_v:
      guide->cut();
    break;
    case menu_copy_v:
      guide->copy();
    break;
    case menu_paste_v:
      guide->paste();
    break;
  // Editor menu
    case menu_design_editor_v:
      de = guide->get_DesignEditor();
      de->popup();
    break;
    case menu_widget_resource_editor_v:
      wre = guide->get_WidgetResourceEditor();
      wre->popup();
    break;
    case menu_core_resource_editor_v:
      cre = guide->get_CoreResourceEditor();
      cre->popup();
    break;
    case menu_constraint_editor_v:
      ce = guide->get_ConstraintEditor();
      ce->popup();
    break;
    case menu_option_editor_v:
      oe = guide->get_OptionEditor();
      oe->popup();
    break;
    case menu_translation_editor_v:
    break;
    case menu_callback_editor_v:
    break;
    case menu_pixmap_editor_v:
    break;
    // Code Menu
    case menu_generate_default_v:
      cg = guide->get_CodeGenerator();
      //      for(i=0;i<last_code_v;i++){
      //        if(guide->code[i])
      //          cg->create_code((code_type_enum)i);
      //     }
      cg->create_code(c_code_v);
      cg->create_code(resource_code_v);
      cg->create_code(main_code_v);
      cg->create_code(callback_code_v);
      cg->create_code(event_code_v);
      cg->create_code(include_code_v);
      cg->create_code(makefile_code_v);
    break;
    case menu_generate_c_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(c_code_v);
    break;
    case menu_generate_cpp_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(cpp_code_v);
    break;
    case menu_generate_resource_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(resource_code_v);
    break;
    case menu_generate_smalltalk_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(smalltalk_code_v);
    break;
    case menu_generate_main_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(main_code_v);
    break;
    case menu_generate_callback_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(callback_code_v);
    break;
    case menu_generate_event_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(event_code_v);
    break;
    case menu_generate_include_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(include_code_v);
    break;
    case menu_generate_makefile_v:
      cg = guide->get_CodeGenerator();
      cg->create_code(makefile_code_v);
    break;
  // Help menu
    case menu_help_version_v:
    break;
    case menu_help_index_v:
    break;
    case menu_help_context_v:
    break;
    default:
    break;
  }
}

void Guide::set_current_widget(WidgetObj* wc)
{
	_wc = wc;
}

void Guide::set_current_interface(InterfaceObj* ic)
{
	_ic = ic;
}

WidgetObj* Guide::get_current_widget(void)
{
	return _wc;
}

InterfaceObj* Guide::get_current_interface(void)
{
	return _ic;
}

List<InterfaceObj>* Guide::get_interface_list(void)
{
	return &_ilist;
}

void Guide::add_interface(InterfaceObj* i)
{
	_ilist.LinkHead(i);
}

void Guide::display_interface(Widget area)
{
  InterfaceObj * temp;
  int y = 10;

  // create a list iterator
  ListIterator<InterfaceObj> iter(_ilist);

  while((temp= iter.CurrentItem()) != NULL)
  {
    if(temp->get_pixmap() != 0)
    XCopyArea(display,
              temp->get_pixmap(),
              XtWindow(area),
              gc,0,0,56,46,10,y);
    temp->set_x(10);
    temp->set_y(y);
    y = y + 46 + 10;
    iter.GetNext();
  }
}

void Guide::new_interface(void)
{
	cout << "Guide::new_interface\n";
}

void Guide::save_interface(void)
{
  InterfaceObj * temp;
  ofstream ofile("interface.mgu");

  // create a list iterator
  ListIterator<InterfaceObj> iter(_ilist);

  while((temp= iter.CurrentItem()) != NULL)
  {
    temp->save(&ofile);
    iter.GetNext();
  }
}

void Guide::save_interface_as(void)
{
	cout << "Guide::save_interface_as\n";
}

void Guide::undo(void)
{
  int x = 20;
  int y = 20;
  int total_x = 20;
  int total_y = 20;

 if(_wbuffer != NULL){
    _winsert->add_widget(_wbuffer);
    _wbuffer->manage();
    _wbuffer = NULL;
  }
  if(_ibuffer != NULL){
    _ilist.LinkHead(_ibuffer);
    (_ibuffer->get_child())->manage();
    _ic = _ibuffer;
    _ibuffer = NULL;
  }

  if(_ic != NULL){
    _wc = _ic->get_child();
    (_ic->get_child())->calculate_icon_positions(x,y,total_x,total_y);
    (_ic->get_child())->set_x((x+total_x)/2);
  }
  _design_editor->update_displays();
}

void Guide::cut(void)
{
  int x = SPACE/2;
  int y = SPACE/2;
  int total_x = SPACE/2;
  int total_y = SPACE/2;


  if(_ic != NULL){

    // don't remove virtual widgets
    if(_wc->get_virtual() == NULL){

      ListIterator<InterfaceObj> *iter;

      // may want to implement this as a list of undo's

      // the widget to be remove is a shell
      if(_wc->get_parent() == NULL){

        // clear the interface buffer
        if(_ibuffer != NULL)
          delete _ibuffer;

        // get the interface from the list
        _ibuffer = _ilist.UnlinkItem(_ic);

        // unmanage the shell
        (_ibuffer->get_child())->unmanage();

        // get the first interface from list as new current interface
        iter = new ListIterator<InterfaceObj>(_ilist);
        _ic = iter->CurrentItem();

        delete iter;

        // clear the widget buffer
        if(_wbuffer != NULL)
          delete _wbuffer;

        _wbuffer = NULL;
      }
      // widget to be removed is not a shell
      else{
        // store the current widgets parent for possible undo op
        _winsert = _wc->get_parent();

        // clear the widget buffer
        if(_wbuffer != NULL)
          delete _wbuffer;

        // retrieve the widget list form parent of widget to be deleted
        List<WidgetObj> * wl =_winsert->get_widget_list();

        _wbuffer = wl->UnlinkItem(_wc);
   
        _wbuffer->unmanage();

        if(_ibuffer != NULL)
          delete _ibuffer;

        _ibuffer = NULL;
      }

      _wc = NULL;

      if(_ic != NULL){
        _wc = _ic->get_child();
        (_ic->get_child())->calculate_icon_positions(x,y,total_x,total_y);
        (_ic->get_child())->set_x((x+total_x)/2);
      }

      _design_editor->update_displays();
      _design_editor->sensitise_all(True);

      if(_wc)
        _design_editor->sensitise_buttons(_wc->get_type());
      else
        _design_editor->sensitise_all(False);
    
      update_variable_name();
      update_widget_name();
    }
  }
}

void Guide::copy(void)
{
	cout << "Guide::copy\n";
}

void Guide::paste(void)
{
	cout << "Guide::paste\n";
}

void Guide::clean_up(void)
{
  delete _design_editor;
  delete _option_editor;
  delete _pixmap_server;
  delete _factory;
  _ilist.DeleteAll();
}

void Guide::save_layout(void)
{
  Arg al[5];
  int ac = 0;
 
  XtSetArg(al[ac],XmNx,&new_layout.Main_x);ac++;
  XtSetArg(al[ac],XmNy,&new_layout.Main_y);ac++;
  XtGetValues(_Guide,al,ac);
}

bool Guide::layout_found(void)
{
	return _layout_found;
}

void Guide::clear_cut_buffers(void)
{
  if(_wbuffer != NULL)
    delete _wbuffer;
  if(_ibuffer != NULL)
    delete _ibuffer;
  _wbuffer = NULL;
  _ibuffer = NULL;
  _winsert = NULL;
}

void Guide::set_variable_name(void)
{
  char * name;

  name = XmTextGetString(_variable_text);
  if(strlen(name) != 0)
  {
    if(strcmp(_wc->get_default_variable_name(),name)==0)
      _wc->set_widget_global(False);
    else
    {
      _wc->set_variable_name(name);
      _wc->set_widget_global(True);
    }
  }
  else
  {
    _wc->set_variable_name(
      _wc->get_default_variable_name());
    _wc->set_widget_global(False);
  }
  XtFree(name);
}

void Guide::set_widget_name(void)
{
  char * name;
  name = XmTextGetString(_widget_text);
  if(strlen(name) != 0)
  {
    _wc->set_widget_name(name);
  }
  else
  {
    _wc->set_widget_name(
      _wc->get_default_widget_name());
  }
  XtFree(name);
}

void Guide::update_variable_name(void)
{
  if(_wc){
    XmTextSetString(_variable_text, _wc->get_variable_name());
    XtManageChild(_frame);
  }
  else
    XtUnmanageChild(_frame);
}

void Guide::update_widget_name(void)
{
  if(_wc)
    XmTextSetString(_widget_text,  _wc->get_widget_name());
}

void Guide::set_variable_name_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  if(guide->get_current_widget())
    guide->set_variable_name();
}

void Guide::set_widget_name_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  if(guide->get_current_widget())
    guide->set_widget_name();
}

