/* ListIterator.h */

#ifndef _LISTITERATOR_H
#define _LISTITERATOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:ListIterator********** Documentation **************/
// Creation Data : Fri Oct 25 13:41:26 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class ListIterator :
 
*/
/*oodE****************************************************/
/*oodB#ListIterator*** Some Definitions and Stuffs *******/
#define FUNCTION (*f)(T *ip)
/*oodE****************************************************/


template<class T>
class ListIterator {
private : // data members
	const List<T>* lp;
	// Points to list to be iterated
	Carrier<T>* current;
public : // member functions
	ListIterator(const List<T>* lptr);
	ListIterator(const List<T>& lref);
	int GetFirst();
	int GetNext();
	int FindFirst(const T& item);
	int FindNext(const T& item);
	T* CurrentItem();
	void Iterate(void FUNCTION);
};

template<class T>
ListIterator<T>::ListIterator(const List<T>* lptr)
: lp(lptr)
{
  GetFirst();  // Sets current to head of list
}

template<class T>
ListIterator<T>::ListIterator(const List<T>& lref)
: lp(&lref),current(lref.GetHead())
{
  // empty
}

template<class T>
int ListIterator<T>::GetFirst()
{
  current = lp ? lp->GetHead() : 0;
  return current != 0;
}

template<class T>
int ListIterator<T>::GetNext()
{
  current = current ? current->next : 0;
  return current != 0;
}

template<class T>
int ListIterator<T>::FindFirst(const T& item)
{
  if (!GetFirst()) return FALSE;
  do {
    if (current->ip && *current->ip == item)
      return TRUE;
  } while (GetNext());
  return FALSE;
}

template<class T>
int ListIterator<T>::FindNext(const T& item)
{
  if (!GetNext()) return FALSE;
  do {
    if (current->ip && *current->ip == item)
      return TRUE;
  } while (GetNext());
  return FALSE;
}

template<class T>
T* ListIterator<T>::CurrentItem()
{
	return current ? current->ip : 0;
}

template<class T>
void ListIterator<T>::Iterate(void FUNCTION)
{
  if (!GetFirst()) return;
  do {
    f(CurrentItem());
  } while (GetNext());
}

#endif
