#include <stdio.h>
#include "LL.h"

typedef struct {
  double          x;
  double          y;
  double          z;
}               t_Vertex;

typedef struct {
  t_Vertex        p;
  t_Vertex        q;
}               t_Segment;

typedef struct {
  t_LL            PolySegment;
}               t_Polygon;

#define MAX_CHAR 100

FILE *FpOut;

#ifdef _NO_PROTO
void ReadValidLine();
#else
void ReadValidLine(char *SingleLine,FILE *FpIn);
#endif



int 
main (argc, argv)
  int             argc;
  char          **argv;
{
  t_Vertex        Point, *OutPoint;
  t_Polygon       Poly, *OutPoly;
  t_Segment       Seg, *OutSeg;
  int             NuVertices, NuPolygon,NuColours;
  t_LL            Vertices;
  t_LL            Segments;
  t_LL            Polygons;
  int             i, j;
  char           *SingleLine;
  double          scale = 1.0;
  FILE           *FpIn;
  char            *BaseName;
  int             Id1, Id2, NuSegments;

  fprintf (stderr, "obj2gf Filter :- P.Hoad 6/7/93\n");

  if (argc < 2) {
    fprintf (stderr, "Usage: obj2gf infile.[obj] outfile [1/scale]\n");
    exit (0);
  }

  if ((FpIn = fopen (argv[1], "r")) == NULL) {
    fprintf (stderr, "File %s Does not exist\n", argv[1]);
    exit (-1);
  }

  if ((FpOut = fopen (argv[2], "w")) == NULL) {
    fprintf (stderr, "File %s Does not exist\n", argv[2]);
    exit (-1);
  }


  if (argc == 4)
    scale = (double) atoi (argv[3]);

  SingleLine = (char*) malloc(100*sizeof(char));
  BaseName = (char*) malloc(100*sizeof(char));
  strcpy (BaseName, argv[2]);

  ReadValidLine(SingleLine,FpIn);
  sscanf (SingleLine, "%d\n",&NuColours);
  for (i = 0; i < NuColours; i++) {
  ReadValidLine(SingleLine,FpIn);
  }
 

  ReadValidLine(SingleLine,FpIn);
  sscanf (SingleLine, "%d\n", &NuVertices);
  Vertices = ConsLL ();
  for (i = 0; i < NuVertices; i++) {
    ReadValidLine(SingleLine,FpIn);
    sscanf (SingleLine, "%*d %lf %lf %lf\n", &Point.x, &Point.y, &Point.z);
    Point.x = Point.x / scale;
    Point.y = Point.y / scale;
    Point.z = Point.z / scale;
    InsLastLL (Vertices, Point);
  }
  Segments = ConsLL ();
  ReadValidLine(SingleLine,FpIn);
  sscanf (SingleLine, "%d\n", &NuSegments);
  for (i = 0; i < NuSegments; i++) {
    ReadValidLine(SingleLine,FpIn);
    sscanf (SingleLine, "%*d %*d %d %d\n", &Id1, &Id2);
    OutPoint = NthElmLL (Vertices, (long) Id1+1);
    Seg.p = *OutPoint;
    OutPoint = NthElmLL (Vertices, (long) Id2+1);
    Seg.q = *OutPoint;
    InsLastLL (Segments, Seg);
  }
  Polygons = ConsLL ();
  ReadValidLine(SingleLine,FpIn);
  sscanf (SingleLine, "%d\n", &NuPolygon);
  for (i = 0; i < NuPolygon; i++) {
    ReadValidLine(SingleLine,FpIn);
    sscanf (SingleLine, "%*d %*d %d ", &NuSegments);
    Poly.PolySegment = ConsLL ();
    for (j = 0; j < NuSegments; j++) {
      sscanf (SingleLine, "%d ", &Id1);
      OutSeg = NthElmLL (Segments, (long) Id1);
      Point = OutSeg->q;
      InsLastLL (Poly.PolySegment, Point);
      Point = OutSeg->p;
      InsLastLL (Poly.PolySegment, Point);
      InsLastLL (Polygons, Poly);
    }
/*    fscanf (FpIn, "\n");*/
  }
  
  /* BUG can't order segments correctly YET! so just line segments */
  /*
  fprintf (FpOut, "@Set %s\nFormat Polygon3D\n", BaseName);
  ForeachLL_M (Polygons, OutPoly) {
    fprintf (FpOut, "%d ", SizeLL (Poly.PolySegment));
    ForeachLL_M (OutPoly->PolySegment, OutPoint) {
      fprintf (FpOut, "%lf %lf %lf ", OutPoint->x, OutPoint->y, OutPoint->z);
    }
    fprintf (FpOut, "\n");
  }
  fprintf (FpOut, "@\n");
  */
  fprintf (FpOut, "@Set %s\nFormat Line3D\n", BaseName);
  ForeachLL_M (Segments, OutSeg) {
      fprintf (FpOut, "%f %f %f %f %f %f\n", 
	OutSeg->p.x, OutSeg->p.y, OutSeg->p.z,
	OutSeg->q.x, OutSeg->q.y, OutSeg->q.z);
  }
  fprintf (FpOut, "@\n");
  exit (0);
}

void 
ReadValidLine(SingleLine,FpIn)
char *SingleLine;FILE *FpIn;
{

  while((fgets(SingleLine, 100, FpIn) == NULL) || !strcmp(SingleLine,"\n") ||
	SingleLine[0]=='#'){
	if( SingleLine[0]=='#'){
	fprintf(FpOut,"; %s",SingleLine);
	}
  }
}
