/*---------- Low level I/O for gf sets read/write  -----------------------*/
/*
 *     author: G. Matas
 *
 *   version: 1.0         date: 9.4. 92
      - terminal \n replaced by \0 not ' ' in fgetline
 *
 */
/*-------------------------------------------------------------------------- */


/* #include <stdio.h> */
/* #include <stdlib.h> */
#include <PGLLstand.h>
#include <PGLLio.h>

static  char buff[MAX_LINE_LENGHT];

static  FileOpenedR =0;
static  FILE * fileR;
int 
OpenPGfileR(fileRname)  char *fileRname;
{
 if (*fileRname=='-')  fileR = stdin;
 else
   if ((fileR  = fopen(fileRname, "r"))==NULL)
       MyErr("Can't open fileR for reading");

 FileOpenedR =1;
 return 0;
}

int 
ClosePGfileR()       
{
 if (!FileOpenedR ) MyErr("Can't close fileR (fileR not opened)");
 if (fileR!= stdin)
   fclose(fileR);
 FileOpenedR = 0;
 return 0;
}


char * 
fgetline(length)  int * length;
{
 char *line=buff;
 
  do{ 
    do{    
      line = fgets(line ,MAX_LINE_LENGHT, fileR);
#ifdef DEBUG
      if (NULL==line) fprintf(stderr,"%s\n%s\n",buff,buff+10);
#endif
      if (NULL==line) return NULL;
    }
    while (('\n' == *line)||(buff[0]==';')) ;
			/* suppress empty lines and lines starting with a ';' */
    while (*line ) line++ ;                               /* find end of line */
    if ((line-buff)>MAX_LINE_LENGHT)
      MyPtrErr("ERR in fgetline - merged line too long");
  }
    
  while (*(line -2)=='\\' && 
          (*(line -2)=' ') &&
          (*(line -1)=' ')
        );                                     /*piggish, replaces / for ' ' */


                 /* in the gf package the terminal \n was repalaced by a ' ' */

  if(*(line-1)=='\n') *(--line)='\0';     /* get rid of terminal \n*/

  if (length != NULL)
    *length  = line - buff;
  return buff;  
}


static  FILE * fileW;
static  FileOpenedW =0;


int 
OpenPGfileW(filename)  char *filename;
{
 if (*filename=='-')  fileW = stdout;
 else
   if ((fileW  = fopen(filename, "w"))==NULL)
       MyErr("Can't open file for writting");

 FileOpenedW =1;
 return 0;
}

int 
ClosePGfileW()
{
 if (!FileOpenedW ) MyErr("Can't close file (file not opened)");
 if (fileW != stdout)
   fclose(fileW);
 FileOpenedW = 0;
 return 0;
}

static char out[MAX_LINE_LENGHT];
static char * lastchar = out;

char * 
fput(s)  char * s;
{
  int length = strlen(s);
  if (lastchar+length>=out+MAX_LINE_LENGHT)
    MyPtrErr("output line too long");
  strcpy(lastchar,s);
  lastchar +=length;
  return out;
}
  
#define LINELEN 75 
#define WRAP     5 

char * 
fputline(s)  char *s;
{
  char * outc;
  char * lastnl;

  fput(s);
   if (!FileOpenedW) MyPtrErr("Can't write  (file not opened)");


  for(outc=out,lastnl=out; *outc; outc++){
   if(( outc-lastnl>LINELEN)&&((lastchar-outc)>WRAP)){
     while (*outc && !((*outc == ' ')||(*outc == '\n'))) fputc(*outc++,fileW); 
     if(*outc != '\n')
       fputs("\\\n       ",fileW);
     else 
       fputs("\n", fileW);
     lastnl=outc;
   }
   else
     fputc(*outc,fileW);
   if (*outc == '\n') lastnl=outc;
  }
  if (*(outc-1)!='\n') fputs("\n", fileW);
  lastchar = out;
  return out;

}  
  
/*
FILE * GetfileW()        { return fileW; }
int IsFileOpenedW()      { return FileOpenedW; }
*/
