#include <stdio.h>
#include <string.h>
#include <PGLLstring.h>

/* non-ANSI string functions available on UNIX */
#ifndef _NO_PROTO 
char * GMstrdup(char * s);
#else 
#ifndef SYSV
#endif
char * GMstrdup();
#endif 

#define DELINLEN 10
static  char delimiters[DELINLEN]={' ','\n','\t','\0'};
char * 
SetDelimiters(del)  char * del;
{
  if (DELINLEN<strlen(del)) MyPtrErr("Too many delimiters");
  return strcpy(delimiters, del);
}

int 
TokenNum(str)  char * str;
{
  int i=0;
  char *Str= GMstrdup(str);
  char *token;


  token = strtok(Str,delimiters);
    while(NULL!=token){
      token = strtok(NULL,delimiters);
     i++;
   }
  free (Str);
  return i;
}

int 
TokenFind(string, token)  char * string; char * token;
{
  if (NULL==strstr(string,token)) return 0;
  return 1;
}

char *
FindNthToken(str, number)   char * str; int number;
{
  int i;
  char *Str= GMstrdup(str);
  char *token;


  token = strtok(Str,delimiters);
  for(i=1; i<number; i++)
    if(NULL==(token = strtok(NULL,delimiters))) return NULL;

  free (Str);
  return str+(token - Str);
}

char *
GetNthToken(str, number)  char * str; int number;
{ int i;
  char *Str= GMstrdup(str);
  char *token;


  token = strtok(Str,delimiters);
  for(i=1; i<number; i++)
    if(NULL==(token = strtok(NULL,delimiters))) return NULL;

  return token;
}

int 
IsTokenPrefStr(token, str)  char *token; char * str;
{ 
  return !strncasecmp(token, str, strlen(token));
}

char** 
str2parr(string)  char * string;
{ 
   int i=0;
   char *Str= GMstrdup(string);

   char **  ArrPtr= (char **) malloc(sizeof(char*)*(TokenNum(Str)+1));

  ArrPtr[i]=strtok(Str,delimiters);
  while(NULL != ArrPtr[i++])
     ArrPtr[i] = strtok(NULL,delimiters);
  return ArrPtr;
}

void 
Dest_parr(ArrPtr)  char ** ArrPtr;
{
    int i=0;

    if (ArrPtr==NULL) return;
    while(NULL != ArrPtr[i])
       free(ArrPtr[i++]);
    free (ArrPtr);
}
    

void 
var2formdat(var_form, form, data)  char * var_form; char *** form; char *** data;
{
   int i=0;
   char *Str= GMstrdup(var_form);
   char *token, * number;

   *form = (char **) malloc(sizeof(char*)*(TokenNum(Str)+1));
   *data = (char **) malloc(sizeof(char*)*(TokenNum(Str)+1));

  token =strtok(Str,delimiters);
  while(NULL != token ){
      number = strpbrk (token,"0123456789");
      (*data)[i]= GMstrdup(number);
      *number = '\0';
      (*form)[i]= GMstrdup(token);
      token = strtok(NULL,delimiters);
      i++;
  }
  (*data)[i]= NULL;
  (*form)[i]= NULL;
}

char * 
ComprStr(s)  char * s;
{
  char *dest=s;
  char *begin=s;

  while (*s){
    *dest++= *s;
    if (*s++==' ')
     while((*s) && (*s==' ')) s++; 
  }
  *dest='\0';
  return begin;
}

char *
GMstrdup (s)  char * s;
{
   char * copy;
   if (NULL == s) { fprintf(stderr,"NULL passed to GMstrdup \n"); exit(-1);}
   if (NULL == (copy = malloc(strlen(s) + 1)))
   {
     fprintf(stderr,"malloc returned NULL in GMstrdup\n");
     exit(-1);
   }
   strcpy(copy,s);
   return copy;
}

