/*----------- Read/Write a LL list of gf sets -------------------------------*/
/*
 *     author: G. Matas
 *     
 *   version: 1.0         date: 9.4. 92
 *
 */
/*-------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "LL.h"
#include "PGLLio.h"
#include "PGLLstring.h"
#include "PGLLstand.h"
 
/* non-ANSI string functions */
#define  Sprintf  (char *)sprintf  /* map to the pre-ANSI sprintf */ /* needs FIXING */
#ifndef _NO_PROTO 
char * GMstrdup(char *);
t_LLSet ReadSet(char * SetName);         /* read-in one set */
void * WriteSet (void * Set);
#else 
char * GMstrdup();
t_LLSet ReadSet();
void * WriteSet ();
#endif 



static char err_buff[1000];     /* buffer for error messages */

/*-------------------------------------------------------------------------*/
t_LL 
ReadLLSets(filename)  char *filename;
{
  t_LL Sets = ConsLL();
  t_LLSet Set;
  char * line, * SetName;

  if (OpenPGfileR(filename)) 
    MyPtrErr(Sprintf(err_buff,"ERR in ReadSets(%s): Can't open file",filename));

  while (NULL != (line=fgetline(NULL))){
    if (IsTokenPrefStr(SET_STA_TOKEN, line))
      if (NULL != (SetName=GetNthToken(line,2))){
	if (NULL != (Set=ReadSet(SetName)))
	  InsLastLL(Sets, Set);
	else
	   MyPtrErr(Sprintf(err_buff,
	    "ERR in ReadSets(%s): ReadSet(%s) returned NULL",filename,SetName));
      }
    else
      MyPtrErr(Sprintf
        (err_buff,"ERR in ReadSets(%s): set without name",filename));
  }
  ClosePGfileR();
  return Sets;
}

/*------------------------------------------------------------------------*/
t_LLSet 
ReadSet(SetName)  char * SetName;
{
  char *line, * tmp_str ;
  t_LLSet Set;

/*   Set = (t_LLSet) malloc (sizeof(t_LLSet*)); */   /* didn't work on DEC */
/*   Set = (t_LLSet) malloc (sizeof(struct s_LLSet));  */
  Set = (t_LLSet) malloc (sizeof(*Set)); 
  Set->id = GMstrdup(SetName);

/*--   Read-in the geomtetric structure definitions (if any)   --- */
  Set->GeomStruct = ConsLL();
  Set->Attributes = ConsLL();
  while (NULL != (line=fgetline(NULL))) {
	if (IsTokenPrefStr(GEOM_TOKEN,line)){
		if (NULL != (tmp_str=FindNthToken(line,2))){
		InsLastLLf(Set->GeomStruct,strlen(tmp_str)+1,tmp_str);}}
	if (IsTokenPrefStr(ATTR_TOKEN,line) || IsTokenPrefStr(SATTR_TOKEN,line)){
		if (NULL != (tmp_str=FindNthToken(line,2))){
		InsLastLLf(Set->Attributes,strlen(tmp_str)+1,tmp_str);}}
	if (IsTokenPrefStr(FORMAT_TOKEN,line)){
		break;
		}
	}
	
  /*
  while (NULL != (line=fgetline(NULL)) && (IsTokenPrefStr(GEOM_TOKEN,line)))
       if (NULL != (tmp_str=FindNthToken(line,2)))
        InsLastLLf(Set->GeomStruct,strlen(tmp_str)+1,tmp_str);

       if (IsTokenPrefStr(ATTR_TOKEN,line)&& (NULL != (tmp_str = FindNthToken(line,2))))
        InsLastLLf(Set->Attributes,strlen(tmp_str)+1,tmp_str);
  */

    
/*----------- Get the format string ------------------------------- */
  if (IsTokenPrefStr(FORMAT_TOKEN,line)&&
      (NULL != (tmp_str = FindNthToken(line,2)))
     )
    Set->format = GMstrdup(tmp_str);
  else 
    MyPtrErr(Sprintf(err_buff,
        "ERR in ReadSet(%s) when reading  format string",SetName));
  
/*------------- Get the set data ------------------------------------*/
  Set->data = ConsLL();
  {
  int l;
  while ((NULL != (line=fgetline(&l)) && !IsTokenPrefStr(SET_END_TOKEN,line)))
      InsLastLLf(Set->data,l+1,line);
  
  }
  return Set;
}

/*------------------------------------------------------------------------*/
int 
WriteLLSets(filename, Sets)  char * filename; t_LL Sets;
{
  if (OpenPGfileW(filename))
     MyErr(Sprintf(err_buff,"ERR in WriteSets(%s): Can't open file",filename));
  ApplyLL(Sets, WriteSet);

  ClosePGfileW();
  return 0;
}

/*------------------------------------------------------------------------*/
void *  
WriteSet(vSet)  void * vSet;
{
  char work[MAX_LINE_LENGHT];
  char * GeomStruct, *data,*Attributes;
  t_LLSet Set = *(t_LLSet*)vSet;

  fputline(Sprintf(work,"%s %s\n",SET_STA_TOKEN,Set->id));

  ForeachLL_M(Set->GeomStruct, GeomStruct)
     fputline(Sprintf(work,"%s %s\n",GEOM_TOKEN,GeomStruct));

  ForeachLL_M(Set->Attributes, Attributes)
    fputline(Sprintf(work,"%s %s\n",ATTR_TOKEN,Attributes));

  fputline(Sprintf(work,"%s %s\n",FORMAT_TOKEN,Set->format));

  ForeachLL_M(Set->data, data)
      fputline(data);

/*      fputline(Sprintf(work,"%s\n",data));  */
  
  fputline(Sprintf(work,"%s\n",SET_END_TOKEN));
  return NULL;
}
