static char         sccsid[] = "@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";

/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <assert.h>

#include "XmgfMalloc.h"

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "PostScript.h"
#include "XFig.h"
#include "FrameMaker.h"
#include "callbacks.h"
#include "3Droutines.h"
#include "Parse.h"
#include "XmgfDefines.h"
#include "Disp3DGF.h"
#include "Init.h"
#include "Read3DSet.h"
#include "GUI.h"
#include "GetColNum.h"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Define of getenv dropped in v1.6 - Any compatibility probs  */
/* certain systems complained at this */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/*
#ifndef _NO_PROTO
char *getenv(char *env);
#else
char *getenv();
#endif
*/

#define MAX_FILE_NAME_LEN 200
double              CentroidX, CentroidY, CentroidZ;
double              CentreX, CentreY, CentreZ;
double              ImageMinX, ImageMaxX, ImageMinY, ImageMaxY;
double		    MinXDisp=10E7;
double 		    MinYDisp=10E7;
double		    MinZDisp=10E7;
double		    MaxXDisp= -10E7;
double 		    MaxYDisp= -10E7;
double		    MaxZDisp= -10E7;
t_LL                CurrentFileList;

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* InitGlobalVar Author: P.Hoad Purpose:  */
/* To initalize the global variables;     */
/* Called by:- only once in main(); initialses every thing!!  */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitGlobalVar()
{
  CentroidX = 0;
  CentroidY = 0;
  CentroidZ = 0;
  CentreX = 0;
  CentreY = 0;
  CentreZ = 0;
  Ox = 0;
  Oy = 0;
  Oz = 0;
  Theta = 0;
  Phi = 0;
  Gamma = 0;
  DistSC = 400;
  ScaleNumber = 6;
  Scale_factor = LogScale(ScaleNumber);
  Midx = DrawingAreaWidth;
  Midy = DrawingAreaHeight;
  defOX = Ox;
  defOY = Oy;
  defOZ = Oz;
  defTheta = Theta;
  defPhi = Phi;
  defGamma = Gamma;
  defscal = DistSC;
  defScale_factor = 0;
  FillPolys = 0;
  SelectColours = 1;
  SelectLabels = 1;
  SelectPoints = 0;
  Sorting = 0;
  PointType = 0;
  OutPost = 0;			/* Output as Postscript */
  PostEPS = 0;			/* Set it to not EPS output */
  OutFig = 0;			/* Output as xfig */
  OutFrame = 0;			/* Output as mif */
  polydiv = 1;			/* Pointset division */
  DefaultLineWidth = 1;
  DefaultLineStyle = SOLIDLS;
  DefaultFillStyle = NOTFILLED;
  DefaultPointSize = 2;
  DefaultTessLevel = 3;
  CurrentFile = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(CurrentFile);
  strcpy(CurrentFile, "None");
  CurrentFileList = ConsLL();
  SetDefaultAttribs();
  LeftEyeColour=GetColourNumber("Red");
  RightEyeColour=GetColourNumber("Cyan");
  MinXDisp = -1000;
  MinYDisp = -1000;
  MinZDisp = -1000;
  MaxXDisp = 1000;
  MaxYDisp = 1000;
  MaxZDisp = 1000;

}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Initalise the File filters and file directories */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitFiles()
{
  char               *tmpdir;
  static int	    FirstPass=1;

  if (FirstPass){
  tmpdir = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(tmpdir);
  tmpdir = (char *) getenv("PWD");
  if (tmpdir == NULL) tmpdir = ".";
  PGMDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(PGMDIR);
  XBMDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(XBMDIR);
  PBMDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(PBMDIR);
  PPMDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(PPMDIR);
  GIFDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(GIFDIR);
  RASDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(RASDIR);
  GFDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(GFDIR);
  IMGDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(IMGDIR);
  POSTDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(POSTDIR);
  EPSDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(EPSDIR);
  FIGDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(FIGDIR);
  PARMDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(PARMDIR);
  RAYDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(RAYDIR);
  IMPORTDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(IMPORTDIR);
  CMAPDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(CMAPDIR);
  MIFDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(MIFDIR);
  ANIMDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(ANIMDIR);
  PCXDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(PCXDIR);
  PICTDIR = (char *) XmgfMalloc(MAX_FILE_NAME_LEN * sizeof(char));
  assert(PICTDIR);

  PGMFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(PGMFIL);
  XBMFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(XBMFIL);
  PBMFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(PBMFIL);
  PPMFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(PPMFIL);
  GIFFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(GIFFIL);
  RASFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(RASFIL);
  GFFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(GFFIL);
  IMGFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(IMGFIL);
  POSTFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(POSTFIL);
  EPSFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(EPSFIL);
  FIGFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(FIGFIL);
  PARMFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(PARMFIL);
  RAYFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(RAYFIL);
  IMPORTFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(IMPORTFIL);
  CMAPFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(CMAPFIL);
  MIFFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(MIFFIL);
  ANIMFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(ANIMFIL);
  PCXFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(PCXFIL);
  PICTFIL = (char *) XmgfMalloc(30 * sizeof(char));
  assert(PICTFIL);
  FirstPass=0;
  }

#ifndef DIR_XDEFAULTS
  strcpy(PGMDIR, tmpdir);
  strcpy(XBMDIR, tmpdir);
  strcpy(PBMDIR, tmpdir);
  strcpy(PPMDIR, tmpdir);
  strcpy(GIFDIR, tmpdir);
  strcpy(RASDIR, tmpdir);
  strcpy(GFDIR, tmpdir);
  strcpy(IMGDIR, tmpdir);
  strcpy(POSTDIR, tmpdir);
  strcpy(EPSDIR, tmpdir);
  strcpy(FIGDIR, tmpdir);
  strcpy(PARMDIR, tmpdir);
  strcpy(RAYDIR, tmpdir);
  strcpy(IMPORTDIR, tmpdir);
  strcpy(CMAPDIR, tmpdir);
  strcpy(MIFDIR, tmpdir);
  strcpy(ANIMDIR, tmpdir);
  strcpy(PCXDIR, tmpdir);
  strcpy(PICTDIR, tmpdir);
#else
  strcpy(PGMDIR, appres.PGMDir);
  strcpy(XBMDIR, appres.XBMDir);
  strcpy(PBMDIR, appres.PBMDir);
  strcpy(PPMDIR, appres.PPMDir);
  strcpy(GIFDIR, appres.GIFDir);
  strcpy(RASDIR, appres.RASDir);
  strcpy(GFDIR, appres.GFDir);
  strcpy(IMGDIR, appres.IMGDir);
  strcpy(POSTDIR, appres.POSTDir);
  strcpy(EPSDIR, appres.EPSDir);
  strcpy(FIGDIR, appres.FIGDir);
  strcpy(PARMDIR, appres.PARMDir);
  strcpy(RAYDIR, appres.RAYDir);
  strcpy(IMPORTDIR, appres.IMPORTDir);
  strcpy(CMAPDIR, appres.CMAPDir);
  strcpy(MIFDIR, appres.MIFDir);
  strcpy(ANIMDIR, appres.ANIMDir);
  strcpy(PCXDIR, appres.PCXDir);
  strcpy(PICTDIR, appres.PICTDir);
#endif

  strcpy(PGMFIL, "*.pgm*");
  strcpy(XBMFIL, "*.xbm*");
  strcpy(PBMFIL, "*.pbm*");
  strcpy(PPMFIL, "*.ppm*");
  strcpy(GIFFIL, "*.gif*");
  strcpy(RASFIL, "*.ras*");
  strcpy(GFFIL, "*.gf*");
  strcpy(IMGFIL, "*.p*m*");
  strcpy(POSTFIL, "*.ps*");
  strcpy(EPSFIL, "*.eps*");
  strcpy(FIGFIL, "*.fig*");
  strcpy(PARMFIL, "*.Parm*");
  strcpy(RAYFIL, "*.ray*");
  strcpy(IMPORTFIL, "*.*");
  strcpy(CMAPFIL, "*.dat*");
  strcpy(MIFFIL, "*.mif*");
  strcpy(ANIMFIL, "*.ani*");
  strcpy(PCXFIL, "*.pcx*");
  strcpy(PICTFIL, "*.pict*");
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitViewScale()
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPt           *Pt;
  t_XmgfPoly         *Poly;
  double              minx, miny, maxx, maxy;
  double              Screen_Scale;
  double              Point_Scale;
  int                 NewScaleNumber;
  long                TotX, TotY, TotZ, count = 0;
  double              MinX, MinY, MinZ, MaxX, MaxY, MaxZ;
  int                 MidOX = 0;
  int                 MidOY = 0;
  int                 MidOZ = 0;

  minx = 10E9;
  miny = 10E9;
  maxx = -10E9;
  maxy = -10E9;
  MinX = MinY = MinZ = 10e7;
  MaxX = MaxY = MaxZ = -10e7;
  TotX = TotY = TotZ = 0;

  UpdateRotationParms();
  if (SizeLL(gfSets.ListXmgfSets) > 0) {
    ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
      ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
	ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	  ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	    ForeachLL_M(Poly->ListXmgfPts, Pt) {
	      NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);
	      if ((ScaleObectType == 0 && SelectedObject->visible == 1)
		|| ScaleObectType == 1) {
		TotX += Pt->x;
		TotY += Pt->y;
		TotZ += Pt->z;
		count++;
		minx = min(minx, ax);
		miny = min(miny, ay);
		maxx = max(maxx, ax);
		maxy = max(maxy, ay);
		MinX = min(Pt->x, MinX);
		MinY = min(Pt->y, MinY);
		MinZ = min(Pt->z, MinZ);
		MaxX = max(Pt->x, MaxX);
		MaxY = max(Pt->y, MaxY);
		MaxZ = max(Pt->z, MaxZ);
	      }
	    }
	  }
	}
      }
    }
    MinXDisp = MinX; MinYDisp = MinY;
    MinZDisp = MinZ; MaxXDisp = MaxX;
    MaxYDisp = MaxY; MaxZDisp = MaxZ;
    if (count >= 1) {
#ifdef DEBUG
      fprintf(stderr, "X %lf %lf\n", minx, maxx);
      fprintf(stderr, "Y %lf %lf\n", miny, maxy);
      fprintf(stderr, " %lf %lf %lf %lf %lf %lf\n", MinXDisp,MinYDisp,MinZDisp,MaxXDisp,MaxYDisp,MaxZDisp);
#endif

      minx = fabs(minx);
      miny = fabs(miny);
      maxx = fabs(maxx);
      maxy = fabs(maxy);

      CentroidX = TotX / count;
      CentroidY = TotY / count;
      CentroidZ = TotZ / count;
      CentreX = ((MaxX + MinX) / 2);
      CentreY = ((MaxY + MinY) / 2);
      CentreZ = ((MaxZ + MinZ) / 2);

      if (!FixateType) {
	MidOX = (int) CentroidX;
	MidOY = (int) CentroidY;
	MidOZ = (int) CentroidZ;

      } else {
	MidOX = (int) CentreX;
	MidOY = (int) CentreY;
	MidOZ = (int) CentreZ;
      }

      Screen_Scale = (double) max(minx, max(miny, max(maxx, maxy)));
      switch (viewtype) {
       case VIEW_ORTH:
	Point_Scale = DrawingAreaWidth / 2 / Screen_Scale;
	break;
       case VIEW_STEREO:
	Point_Scale = DrawingAreaWidth / 2 / Screen_Scale;
	break;
       default:
	Point_Scale = DrawingAreaWidth / 2 / Screen_Scale;
	break;
      }
      NewScaleNumber = Scale2Log(Point_Scale);
#ifdef DEBUG
      fprintf(stderr, "NewScale %d \n", NewScaleNumber);
#endif
      ScaleNumber = NewScaleNumber;
      defScale_factor = ScaleNumber;
      Scale_factor = LogScale(ScaleNumber);
      defOX = -MidOX;
      defOY = -MidOY;
      defOZ = -MidOZ;
      Oz = defOZ;
      Ox = defOX;
      Oy = defOY;
#ifdef DEBUG
      fprintf(stderr, "OX=%d OY=%d OZ=%d\n", MidOX, MidOY, MidOZ);
#endif
    } else {
#ifdef DEBUG
      fprintf(stderr, "Nothing to AutoScale On\n");
#endif
    }
  }
  if (WindowOpen){
    MakeTwoDim();
    FindWorldMaxMin();
  }
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitEmptySet()
{
    if (MinXDisp ==  10E7) MinXDisp = -1000;
    if (MinYDisp ==  10E7) MinYDisp = -1000;
    if (MinZDisp ==  10E7) MinZDisp = -1000;
    if (MaxXDisp ==  10E7) MaxXDisp = 1000;
    if (MaxYDisp ==  10E7) MaxYDisp = 1000;
    if (MaxZDisp ==  10E7) MaxZDisp = 1000;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Make Two Dinensioal if set */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
MakeTwoDim()
{
  if (TwoDimSettings) {
    Theta = 180;
    Phi = 180;
/*  Gamma = 180;*/
    Oz = 0;
    if (BackDropImage == 1) {
      Ox = -OrBackDropWidth / 2;
      Oy = -OrBackDropHeight / 2;
#ifdef DEBUG 
	fprintf(stderr,"%d %d %d %d %d %d %d %d\n",OrBackDropWidth,OrBackDropHeight,Ox,Oy,DrawingAreaWidth,DrawingAreaHeight,Midx,Midy);
#endif
    }
    NewDumpScreenImage();
  }
UpdateRotationParms();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
FindScreenMaxMin()
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPt           *Pt;
  t_XmgfPoly         *Poly;
  double              minx, miny, maxx, maxy;
  long                count = 0;

  minx = 10E9;
  miny = 10E9;
  maxx = -10E9;
  maxy = -10E9;

  UpdateRotationParms();
  if (SizeLL(gfSets.ListXmgfSets) > 0) {
    ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
      ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
	ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	  ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	    ForeachLL_M(Poly->ListXmgfPts, Pt) {
	      NEWTHREEDTWOD(Pt->x, Pt->y, Pt->z);
	      if ((ScaleObectType == 0 && SelectedObject->visible == 1)
		|| ScaleObectType == 1) {
		count++;
		minx = min(minx, ((Scale_factor * ax) + Midy));
		miny = min(miny, ((Scale_factor * ay) + Midy));
		maxx = max(maxx, ((Scale_factor * ax) + Midy));
		maxy = max(maxy, ((Scale_factor * ay) + Midy));
	      }
	    }
	  }
	}
      }
    }
    if (count >= 1) {
      ImageMinX = minx;
      ImageMinY = miny;
      ImageMaxX = maxx;
      ImageMaxY = maxy;
      return;
    }
  }
}
