static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
/* 3D Plotter  */
#include <assert.h>

#include "XmgfMalloc.h"

#include <X11/X.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/SelectioB.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/MenuShell.h>
#include <Xm/Separator.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>

#include "XmgfStruct.h"
#include "XmgfDefines.h"
#include "XmgfGlobal.h"
#include "ReadWriteParm.h"
#include "PostScript.h"
#include "RayShade.h"
#include "XFig.h"
#include "FrameMaker.h"
#include "Pixmaps.h"
#include "Menus.h"
#include "callbacks.h"
#include "Bitmaps.h"
#include "Icons.h"
#include "Init.h"
#include "InitX.h"
#include "Read3DSet.h"
#include "GUI.h"
#include "Printer.h"
#include "Parse.h"
#include "MotifUtils.h"
#include "Mouse.h"
#include "Disp3DGF.h"
#include "XmgfHelp.h"
#include "XmgfFont.h"
#include "BITMAPS/About.xbm"

#define LOAD_FILE 0
#define APPEND_FILE 1
#define SAVE_FILE 2

#define MENUPUSH(wdg,str,par,callba,parm) {\
(wdg) = XtCreateManagedWidget((str),xmPushButtonWidgetClass,(par), args, 0);\
XtAddCallback((wdg), XmNactivateCallback,(XtCallbackProc)(callba),(caddr_t)(parm));}
#define MENUTOGG(wdg,str,par,callba,parm) {\
(wdg) = XtCreateManagedWidget((str),xmToggleButtonWidgetClass,(par), args, 0);\
XtAddCallback((wdg), XmNvalueChangedCallback,(XtCallbackProc)(callba),(caddr_t)(parm));}


Widget  QuttButt, LineDot, LineDas, SaveASTitleSep;
Widget  Line0pt, Line1pt, Line2pt, Line3pt, Line4pt, Line5pt;
Widget  w_PTBox, w_PTTri, w_PTPlus, w_PTCross, w_PTFillBox, w_PTFillCircle;
Widget  FileSelector, w_PTFillTri, w_PTCircle, PointTypeTitleSep;
Widget  NoFill, DoFill, Hide_Line, BlackFill, WhiteFill, OpaqueFill;
Widget  ShFill, ShadeLines, PointSFill, RotBB, DoubleBuffer, LoadButt;
Widget  BackGrdImage;
Widget  SaveButt, SaveAsButt, LoadColourMapButt, LoadGreyMapButt;
Widget  PointTyp1, PointTyp2, PointTyp3, PointTyp4, PointTyp5;
Widget  SelLabels, SelExpand, DepthCue, AutoSTButt, FixateTButt;
Widget  PointTyp6, PointTyp7, PointTyp8, PointSize, SaveASTitle;
Widget  LoadParmButt, SaveParmButt, AboutButt, PrintButt, SavePSButt;
Widget  SavePSButtCol, SavePSPButt, SavePSPButtCol, PrintColourBB;
Widget  SaveFIGButt, SaveFIGButtCol, SavePGMButt, SaveXBMButt;
Widget  SaveRAYButt, SelPoints, AppendButt, BackGrdColour, w_PTPoint;
Widget  SavePPMButt, SaveGIFButt, SaveRASButt, SaveRASButtCol;
Widget  SavePCXButt,SavePICTButt;
Widget  ImportOFFButt, ImportNFFButt, ImportRAYButt, ImportTitle;
Widget  ImportSLAButt, ImportOBJButt, ImportTitleSep, SavePBMButt;
Widget  ImportIGRIPButt,ImportMINICADButt,ImportDXFButt;
Widget  LoadFileSel, AppendFileSel, SaveFileSel, DrawAxisLabel;
Widget  AboutShellDia, PrintShellDia, FillShellDia, PtSizeShellDia;
Widget  ARPhiScal, ARGammaScal, ARThetaScal, ATRotSize, LandScapeBB;
Widget  w_FileSelectorDia, PtSizeScal, LineSol, SaveMIFButt;
Widget  w_FileSelector, OrthOPro, DefGrdColor;
Widget  AxisZero, AxisCentroid, AxisCentre, AxisSize;
Widget  SaveEPSButtPor, SaveEPSButtLan, AxisSizeScal, AxisSizeShellDia;
Widget  LineShellDia, PointShellDia, PolygonShellDia, PointTyp9;
Widget  ReRead, ColouredOpaqueFill,AnimButt,OutLineCol,ColDither,OutLineBu;
Widget  PointTyp10,w_PTFillSphere;

Widget  CourierButt,HelvetButt,NewCenSchButt,SymbolButt,TimesButt;
Widget  BoldButt,NOBoldButt,ItalicButt,NoItalicButt;
Widget  Fnt6pt,Fnt7pt,Fnt8pt,Fnt9pt,Fnt10pt,Fnt12pt,Fnt14pt;
Widget  Fnt16pt,Fnt18pt,Fnt20pt,Fnt22pt,Fnt24pt,Fnt30pt,Fnt36pt,Fnt72pt;
Widget  PointCueW,HaloedFill,w_HalColor,AxisBox,w_RedBlue,w_RedCol,w_BlueCol;
Widget  IconRowCol;

char    SaveAsFilename[100];

/* Icons Panel */
#define ICON2D 9
#define ICONORTH 13
#define ICONEXPAND 17
#define ICONAXIS 18
#define ICONDOUBLE 20 
#define ICONSORT 21
#define ICONROTGUIDE 22
#define ICONLABEL 23
#define ICONAROT 24
#define ICONOUTLINE 31
#define ICONDITHER 33
#define ICONDPTHCUE 34
#define ICONBACKFACE 35

char   *Selectedfilename = NULL;

#ifndef _NO_PROTO
void    MouseMessages(Widget widget, XtPointer closure, XEvent * event, Boolean * done);
void     MakePolygonSubMenu(Widget parent);
void    MakeSeper(Widget parent);
#else
void    MouseMessages();
void     MakePolygonSubMenu();
void    MakeSeper();
#endif

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Create The Main Menus area */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
Create_Menus(farg,fnum)
Arg *farg;
int fnum;
{
 /* set up windows */
  Arg     args[10];
  unsigned int n = 0;
  Widget  menu_bar;
  Widget  menu_pane1;
  Widget  menu_pane1aa;
  Widget  menu_pane1a;
  Widget  menu_pane1a1, menu_pane1a2, menu_pane1a3;
  Widget  menu_pane2;
  Widget  menu_pane2a;
  Widget  menu_pane3;
  Widget  menu_pane4;
  Widget  menu_pane5;
  Widget  menu_pane5b;
  Widget  menu_pane5c;
  Widget  menu_pane6;
  Widget  menu_pane6a;
  Widget  menu_pane7;
  Widget  menu_pane8;
  Widget  menu_pane8a,menu_pane8b,menu_pane8c,menu_pane8d;
  Widget  PERView, ORTHView, STEREOView;


 /* Menus */
  /*
  XtSetArg(args[0], XmNshadowType, XmSHADOW_ETCHED_IN); n++;
  XtSetArg(args[1], XmNshadowThickness, 1); n++;
  */
  menu_bar = XmCreateMenuBar(mainpane, "menu_bar", farg, fnum);

  menu_pane1 = XmCreatePulldownMenu(menu_bar, "menu_pane1", args, n);
  menu_pane2 = XmCreatePulldownMenu(menu_bar, "menu_pane2", args, n);
  menu_pane2a = XmCreatePulldownMenu(menu_bar, "menu_pane2a", args, n);
  menu_pane3 = XmCreatePulldownMenu(menu_bar, "menu_pane3", args, n);
  menu_pane4 = XmCreatePulldownMenu(menu_bar, "menu_pane4", args, n);
  menu_pane5 = XmCreatePulldownMenu(menu_bar, "menu_pane5", args, n);
  menu_pane6 = XmCreatePulldownMenu(menu_bar, "menu_pane6", args, n);
  menu_pane8 = XmCreatePulldownMenu(menu_bar, "menu_pane8", args, n);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Load a 3D gf Set */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  LoadButt = XtCreateWidget(" Load New Sets ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(LoadButt, XmNactivateCallback,
    (XtCallbackProc) LoadCB, (caddr_t) NULL);
  XtManageChild(LoadButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Append a 3D gf Set */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  AppendButt = XtCreateWidget(" Append Sets ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(AppendButt, XmNactivateCallback,
    (XtCallbackProc) AppendCB, (caddr_t) NULL);
  XtManageChild(AppendButt);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* ImportButt */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  menu_pane1aa = XmCreatePulldownMenu(menu_pane1, "menu_pane1aa", args, n);
  MakeMenuButton(menu_pane1, menu_pane1aa, " Import CAD Files..",
    "ImportMenuButt", (char *) 'I');

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import as Button Title and PullDownMenu Pane */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNlabelString, Str2MotStr("Import CAD Files.."));n++;
  ImportTitle = XtCreateWidget("MenuTitleString",
    xmLabelWidgetClass, menu_pane1aa, args, n);
  XtManageChild(ImportTitle);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as Seperator */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNheight, 8); n++;
  ImportTitleSep = XmCreateSeparator(menu_pane1aa, "ImportTitleSep", args, n);
  XtManageChild(ImportTitleSep);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As OFF					       */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportOFFButt = XtCreateManagedWidget(" Import OFF ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportOFFButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_OFF_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As NFF                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportNFFButt = XtCreateManagedWidget(" Import NFF ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportNFFButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_NFF_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As SLA                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportSLAButt = XtCreateManagedWidget(" Import SLA ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportSLAButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_SLA_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As OBJ                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportOBJButt = XtCreateManagedWidget(" Import OBJ(x3d) ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportOBJButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_OBJ_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As RAY                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportRAYButt = XtCreateManagedWidget(" Import RAY(rayshade) ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportRAYButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_RAY_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As DXF                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportDXFButt = XtCreateManagedWidget(" Import DXF(autocad) ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportDXFButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_DXF_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As IGRIP                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportIGRIPButt = XtCreateManagedWidget(" Import IGRIP ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportIGRIPButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_IGRIP_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Import As MINICAD                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, TRUE);n++;
  ImportMINICADButt = XtCreateManagedWidget(" Import MINICAD ",
    xmPushButtonWidgetClass, menu_pane1aa, args, n);
  XtAddCallback(ImportMINICADButt, XmNactivateCallback,
    (XtCallbackProc) ImportCB, (caddr_t) IMPORT_MINICAD_FILE);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */






 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as Button Title and PullDownMenu Pane */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  menu_pane1a = XmCreatePulldownMenu(menu_pane1, "menu_pane1a", args, n);
  MakeMenuButton(menu_pane1, menu_pane1a, " Save As...      ",
    "SaveMenuButt", (char *) 'S');

  MakeSeper(menu_pane1);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Load a 3D Parameter file */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  LoadParmButt = XtCreateWidget(" Load Parms ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(LoadParmButt, XmNactivateCallback,
    (XtCallbackProc) LoadParm, (caddr_t) NULL);
  XtManageChild(LoadParmButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save 3D Parameter file */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveParmButt = XtCreateWidget(" Save Parms ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(SaveParmButt, XmNactivateCallback,
    (XtCallbackProc) SaveParm, (caddr_t) NULL);
  XtManageChild(SaveParmButt);
  MakeSeper(menu_pane1);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Load a ColourMap file  */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  LoadColourMapButt = XtCreateWidget(" Load Colour Map ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(LoadColourMapButt, XmNactivateCallback,
    (XtCallbackProc) LoadCMapCB, (caddr_t) NULL);
  XtManageChild(LoadColourMapButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Load a GreyMap file  */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  LoadGreyMapButt = XtCreateWidget(" Load GreyScale Map ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(LoadGreyMapButt, XmNactivateCallback,
    (XtCallbackProc) LoadGMapCB, (caddr_t) NULL);
  XtManageChild(LoadGreyMapButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  MakeSeper(menu_pane1);



 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* About Xmgf */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  PrintButt = XtCreateWidget(" Print....    ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(PrintButt, XmNactivateCallback,
    (XtCallbackProc) PrintCB, (caddr_t) NULL);
  XtManageChild(PrintButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* About Xmgf */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  AboutButt = XtCreateWidget(" About....    ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(AboutButt, XmNactivateCallback,
    (XtCallbackProc) AboutCB, (caddr_t) NULL);
  XtManageChild(AboutButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  MakeSeper(menu_pane1);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Quit Xmgf */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  QuttButt = XtCreateWidget(" Quit ",
    xmPushButtonWidgetClass, menu_pane1, args, n);
  XtAddCallback(QuttButt, XmNactivateCallback,
    (XtCallbackProc) QuitCB, (caddr_t) NULL);
  XtManageChild(QuttButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as Button Title and PullDownMenu Pane */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNlabelString, Str2MotStr("Save As....."));n++;
  SaveASTitle = XtCreateWidget("MenuTitleString",
    xmLabelWidgetClass, menu_pane1a, args, n);
  XtManageChild(SaveASTitle);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as Seperator */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNheight, 8); n++;
  SaveASTitleSep = XmCreateSeparator(menu_pane1a, "SaveASTitleSep", args, n);
  XtManageChild(SaveASTitleSep);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Postscript Sub Menu */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  menu_pane1a1 = XmCreatePulldownMenu(menu_pane1a, "menu_pane1a1", args, n);
  MakeMenuButton(menu_pane1a, menu_pane1a1, " Save As PostScript ",
    "PostMenuButt", (char *) 'P');

  n=0;
  SavePSButt = XtCreateWidget(" GreyScale LandScape",
    xmPushButtonWidgetClass, menu_pane1a1, args, n);
  XtAddCallback(SavePSButt, XmNactivateCallback,
    (XtCallbackProc) SavePSCB, (caddr_t) SAVE_GREY_LAND);
  XtManageChild(SavePSButt);
  n=0;
  SavePSPButt = XtCreateWidget(" GreyScale Portrait",
    xmPushButtonWidgetClass, menu_pane1a1, args, n);
  XtAddCallback(SavePSPButt, XmNactivateCallback,
    (XtCallbackProc) SavePSCB, (caddr_t) SAVE_GREY_PORT);
  XtManageChild(SavePSPButt);

  n=0;
  SavePSButtCol = XtCreateWidget(" Colour LandScape",
    xmPushButtonWidgetClass, menu_pane1a1, args, n);
  XtAddCallback(SavePSButtCol, XmNactivateCallback,
    (XtCallbackProc) SavePSCB, (caddr_t) SAVE_COLOUR_LAND);
  XtManageChild(SavePSButtCol);
  n=0;
  SavePSPButtCol = XtCreateWidget(" Colour Portrait",
    xmPushButtonWidgetClass, menu_pane1a1, args, n);
  XtAddCallback(SavePSPButtCol, XmNactivateCallback,
    (XtCallbackProc) SavePSCB, (caddr_t) SAVE_COLOUR_PORT);
  XtManageChild(SavePSPButtCol);
  n=0;
  SaveEPSButtPor = XtCreateWidget(" EPS Portrait",
    xmPushButtonWidgetClass, menu_pane1a1, args, n);
  XtAddCallback(SaveEPSButtPor, XmNactivateCallback,
    (XtCallbackProc) SavePSCB, (caddr_t) SAVE_EPS_PORT);
  XtManageChild(SaveEPSButtPor);
  n=0;
  SaveEPSButtLan = XtCreateWidget(" EPS LandScape",
    xmPushButtonWidgetClass, menu_pane1a1, args, n);
  XtAddCallback(SaveEPSButtLan, XmNactivateCallback,
    (XtCallbackProc) SavePSCB, (caddr_t) SAVE_EPS_LAND);
  XtManageChild(SaveEPSButtLan);



 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as RayShade file */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveRAYButt = XtCreateWidget(" Save As RayShade ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SaveRAYButt, XmNactivateCallback,
    (XtCallbackProc) SaveRAYCB, (caddr_t) NULL);
  XtManageChild(SaveRAYButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as Fig file */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  menu_pane1a2 = XmCreatePulldownMenu(menu_pane1a, "menu_pane1a2", args, n);
  MakeMenuButton(menu_pane1a, menu_pane1a2, " Save As XFig ",
    "PostMenuButt", (char *) 'F');

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Fig GreyScale                                               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveFIGButt = XtCreateWidget(" GreyScale ",
    xmPushButtonWidgetClass, menu_pane1a2, args, n);
  XtAddCallback(SaveFIGButt, XmNactivateCallback,
    (XtCallbackProc) SaveFIGCB, (caddr_t) SAVE_GREY);
  XtManageChild(SaveFIGButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Fig Colour                                                  */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveFIGButtCol = XtCreateWidget(" Colour ",
    xmPushButtonWidgetClass, menu_pane1a2, args, n);
  XtAddCallback(SaveFIGButtCol, XmNactivateCallback,
    (XtCallbackProc) SaveFIGCB, (caddr_t) SAVE_COLOUR);
  XtManageChild(SaveFIGButtCol);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as MIF file */
 /* Callback still to be completed */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveMIFButt = XtCreateWidget(" Save As MIF ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SaveMIFButt, XmNactivateCallback,
    (XtCallbackProc) SaveFRAMECB, (caddr_t) NULL);
  XtManageChild(SaveMIFButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as PGM file */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SavePGMButt = XtCreateWidget(" Save As PGM ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SavePGMButt, XmNactivateCallback,
    (XtCallbackProc) SavePGMCB, (caddr_t) NULL);
  XtManageChild(SavePGMButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as XBM file */
 /* Callback still to be completed */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveXBMButt = XtCreateWidget(" Save As XBM ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SaveXBMButt, XmNactivateCallback,
    (XtCallbackProc) SaveXBMCB, (caddr_t) NULL);
  XtManageChild(SaveXBMButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as PBM file */
 /* Callback still to be completed */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SavePBMButt = XtCreateWidget(" Save As PBM ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SavePBMButt, XmNactivateCallback,
    (XtCallbackProc) SavePBMCB, (caddr_t) NULL);
  XtManageChild(SavePBMButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as PPM file */
 /* Callback still to be completed */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SavePPMButt = XtCreateWidget(" Save As PPM ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SavePPMButt, XmNactivateCallback,
    (XtCallbackProc) SavePPMCB, (caddr_t) NULL);
  XtManageChild(SavePPMButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as GIF file */
 /* Callback still to be completed */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveGIFButt = XtCreateWidget(" Save As GIF ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SaveGIFButt, XmNactivateCallback,
    (XtCallbackProc) SaveGIFCB, (caddr_t) NULL);
  XtManageChild(SaveGIFButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as RAS file */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  menu_pane1a3 = XmCreatePulldownMenu(menu_pane1a, "menu_pane1a3", args, n);
  MakeMenuButton(menu_pane1a, menu_pane1a3, " Save As SunRaster ",
    "PostMenuButt", (char *) 'R');

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* RAS Grey 					               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveRASButt = XtCreateWidget(" GreyScale ",
    xmPushButtonWidgetClass, menu_pane1a3, args, n);
  XtAddCallback(SaveRASButt, XmNactivateCallback,
    (XtCallbackProc) SaveRASCB, (caddr_t) SAVE_GREY);
  XtManageChild(SaveRASButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* RAS Colour 					               */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SaveRASButtCol = XtCreateWidget(" Colour ",
    xmPushButtonWidgetClass, menu_pane1a3, args, n);
  XtAddCallback(SaveRASButtCol, XmNactivateCallback,
    (XtCallbackProc) SaveRASCB, (caddr_t) SAVE_COLOUR);
  XtManageChild(SaveRASButtCol);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as PCX file */
 /* Callback still to be completed */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, False);n++;
  SavePCXButt = XtCreateWidget(" Save As PCX ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SavePCXButt, XmNactivateCallback,
    (XtCallbackProc) SavePCXCB, (caddr_t) NULL);
  XtManageChild(SavePCXButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Save as PICT file */
 /* Callback still to be completed */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNsensitive, False);n++;
  SavePICTButt = XtCreateWidget(" Save As PICT ",
    xmPushButtonWidgetClass, menu_pane1a, args, n);
  XtAddCallback(SavePICTButt, XmNactivateCallback,
    (XtCallbackProc) SavePICTCB, (caddr_t) NULL);
  XtManageChild(SavePICTButt);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Line Thickness Menu */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  MakeLineWidthSubMenu(menu_pane2);
  MakeLineStyleSubMenu(menu_pane2a);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Point Type Menu */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

  MENUPUSH(PointTyp1, " Point  ",menu_pane3,PointAttrCB,MENU_POINT)
  MENUPUSH(PointTyp2, " Plus   ",menu_pane3,PointAttrCB,MENU_PLUS)
  MENUPUSH(PointTyp3, " Cross  ",menu_pane3,PointAttrCB,MENU_CROSS)
  MENUPUSH(PointTyp4, " Box    ",menu_pane3,PointAttrCB,MENU_BOX)
  MENUPUSH(PointTyp5, " Triangle ",menu_pane3,PointAttrCB,MENU_TRI)
  MENUPUSH(PointTyp6, " Circle ",menu_pane3,PointAttrCB,MENU_CIRCLE)
  MENUPUSH(PointTyp7, " Filled Box",menu_pane3,PointAttrCB,MENU_FILLEDBOX)
  MENUPUSH(PointTyp8, " Filled Triangle",menu_pane3,PointAttrCB,MENU_FILLEDTRI)
  MENUPUSH(PointTyp9, " Filled Circle ",menu_pane3,PointAttrCB,MENU_FILLEDCIRCLE)
  MENUPUSH(PointTyp10," Sphere ",menu_pane3,PointAttrCB,MENU_FILLEDSPHERE)


 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


  MakePolygonSubMenu(menu_pane4);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Option Menu */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

  MENUPUSH(TransformRes, " Reset Translation  ",menu_pane5,ResetTrans,0)
  MENUPUSH(Reset_Button, " Reset Position  ",menu_pane5,ResetScale,0)
  MENUTOGG(Set2DButt, " 2D Settings  ",menu_pane5,Set2DCB,1)
  MENUTOGG(OrthOPro, " Orthographic  ",menu_pane5,OrthoGraphicCB,0)
  MakeSeper(menu_pane5);
  MENUTOGG(SortPolyButt, " Sort Polygons  ",menu_pane5,SortCB,1) 
  MENUTOGG(DoubleBuffer, "  Double Buffering ",menu_pane5,DoubleBCB,0)
  MENUTOGG(BackCull, "  BackFace Culling ",menu_pane5,BackFaceCB,1)
  MENUTOGG(DepthCue, "  Depth Cue ",menu_pane5,DepthCueCB,1)
  MENUTOGG(PointCueW, "  Point Size Cueing ",menu_pane5,PointCueCB,1)
  MakeSeper(menu_pane5);
  MENUTOGG(SelColor, "  Colours ",menu_pane5,SelColorCB,1)
  MENUTOGG(OutLineBu, "  OutLine ",menu_pane5,OutLineCB,1)
  MENUPUSH(OutLineCol, "  OutLine Colour ",menu_pane5,OutLineColCB,0)
  MENUPUSH(w_HalColor, "  Haloed Colour ",menu_pane5,HaloColCB,0)
  MakeSeper(menu_pane5);
  MENUTOGG(w_RedBlue, "  Dual Colour Stereo ",menu_pane5,RedBlueCB,0) 
  MENUPUSH(w_RedCol, "  Left Eye Colour ",menu_pane5,StereoCOlCB,LEFTEYE)
  MENUPUSH(w_BlueCol, "  Right Eye Colour ",menu_pane5,StereoCOlCB,RIGHTEYE)
  MakeSeper(menu_pane5);
  MENUPUSH(PointSize, "  PointSize ",menu_pane5,CreatePtSizePalCB,0) 
  MENUTOGG(SelLabels, "  Labels ",menu_pane5,SelLabelsCB,1) 


  MENUPUSH(ReRead, "  ReRead ",menu_pane6,ReReadCB,0) 
  MakeSeper(menu_pane6);
  MENUPUSH(AnimButt, "  Animation ",menu_pane6,AnimationCB,0) 
  MENUTOGG(Rotate_Button, "  Auto Rotate ",menu_pane6,AutoRotate,0) 
  MENUPUSH(ATRotSize, "  AutoRotate Options ",menu_pane6,CreateARSizePalCB,0) 
  MENUTOGG(RotBB, "  Rotate Guide ",menu_pane6,RotateBBCB,1) 
  CreateARSizePal(toplevel);
  MakeSeper(menu_pane6);
  

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* DrawAxisLabel  ToggleOption */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  DrawAxisLabel = XtCreateManagedWidget(" Axis",
    xmToggleButtonWidgetClass, menu_pane6, args, n);
  XtAddCallback(DrawAxisLabel, XmNvalueChangedCallback,
    (XtCallbackProc) AxisLABCB, (caddr_t) 1);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* AxisSize  Button */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  AxisSize = XtCreateManagedWidget(" AxisSize",
    xmPushButtonWidgetClass, menu_pane6, args, n);
  XtAddCallback(AxisSize, XmNactivateCallback,
    (XtCallbackProc) CreateAxisSizePalCB, (caddr_t) 0);

  menu_pane6a = XmCreatePulldownMenu(menu_pane6, "menu_pane6a", args, 0);
  MakeMenuButton(menu_pane6, menu_pane6a, " AxisType",
    "AxisTypeButt", (char *) 'A');

  n=0;
  AxisZero = XtCreateManagedWidget(" Axis on Zero ",
    xmPushButtonWidgetClass, menu_pane6a, args, n);
  XtAddCallback(AxisZero, XmNactivateCallback,
    (XtCallbackProc) AxisTypeCB, (caddr_t) AXIS_ON_ZERO);

  n=0;
  AxisCentroid = XtCreateManagedWidget(" Axis on Centroid ",
    xmPushButtonWidgetClass, menu_pane6a, args, n);
  XtAddCallback(AxisCentroid, XmNactivateCallback,
    (XtCallbackProc) AxisTypeCB, (caddr_t) AXIS_ON_CENTROID);

  n=0;
  AxisCentre = XtCreateManagedWidget(" Axis on Centre ",
    xmPushButtonWidgetClass, menu_pane6a, args, n);
  XtAddCallback(AxisCentre, XmNactivateCallback,
    (XtCallbackProc) AxisTypeCB, (caddr_t) AXIS_ON_CENTRE);

  n=0;
  AxisBox = XtCreateManagedWidget(" Axis Box",
    xmPushButtonWidgetClass, menu_pane6a, args, n);
  XtAddCallback(AxisBox, XmNactivateCallback,
    (XtCallbackProc) AxisTypeCB, (caddr_t) AXIS_BOX);

  MakeSeper(menu_pane6);


 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Select Labels  ToggleOption */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
#ifdef AUTOSCALE_ON_CENTROID
  FixateTButt = XtCreateManagedWidget(" Fixate on Centroid ",
#else
  FixateTButt = XtCreateManagedWidget(" Fixate on Centre ",
#endif
    xmToggleButtonWidgetClass, menu_pane6, args, n);
  XtAddCallback(FixateTButt, XmNvalueChangedCallback,
    (XtCallbackProc) FixateTButtCB, (caddr_t) 1);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Select Labels  ToggleOption */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 n=0;
#ifdef AUTOSCALE_ON_ALL
  AutoSTButt = XtCreateManagedWidget(" AutoScale on All ",
#else
  AutoSTButt = XtCreateManagedWidget(" AutoScale on Visible ",
#endif
    xmToggleButtonWidgetClass, menu_pane6, args, n);
  XtAddCallback(AutoSTButt, XmNvalueChangedCallback,
    (XtCallbackProc) AutoSTButtCB, (caddr_t) 1);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  MakeSeper(menu_pane6);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Expand Image ToggleOption */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  SelExpand = XtCreateWidget(" Expand Image ",
    xmToggleButtonWidgetClass, menu_pane6, args, n);
  XtAddCallback(SelExpand, XmNvalueChangedCallback,
    (XtCallbackProc) SelExpandCB, (caddr_t) 1);
  XtManageChild(SelExpand);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Background Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

  menu_pane5b = XmCreatePulldownMenu(menu_pane5, "menu_pane5b", args, 0);
  MakeMenuButton(menu_pane6, menu_pane5b, " Background",
    "SaveMenuButt", (char *) 'B');

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Colour */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  BackGrdColour = XtCreateManagedWidget(" Colour ",
    xmPushButtonWidgetClass, menu_pane5b, args, n);
  XtAddCallback(BackGrdColour, XmNactivateCallback,
    (XtCallbackProc) BackGrdCB, (caddr_t) BACK_GRD_COL);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Image */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  BackGrdImage = XtCreateManagedWidget(" Image ",
    xmPushButtonWidgetClass, menu_pane5b, args, n);
  XtAddCallback(BackGrdImage, XmNactivateCallback,
    (XtCallbackProc) BackGrdCB, (caddr_t) BACK_GRD_IMG);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Image */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  DefGrdColor = XtCreateManagedWidget(" Default ",
    xmPushButtonWidgetClass, menu_pane5b, args, n);
  XtAddCallback(DefGrdColor, XmNactivateCallback,
    (XtCallbackProc) BackGrdCB, (caddr_t) DEF_GRD_IMG);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* ViewType Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  menu_pane5c = XmCreatePulldownMenu(menu_pane5, "menu_pane5c", args, n);
  MakeMenuButton(menu_pane6, menu_pane5c, " ViewType",
    "SaveMenuButt", (char *) 'V');

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Stereo Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  MENUPUSH(PERView," Perspective ",menu_pane5c,ChangeView,VIEW_PERS)
  MENUPUSH(ORTHView," Orthographic ",menu_pane5c,ChangeView,VIEW_ORTH)
  MENUPUSH(STEREOView," Stereo ",menu_pane5c,ChangeView,VIEW_STEREO)

  /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  menu_pane8a = XmCreatePulldownMenu(menu_pane8, "menu_pane8a", args, n);
  menu_pane8b = XmCreatePulldownMenu(menu_pane8, "menu_pane8b", args, n);
  menu_pane8c = XmCreatePulldownMenu(menu_pane8, "menu_pane8c", args, n);
  menu_pane8d = XmCreatePulldownMenu(menu_pane8, "menu_pane8d", args, n);
  MakeMenuButton(menu_pane8, menu_pane8a, " Font Name...",
				"FontName", (char *) 'N');
  MakeMenuButton(menu_pane8, menu_pane8b, " Font Weight...",
				"FontWeight", (char *) 'W');
  MakeMenuButton(menu_pane8, menu_pane8c, " Font Slant...",
				"FontSlant", (char *) 'I');
  MakeMenuButton(menu_pane8, menu_pane8d, " Font Size...",
				"FontSize", (char *) 'S');

  MENUPUSH(CourierButt," Courier ",menu_pane8a,FNTNCB,COURIER)
  MENUPUSH(HelvetButt," Helvetica ",menu_pane8a,FNTNCB,HELVETICA)
  MENUPUSH(NewCenSchButt," New Century Schoolbook ",menu_pane8a,FNTNCB,NEWCENSCH)
  MENUPUSH(SymbolButt," Symbol ",menu_pane8a,FNTNCB,SYMBOL)
  MENUPUSH(TimesButt," Times ",menu_pane8a,FNTNCB,TIMES)

  MENUPUSH(BoldButt," Bold ",menu_pane8b,FNTWCB,BOLD)
  MENUPUSH(NOBoldButt," Normal ",menu_pane8b,FNTWCB,MEDIUM)

  MENUPUSH(ItalicButt," Italic ",menu_pane8c,FNTICB,ITALIC)
  MENUPUSH(NoItalicButt," Normal ",menu_pane8c,FNTICB,NOITALIC)

  MENUPUSH(Fnt6pt," 6pt ",menu_pane8d,FNTSCB,6)
  MENUPUSH(Fnt7pt," 7pt ",menu_pane8d,FNTSCB,7)
  MENUPUSH(Fnt8pt," 8pt ",menu_pane8d,FNTSCB,8)
  MENUPUSH(Fnt9pt," 9pt ",menu_pane8d,FNTSCB,9)
  MENUPUSH(Fnt10pt," 10pt ",menu_pane8d,FNTSCB,10)
  MENUPUSH(Fnt12pt," 12pt ",menu_pane8d,FNTSCB,12)
  MENUPUSH(Fnt14pt," 14pt ",menu_pane8d,FNTSCB,14)
  MENUPUSH(Fnt16pt," 16pt ",menu_pane8d,FNTSCB,16)
  MENUPUSH(Fnt18pt," 18pt ",menu_pane8d,FNTSCB,18)
  MENUPUSH(Fnt20pt," 20pt ",menu_pane8d,FNTSCB,20)
  MENUPUSH(Fnt22pt," 22pt ",menu_pane8d,FNTSCB,22)
  MENUPUSH(Fnt24pt," 24pt ",menu_pane8d,FNTSCB,24)
  MENUPUSH(Fnt30pt," 30pt ",menu_pane8d,FNTSCB,30)
  MENUPUSH(Fnt36pt," 36pt ",menu_pane8d,FNTSCB,36)
  MENUPUSH(Fnt72pt," 72pt ",menu_pane8d,FNTSCB,72)



 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Cascades */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  MakeMenuButton(menu_bar, menu_pane1, " File     ", "FileMenuButt", (char *) 'F');
  MakeMenuButton(menu_bar, menu_pane2, " Line Width ", "LineWMenuButt", (char *) 'W');
  MakeMenuButton(menu_bar, menu_pane2a," Line Style ", "LineSMenuButt", (char *) 'L');
  MakeMenuButton(menu_bar, menu_pane3, " Points    ", "PtMenuButt", (char *) 'P');
  MakeMenuButton(menu_bar, menu_pane4, " Polygon   ", "PolyMenuButt", (char *) 'G');
  MakeMenuButton(menu_bar, menu_pane5, " Options   ", "OptMenuButt", (char *) 'O');
  MakeMenuButton(menu_bar, menu_pane6, " Special   ", "OptMenuButt", (char *) 'S');
  MakeMenuButton(menu_bar, menu_pane8, " Font   ", "OptMenuButt", (char *) 'N');

  n=0;
  XtSetArg(args[n], XmNlabelString, Str2MotStr(" Help "));n++;
  XtSetArg(args[n], XmNmnemonic, 'H');n++;
  menu_pane7=XmCreateCascadeButton(menu_bar," Help ",args,n);
  XtManageChild(menu_pane7);
  XtAddCallback(menu_pane7,XmNactivateCallback,(XtCallbackProc)XmgfHelpCB,NULL);
  XtManageChild(menu_bar);

  return menu_bar;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
MakeMenuButton(Bar, Pane, Title, ResName, Mnwm)
Widget  Bar;
Widget  Pane;
char   *Title;
char   *ResName;
char   *Mnwm;
{
  Widget  Syscascade;
  Arg     args[10];
  unsigned int n=0;

  n=0;
  XtSetArg(args[n], XmNsubMenuId, Pane);n++;
  XtSetArg(args[n], XmNlabelString, Str2MotStr(Title));n++;
  XtSetArg(args[n], XmNmnemonic, Mnwm);n++;
  Syscascade = XmCreateCascadeButton(Bar, ResName, args, n);
  XtManageChild(Syscascade);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
MakeFileSelector(Parent, Title, Funct)
Widget  Parent;
char   *Title;
int     Funct;
{
  Widget  FileSel;
  Arg     args[10];
  unsigned int n=0;

  n=0;
  XtSetArg(args[n], XmNdirMask, Str2MotStr("*.gf*"));n++;
  FileSel = XmCreateFileSelectionDialog(Parent, "File Selector", args, n);
  switch (Funct) {
   case 0:{
      XtAddCallback(FileSel, XmNokCallback,
	(XtCallbackProc) DialogAcceptCB, (caddr_t) LOAD_FILE);
      XtAddCallback(FileSel, XmNcancelCallback,
	(XtCallbackProc) DialogCancelCB, (caddr_t) LOAD_FILE);
      break;
    }
   case 1:{
      XtAddCallback(FileSel, XmNokCallback,
	(XtCallbackProc) DialogAcceptCB, (caddr_t) APPEND_FILE);
      XtAddCallback(FileSel, XmNcancelCallback,
	(XtCallbackProc) DialogCancelCB, (caddr_t) APPEND_FILE);
      break;
    }
   case 2:{
      XtAddCallback(FileSel, XmNokCallback,
	(XtCallbackProc) DialogAcceptCB, (caddr_t) SAVE_FILE);
      XtAddCallback(FileSel, XmNcancelCallback,
	(XtCallbackProc) DialogCancelCB, (caddr_t) SAVE_FILE);
      break;
    }
  }
  return FileSel;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
DialogAcceptCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{

  XmFileSelectionBoxCallbackStruct *fcb
  = (XmFileSelectionBoxCallbackStruct *) call_data;

  XmStringGetLtoR(fcb->value, charset, &Selectedfilename);
  switch ((int) client_data) {
   case LOAD_FILE:{
      Load3DSets(Selectedfilename);
      XtUnmanageChild(LoadFileSel);
      LoadOpen = 0;
      break;
    }
   case APPEND_FILE:{
      Append3DSets(Selectedfilename);
      XtUnmanageChild(AppendFileSel);
      AppendOpen = 0;
      break;
    }
   case SAVE_FILE:{
      strcpy(SaveAsFilename, Selectedfilename);
      XtUnmanageChild(SaveFileSel);
      break;
    }
  }
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
DialogCancelCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{

  switch ((int) client_data) {
   case LOAD_FILE:{
      XtUnmanageChild(LoadFileSel);
      break;
    }
   case APPEND_FILE:{
      XtUnmanageChild(AppendFileSel);
      break;
    }
   case SAVE_FILE:{
      XtUnmanageChild(SaveFileSel);
      break;
    }
  }
  return 0;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
MakeLineWidthSubMenu(parent)
Widget  parent;
{
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Line Thickness Menu */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  Line0pt = CreateBitmapButt
    ((void *) LineAttrCB, (caddr_t) 0, toplevel, parent,
    Line0pt_bits, Line0pt_width, Line0pt_height);
  Line1pt = CreateBitmapButt
    ((void *) LineAttrCB, (caddr_t) 1, toplevel, parent,
    Line1pt_bits, Line1pt_width, Line1pt_height);
  Line2pt = CreateBitmapButt
    ((void *) LineAttrCB, (caddr_t) 2, toplevel, parent,
    Line2pt_bits, Line2pt_width, Line2pt_height);
  Line3pt = CreateBitmapButt
    ((void *) LineAttrCB, (caddr_t) 3, toplevel, parent,
    Line3pt_bits, Line3pt_width, Line3pt_height);
  Line4pt = CreateBitmapButt
    ((void *) LineAttrCB, (caddr_t) 4, toplevel, parent,
    Line4pt_bits, Line4pt_width, Line4pt_height);
  Line5pt = CreateBitmapButt
    ((void *) LineAttrCB, (caddr_t) 5, toplevel, parent,
    Line5pt_bits, Line5pt_width, Line5pt_height);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
MakeLineStyleSubMenu(parent)
Widget  parent;
{
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Line Style Menu */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  LineSol = CreateBitmapButt
    ((void *) LineSAttrCB, (caddr_t) 0, toplevel, parent,
    LineSol_bits, LineSol_width, LineSol_height);
  LineDot = CreateBitmapButt
    ((void *) LineSAttrCB, (caddr_t) 1, toplevel, parent,
    LineDot_bits, LineDot_width, LineDot_height);
  LineDas = CreateBitmapButt
    ((void *) LineSAttrCB, (caddr_t) 2, toplevel, parent,
    LineDas_bits, LineDas_width, LineDas_height);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
}





/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
MakePointSubMenu(parent)
Widget  parent;
{
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Point Type Seperator */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

  w_PTPoint = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_POINT,
    toplevel, parent, Point_bits, Point_width, Point_width);
  w_PTBox = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_BOX,
    toplevel, parent, Box_bits, Box_width, Box_width);
  w_PTTri = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_TRI,
    toplevel, parent, Tri_bits, Tri_width, Tri_width);
  w_PTPlus = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_PLUS,
    toplevel, parent, Plus_bits, Plus_width, Plus_width);
  w_PTCross = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_CROSS,
    toplevel, parent, Cross_bits, Cross_width, Cross_width);
  w_PTCircle = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_CIRCLE,
    toplevel, parent, Circle_bits, Cross_width, Cross_width);
  w_PTFillBox = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_FILLEDBOX,
    toplevel, parent, FillBox_bits, FillBox_width, FillBox_width);
  w_PTFillTri = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_FILLEDTRI,
    toplevel, parent, FillTri_bits, FillTri_width, FillTri_width);
  w_PTFillCircle = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_FILLEDCIRCLE, toplevel, parent, FillCircle_bits, FillCircle_width, FillCircle_width);
  w_PTFillSphere = CreateBitmapButt((void *) PointAttrCB, (caddr_t) MENU_FILLEDSPHERE,toplevel, parent, Sphere_bits, Sphere_width, Sphere_width);
}

void
MakePolygonSubMenu(parent)
Widget  parent;
{
  Arg     args[10];
  unsigned int n=0;

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Black Line Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  BlackFill = XtCreateWidget(" Black Lines",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(BlackFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) BLACKLINES);
  XtManageChild(BlackFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* White Line Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  WhiteFill = XtCreateWidget(" White Lines",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(WhiteFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) WHITELINES);
  XtManageChild(WhiteFill);

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* No Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  NoFill = XtCreateWidget(" Coloured Lines",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(NoFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) NOTFILLED);
  XtManageChild(NoFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* No Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  ShadeLines = XtCreateWidget(" Shaded Lines",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(ShadeLines, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) SHADED_LINES);
  XtManageChild(ShadeLines);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Hidden Line Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  Hide_Line = XtCreateWidget(" Hidden Line",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(Hide_Line, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) FILLEDHIDDENLINE);
  XtManageChild(Hide_Line);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Haloed Line Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  HaloedFill = XtCreateWidget(" Haloed Lines",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(HaloedFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) HALOEDLINES);
  XtManageChild(HaloedFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Opaque Fill  Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  OpaqueFill = XtCreateWidget(" Opaque Fill",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(OpaqueFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) FILLEDOPAQUE);
  XtManageChild(OpaqueFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  ColouredOpaqueFill = XtCreateWidget(" Coloured Opaque Fill",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(ColouredOpaqueFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) COLOUREDOPAQUE);
  XtManageChild(ColouredOpaqueFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  DoFill = XtCreateWidget(" Coloured Fill",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(DoFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) FILLEDCOLOR);
  XtManageChild(DoFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Shaded Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  ShFill = XtCreateWidget(" Shaded Fill",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(ShFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) SHADED_FILL);
  XtManageChild(ShFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Shaded Fill Option */
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  PointSFill = XtCreateWidget(" Points ",
    xmPushButtonWidgetClass, parent, args, n);
  XtAddCallback(PointSFill, XmNactivateCallback,
    (XtCallbackProc) PolyAttrCB, (caddr_t) POINTS_ONLY);
  XtManageChild(PointSFill);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
  n=0;
  XtSetArg(args[n], XmNindicatorOn, FALSE );n++;
  ColDither = XtCreateWidget(" Coloured Dither ",
    xmToggleButtonWidgetClass, parent, args, n);
  XtAddCallback(ColDither, XmNvalueChangedCallback,
    (XtCallbackProc) DitherCB, (caddr_t) 0);
  XtManageChild(ColDither);
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateAboutPanel()
{
  Arg     args[10];
  Widget  Text_Label, CPRC, AboutPanel, DismissButton;
  Widget  AboutShell;
  unsigned int n=0;
  
  if (AboutShellDia) {XRaiseWindow(theDisplay,XtWindow(AboutShellDia)); return ; }
  AboutShellDia = XmCreateDialogShell(toplevel, "Shell", args, 0);
  AboutShell = XmCreateBulletinBoard(AboutShellDia, "Shell", args, 0);

  n=0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL);n++;
  XtSetArg(args[n], XmNnumColumns, 3);n++;
  XtSetArg(args[n], XmNpacking, XmPACK_TIGHT);n++;
  CPRC = XmCreateRowColumn(AboutShell, "workarea", args, n);
  XtManageChild(CPRC);

  n=0;
  XtSetArg(args[n], XmNlabelString, Str2MotStr("All About Xmgf"));n++;
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, n);
  XtManageChild(Text_Label);

  AboutPanel = CreateBitmapLabel(toplevel, CPRC, About_bits, About_width,
    About_height);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  DismissButton = XtCreateManagedWidget("Dismiss", xmPushButtonWidgetClass, CPRC, args,1);
  XtAddCallback(DismissButton, XmNactivateCallback,
    (XtCallbackProc) KillAboutCB, (caddr_t) NULL);

  XtManageChild(AboutShell);
  XtManageChild(AboutShellDia);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillAboutCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(AboutShellDia);
  XtDestroyWidget(AboutShellDia);
  AboutShellDia=NULL;
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreatePrintPanel()
{
  Arg     args[10];
  Widget  Text_Label, CPRC;
  Widget  OrientRC, PortraitBB;
  Widget  PrintShell, PrintNameSel;
  unsigned int n=0;

  if (PrintShellDia) {XRaiseWindow(theDisplay,XtWindow(PrintShellDia)); return ; }
  PrintShellDia = XmCreateDialogShell(toplevel, "Shell", args, 0);
  PrintShell = XmCreateBulletinBoard(PrintShellDia, "Shell", args, 0);

  n=0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL);n++;
  XtSetArg(args[n], XmNnumColumns, 3);n++;
  XtSetArg(args[n], XmNpacking, XmPACK_TIGHT);n++;
  CPRC = XmCreateRowColumn(PrintShell, "workarea", args, n);
  XtManageChild(CPRC);

  n=0;
  XtSetArg(args[0], XmNlabelString, Str2MotStr(" Print "));n++;
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, n);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNentryClass, xmToggleButtonWidgetClass);
  XtSetArg(args[1], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[2], XmNnumColumns, 3);
  XtSetArg(args[3], XmNpacking, XmPACK_TIGHT);
  OrientRC = XmCreateRadioBox(CPRC, "OrientRC", args, 4);
  XtManageChild(OrientRC);

  LandScapeBB = XtCreateManagedWidget(" LandScape ",
    xmToggleButtonWidgetClass, OrientRC, args, 0);
  PortraitBB = XtCreateManagedWidget(" Portrait ",
    xmToggleButtonWidgetClass, OrientRC, args, 0);


  XmToggleButtonSetState(LandScapeBB,(PSOrientation), FALSE);
  XmToggleButtonSetState(PortraitBB, (!PSOrientation), FALSE);


  PrintColourBB = XtCreateManagedWidget(" Colour ",
    xmToggleButtonWidgetClass, CPRC, args, 0);

  XmToggleButtonSetState(PrintColourBB, PSColour, FALSE);

  XtSetArg(args[0], XmNselectionLabelString,
    Str2MotStr("Print Command:-"));
  XtSetArg(args[1], XmNdialogType, XmDIALOG_PROMPT);
  XtSetArg(args[2], XmNtextString,
    Str2MotStr(appres.PrinterName));
  PrintNameSel = XtCreateManagedWidget(" PrinterName ",
    xmSelectionBoxWidgetClass, CPRC, args, 3);
  XtAddCallback(PrintNameSel, XmNokCallback,
    (XtCallbackProc) PrintXmgfCB, (caddr_t) NULL);
  XtAddCallback(PrintNameSel, XmNcancelCallback,
    (XtCallbackProc) KillPrintCB, (caddr_t) NULL);
  XtAddCallback(PrintNameSel, XmNhelpCallback,
    (XtCallbackProc) XmgfHelpCB, (caddr_t)HELP_PRINT );

  XtManageChild(PrintShell);
  XtManageChild(PrintShellDia);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PrintXmgfCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  char   *PrintSystemString;
  char    AppdefPrintName[100];
  XmSelectionBoxCallbackStruct *scb =
  (XmSelectionBoxCallbackStruct *) call_data;

  PrintSystemString = (char *) XmgfMalloc(200 * sizeof(char));
  assert(PrintSystemString);

  PSOrientation = (XmToggleButtonGetState(LandScapeBB) ? 1 : 0);
  PSColour = (XmToggleButtonGetState(PrintColourBB) ? 1 : 0);

  strcpy(AppdefPrintName, appres.PrinterName);


  XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &PrintSystemString);
  if (!strcasecmp(PrintSystemString, "")) {
    strcpy(PrintSystemString, AppdefPrintName);
  }
  if (strlen(PrintSystemString) <= 0) {
    strcpy(PrintSystemString, AppdefPrintName);
  }
  PrintImage(PrintSystemString, PSOrientation, PSColour);
  XtUnmanageChild(PrintShellDia);
  XtDestroyWidget(PrintShellDia);
  PrintShellDia=NULL;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillPrintCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(PrintShellDia);
  XtDestroyWidget(PrintShellDia);
  PrintShellDia=NULL;
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetToggles()
{
  XmToggleButtonSetState(SelColor, SelectColours, FALSE);
  XmToggleButtonSetState(SortPolyButt, Sorting, FALSE);
  XmToggleButtonSetState(BackCull, BackFace, FALSE);
  XmToggleButtonSetState(DrawAxisLabel, AxisLabel, FALSE);
  XmToggleButtonSetState(SelLabels, SelectLabels, FALSE);
  XmToggleButtonSetState(AutoSTButt, ScaleObectType, TRUE);
  XmToggleButtonSetState(FixateTButt, FixateType, TRUE);
  XmToggleButtonSetState(Rotate_Button, AutoRotateFlag, FALSE);
  XmToggleButtonSetState(Set2DButt, TwoDimSettings, FALSE);
  SetIconToggles();

  return;
}

#include "ICONS/IconLoad.xbm"
#include "ICONS/IconAppend.xbm"
#include "ICONS/IconReLoad.xbm"
#include "ICONS/IconAxis.xbm"
#include "ICONS/IconPrinter.xbm"
#include "ICONS/Icon2D.xbm"
#include "ICONS/IconAutoR.xbm"
#include "ICONS/IconImage.xbm"
#include "ICONS/IconPtSize.xbm"
#include "ICONS/IconAutoSc.xbm"
#include "ICONS/IconAxisSize.xbm"
#include "ICONS/IconCentre.xbm"
#include "ICONS/IconDouble.xbm"
#include "ICONS/IconDepth.xbm"
#include "ICONS/IconBackFace.xbm"
#include "ICONS/IconOrth.xbm"
#include "ICONS/IconRotateG.xbm"
#include "ICONS/IconExpand.xbm"
#include "ICONS/Icon3D.xbm"
#include "ICONS/IconControl.xbm"
#include "ICONS/IconLabel.xbm"
#include "ICONS/IconSort.xbm"
#include "ICONS/IconPersp.xbm"
#include "ICONS/IconFirstAn.xbm"
#include "ICONS/IconStereo.xbm"
#include "ICONS/IconAutoROp.xbm"
#include "ICONS/IconColMap.xbm"
#include "ICONS/IconGreyMap.xbm"
#include "ICONS/IconErase.xbm"
#include "ICONS/IconDraw.xbm"
#include "ICONS/IconQuit.xbm"
#include "ICONS/IconLine.xbm"
#include "ICONS/IconPoint.xbm"
#include "ICONS/IconPolygon.xbm"
#include "ICONS/IconLoadParm.xbm"
#include "ICONS/IconSaveParm.xbm"
#include "ICONS/IconDefBack.xbm"
#include "ICONS/IconColBack.xbm"
#include "ICONS/IconFilm.xbm"
#include "ICONS/IconOLine.xbm"
#include "ICONS/IconOLineCol.xbm"
#include "ICONS/IconDither.xbm"

#ifndef OLDICONS
#include "ICONS/IconZoom.xbm"
#include "ICONS/IconNear.xbm"
#include "ICONS/IconFar.xbm"
#else
#include "ICONS/OIconZoom.xbm"
#include "ICONS/OIconNear.xbm"
#include "ICONS/OIconFar.xbm"
#endif

static t_IconInfo Icons[ICONNUMBER] = {
{IconLoad_bits,     (void *)LoadCB, PSH, NOPARM, "Load a GF Set"},
{IconAppend_bits, (void *)AppendCB, PSH, NOPARM, "Append a GF Set"},
{IconReLoad_bits, (void *)ReReadCB, PSH, NOPARM, "Reload Current File"},
{IconLoadParm_bits, (void *)LoadParm, PSH, NOPARM, "Load Parm"},
{IconSaveParm_bits, (void *)SaveParm, PSH, NOPARM, "Save Parm"},
{IconColMap_bits,   (void *)LoadCMapCB, PSH, NOPARM, "Load Colour Map"},
{IconGreyMap_bits, (void *)LoadGMapCB, PSH, NOPARM, "Load Grey Map"},
{IconPrinter_bits, (void *)PrintCB, PSH, NOPARM, "Print"},
{IconDraw_bits,       (void *)ReDrawCB, PSH, NOPARM, "ReDraw"},
{Icon2D_bits, (void *)Set2DCB, TOG, NOPARM, "2D Settings"},
{IconAutoSc_bits, (void *)AutoScaleCB, PSH, NOPARM, "AutoScale"},
{IconCentre_bits, (void *)AutoScaleVisibleCB, PSH, NOPARM, "Centre"},
{IconZoom_bits, (void *)ZoomCB, PSH, NOPARM, "Zoom"},
{IconOrth_bits, (void *)OrthoGraphicCB, TOG, NOPARM, "Orthographic"},
{IconImage_bits,(void *)BackGrdCB,PSH,BACK_GRD_IMG,"Image in Background"},
{IconDefBack_bits,(void *)BackGrdCB,PSH,DEF_GRD_IMG,"Default Background"},
{IconColBack_bits, (void *)BackGrdCB, PSH, BACK_GRD_COL, "Coloured Background"},
{IconExpand_bits, (void *)SelExpandCB, TOG, NOPARM, "Expand Image"},
{IconAxis_bits, (void *)AxisLABCB, TOG, NOPARM, "Axis"},
{IconAxisSize_bits, (void *)CreateAxisSizePalCB, PSH, NOPARM, "Axis Size"},
{IconDouble_bits, (void *)DoubleBCB, TOG, NOPARM, "Double Buffer"},
{IconSort_bits, (void *)SortCB, TOG, NOPARM, "Sort Polygons"},
{IconRotateG_bits, (void *)RotateBBCB, TOG, NOPARM, "Rotation Guide"},
{IconLabel_bits, (void *)SelLabelsCB, TOG, NOPARM, "Labels"},
{IconAutoR_bits, (void *)AutoRotate, TOG, NOPARM, "AutoRotate"},
{IconAutoROp_bits, (void *)CreateARSizePalCB, PSH, NOPARM, "AutoRotate Options"},
{IconFilm_bits, (void *)AnimationCB, PSH, NOPARM, "Animation "},
{IconLine_bits, (void *)CreateLinePanel, PSH, NOPARM, "Line Type"},
{IconPoint_bits, (void *)CreatePointPanel, PSH, NOPARM, "Point Type"},
{IconPtSize_bits, (void *)CreatePtSizePalCB, PSH, NOPARM, "Point Size"},
{IconPolygon_bits, (void *)CreatePolygonPanel, PSH, NOPARM, "Polygon Style"},
{IconOLine_bits, (void *)OutLineCB, TOG, NOPARM, "OutLine"},
{IconOLineCol_bits, (void *)OutLineColCB, PSH, NOPARM, "OutLine Colour Selection"},
{IconDither_bits, (void *)DitherCB, TOG, NOPARM, "Dithering "},
{IconDepth_bits, (void *)DepthCueCB, TOG, NOPARM, "Depth Cueing"},
{IconBackFace_bits, (void *)BackFaceCB, TOG, NOPARM, "Backface Culling"},
{Icon3D_bits, (void *)ConButtCB, PSH, NOPARM, "3D Control Panel"},
{IconControl_bits, (void *)SetCButtCB, PSH, NOPARM, "Set Control Panel"},
{IconPersp_bits, (void *)ChangeView, PSH, VIEW_PERS, "Perspective View"},
{IconStereo_bits, (void *)ChangeView, PSH, VIEW_STEREO, "Stereo View"},
{IconFirstAn_bits, (void *)ChangeView, PSH, VIEW_ORTH, "First-Angle-Projection View"},
{IconNear_bits, (void *)FarCB, PSH, NOPARM, " Zoom In"},
{IconFar_bits, (void *)NearCB, PSH, NOPARM, " Zoom Out"},
{IconErase_bits, (void *)Empty3DSets, PSH, NOPARM, "Clear All"},
{IconQuit_bits, (void *)QuitCB, PSH, NOPARM, "Quit"}
};

Widget
MakeIconPanel(Parent, Arrangement,IconArr,fargs,fnum)
Widget  Parent;
int     Arrangement;
Widget *IconArr;
Arg	*fargs;
int      fnum;
{
  int     Widths[ICONNUMBER];
  int     Height[ICONNUMBER];
  Arg     args[10];
  Widget  IconFrame;

 /* Shape of RowCol */
 /* 4x9 18x2 6x6 12x3 */
  int     Dim = ICONNUMBER;
  int     DimX = 4;
  int     DimY = Dim / DimX;
  int     i;

  switch (Arrangement) {
   case 1: DimX = 1; break;
   case 2: DimX = 2; break;
   case 3: DimX = 3; break;
   case 4: DimX = 4; break;
   case 6: DimX = 6; break;
   case 9: DimX = 9; break;
   case 12: DimX = 12; break;
   case 18: DimX = 18; break;
   case 36: DimX = 36; break;
   default: DimX = 4; break;
  }

  IconFrame = XtCreateManagedWidget("IconFramE", xmFrameWidgetClass, Parent, fargs, fnum);

  DimY = Dim / DimX;

  if (((int) DimY * (int) DimX) < Dim) DimY++;

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNnumColumns, DimY);
  XtSetArg(args[2], XmNpacking, XmPACK_COLUMN);
  XtSetArg(args[3], XmNspacing, 0);
  XtSetArg(args[4], XmNadjustLast, False);
  IconRowCol = XmCreateRowColumn(IconFrame, "IconRowCol", args, 5);
  XtManageChild(IconRowCol);

  for (i = 0; i < Dim; i++) {
    Widths[i] = IconLoad_width;
    Height[i] = IconLoad_height;
    IconArr[i] = CreateIconButt(
      (void *) Icons[i].Funct, (caddr_t) Icons[i].Parm, toplevel, IconRowCol,
      Icons[i].Bits, Widths[i], Height[i], (int) Icons[i].ButtType);
    XtAddEventHandler(IconArr[i], EnterWindowMask, False,
      MouseMessages, (XtPointer) Icons[i].MouseMess);
  }
  return IconFrame;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
MouseMessages(widget, closure, event, done)
Widget  widget;
XtPointer closure;
XEvent *event;
Boolean *done;
{
  char   *MessString;

  MessString = (char *) closure;
  XmgfMessage(MessString);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateLinePanel(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, DismissButton;
  Widget  LineShell;

  if (LineShellDia) {XRaiseWindow(theDisplay,XtWindow(LineShellDia)); return ; }
  LineShellDia = XmCreateDialogShell(toplevel, "Shell", args, 0);
  LineShell = XmCreateBulletinBoard(LineShellDia, "Shell", args, 0);
  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 1);
  XtSetArg(args[2], XmNpacking, XmPACK_COLUMN);
  XtSetArg(args[3], XmNisAligned, True);
  XtSetArg(args[4], XmNentryAlignment, XmALIGNMENT_CENTER);
  CPRC = XmCreateRowColumn(LineShell, "workarea", args, 5);
  XtManageChild(CPRC);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(" Line Style"));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);
  MakeLineWidthSubMenu(CPRC);
  MakeLineStyleSubMenu(CPRC);
  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  DismissButton = XtCreateManagedWidget("Dismiss", xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(DismissButton, XmNactivateCallback,
    (XtCallbackProc) KillLineCB, (caddr_t) NULL);
  XtManageChild(LineShell);
  XtManageChild(LineShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreatePointPanel(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, DismissButton;
  Widget  PointShell;

  if (PointShellDia) {XRaiseWindow(theDisplay,XtWindow(PointShellDia)); return ; }
  PointShellDia = XmCreateDialogShell(toplevel, "Shell", args, 0);
  PointShell = XmCreateBulletinBoard(PointShellDia, "Shell", args, 0);
  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 1);
  XtSetArg(args[2], XmNpacking, XmPACK_COLUMN);
  XtSetArg(args[3], XmNisAligned, True);
  XtSetArg(args[4], XmNentryAlignment, XmALIGNMENT_CENTER);
  CPRC = XmCreateRowColumn(PointShell, "workarea", args, 5);
  XtManageChild(CPRC);
  XtSetArg(args[0], XmNlabelString, Str2MotStr("Point Style"));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);
  MakePointSubMenu(CPRC);
  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  DismissButton = XtCreateManagedWidget("Dismiss", xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(DismissButton, XmNactivateCallback,
    (XtCallbackProc) KillPointCB, (caddr_t) NULL);
  XtManageChild(PointShell);
  XtManageChild(PointShellDia);
}




/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreatePolygonPanel(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, DismissButton;
  Widget  PolygonShell;

  if (PolygonShellDia){XRaiseWindow(theDisplay,XtWindow(PolygonShellDia));return; }
  PolygonShellDia = XmCreateDialogShell(toplevel, "Shell", args, 0);
  PolygonShell = XmCreateBulletinBoard(PolygonShellDia, "Shell", args, 0);
  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[3], XmNisAligned, True);
  XtSetArg(args[4], XmNentryAlignment, XmALIGNMENT_CENTER);
  CPRC = XmCreateRowColumn(PolygonShell, "workarea", args, 5);
  XtManageChild(CPRC);
  XtSetArg(args[0], XmNlabelString, Str2MotStr("Fill Style"));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);
  MakePolygonSubMenu(CPRC);
  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  DismissButton = XtCreateManagedWidget("Dismiss", xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(DismissButton, XmNactivateCallback,
    (XtCallbackProc) KillPolygonCB, (caddr_t) NULL);
  XtManageChild(PolygonShell);
  XtManageChild(PolygonShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillLineCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(LineShellDia);
  XtDestroyWidget(LineShellDia);
  LineShellDia=NULL;
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillPointCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(PointShellDia);
  XtDestroyWidget(PointShellDia);
  PointShellDia=NULL;
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillPolygonCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(PolygonShellDia);
  XtDestroyWidget(PolygonShellDia);
  PolygonShellDia=NULL;
  return;
}

void
MakeSeper(parent)
Widget parent;
{
  Arg args[2];
  Widget Sep;

  XtSetArg(args[0], XmNheight, 8);
  Sep = XmCreateSeparator(parent, "CommonSep", args, 1);
  XtManageChild(Sep);
}

void
SetIconToggles()
{
if (ICONPANEL){
   /* Set The toggle buttons to represent the state */
   XmToggleButtonSetState(ArrIconPanel[ICON2D],TwoDimSettings,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICON2D],TwoDimSettings,FALSE);

   XmToggleButtonSetState(ArrIconPanel[ICONORTH],OrthoGraphicProj,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONORTH],OrthoGraphicProj,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONEXPAND],ExpandImage,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONEXPAND],ExpandImage,FALSE);

   XmToggleButtonSetState(ArrIconPanel[ICONAXIS],Axis,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONAXIS],Axis,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONDOUBLE],DoubleBuff,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONDOUBLE],DoubleBuff,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONSORT],Sorting,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONSORT],Sorting,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONROTGUIDE],RotateGuide,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONROTGUIDE],RotateGuide,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONLABEL],SelectLabels,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONLABEL],SelectLabels,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONAROT],AutoRotateFlag,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONAROT],AutoRotateFlag,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONOUTLINE],OutLine,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONOUTLINE],OutLine,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONDITHER],DitherFill,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONDITHER],DitherFill,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONDPTHCUE],DepthCueing,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONDPTHCUE],DepthCueing,FALSE);
   
   XmToggleButtonSetState(ArrIconPanel[ICONBACKFACE],BackFace,FALSE);
   XmToggleButtonSetState(ArrIconCanvas[ICONBACKFACE],BackFace,FALSE);

   XmToggleButtonSetState(Rotate_Button,AutoRotateFlag,FALSE);
   XmToggleButtonSetState(BackCull,BackFace,FALSE);
   XmToggleButtonSetState(DrawAxisLabel,Axis,FALSE);
   XmToggleButtonSetState(DoubleBuffer,DoubleBuff,FALSE);
   XmToggleButtonSetState(OutLineBu,OutLine,FALSE);
   XmToggleButtonSetState(ColDither,DitherFill,FALSE);
   XmToggleButtonSetState(DrawAxisLabel,Axis,FALSE);
   XmToggleButtonSetState(RotBB,RotateGuide,FALSE);
   XmToggleButtonSetState(SelLabels,SelectLabels,FALSE);
   XmToggleButtonSetState(OrthOPro,OrthoGraphicProj,FALSE);
   XmToggleButtonSetState(SelExpand,ExpandImage,FALSE);
   XmToggleButtonSetState(SortPolyButt,Sorting,FALSE);
   XmToggleButtonSetState(Set2DButt,TwoDimSettings,FALSE);
}

}
