static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include <X11/StringDefs.h>
#include "RayShade.h"
#include "Pixmaps.h"
#include "3Droutines.h"
#include "callbacks.h"

int             OutRay;
FILE           *RAYFilePtr;

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveRAYCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Saving RayShade File", SAVE_RAY_FILE, RAYFIL, "Out.ray", RAYDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputRAY(fname)
char *fname;
{
	OutRay = 1;
	if ((RAYFilePtr = fopen(fname, "w")) == NULL)
		return ;
	else if (OutRay == 1)
		InitRayShade();
	REDRAW_SCREEN;
	if (OutRay == 1)
		EndRayShade();
	fclose(RAYFilePtr);
	OutRay = 0;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PolygonRAY(Pts, num, fill, TmpWind, Color)
t_XmgfPt *Pts;
int num;
int fill;
Window TmpWind;
int Color;
{
	int i;
	double ImageX, ImageY, ImageZ;

	if (fill == 1 && num <= 2)
		fill = 0;
	if (num == 1 && PointType == 0)
		fill = DOT;
	if (num == 1 && PointType == 1)
		fill = PLUS;
	if (num == 1 && PointType == 2)
		fill = BOX;
	if (num == 1 && PointType == 3)
		fill = TRI;
	switch (fill) {
	    case DOT:{
			break;
		}
	    case PLUS:{
			break;
		}
	    case BOX:{
			break;
		}
	    case TRI:{
			break;
		}
	    default:{
			fprintf(RAYFilePtr, "poly\n");
			for (i = 0; i < num; i++) {
				ImageX = (Pts[i].x + Ox);
				ImageY = (Pts[i].y + Oy);
				ImageZ = (Pts[i].z + Oz);
				fprintf(RAYFilePtr, "%f %f %f\n", ImageX, ImageZ, ImageY);
			}
			break;
		}
	}

	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitRayShade()
{
	double EyeX, EyeY, EyeZ;
	double d, x2, y2, R1, GammaA, GammaB;
	double RayDist;
	double MaxEye;
	double LightX, LightY, LightZ;

	/* ViewPoint Determination */
	fprintf(stderr, "ScaleFactor =%f\n", Scale_factor);
	RayDist = DistSC / 2;

	d = RayDist * cos(Deg2Rad((double) Theta));
	y2 = RayDist * sin(Deg2Rad((double) Theta));
	x2 = d * sin(Deg2Rad((double) Phi));
	EyeZ = -d * cos(Deg2Rad((double) Phi));

	if (y2 != 0 || x2 != 0) {
		GammaA = atan2(y2, x2);
		GammaB = GammaA - Deg2Rad((double) Gamma);
		R1 = y2 / (sin(GammaA));
		EyeX = -R1 * cos(GammaB);
		EyeY = -R1 * sin(GammaB);
	} else {
		EyeX = 0;
		EyeY = 0;
	}

	MaxEye = max(fabs(EyeX), max(fabs(EyeY), fabs(EyeZ)));
	LightX = sgn(EyeX) * MaxEye;
	LightY = sgn(EyeY) * MaxEye;
	LightZ = sgn(EyeZ) * MaxEye;

	NEWTHREEDTWOD(0, 0, DistSC);
	EyeX = -ax;
	EyeY = -ay;
	EyeZ = DistSC - az;


	fprintf(stderr, "%f %f %f\n", EyeX, EyeZ, EyeY);
	fprintf(RAYFilePtr, "screen 256 256\n");
	fprintf(RAYFilePtr, "maxdepth 4\n");
	fprintf(RAYFilePtr, "background 0.48 0.36 0.05\n");
	fprintf(RAYFilePtr, "light 1 point %f %f %f\n", LightX, LightZ, LightY);
	fprintf(RAYFilePtr, "lookp 0 0 0\n");
	fprintf(RAYFilePtr, "up 0 -1 0\n");
/*	fprintf(RAYFilePtr, "fov 80\n");*/
	fprintf(RAYFilePtr, "fov 800\n");

	MakeLookPt();
/*	fprintf(RAYFilePtr, "eyep %f %f %f\n", EyeX, EyeZ, EyeY);*/
/*	fprintf(RAYFilePtr, "eyep %f %f %f\n", ax, -az, ay);*/
	fprintf(RAYFilePtr, "eyep %f %f %f\n", ax, ay, -az);
	return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
EndRayShade()
{
	fprintf(RAYFilePtr, " ");
	return ;
}
