static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <assert.h>

#include "XmgfMalloc.h"

#include "XmgfStruct.h"
#include "LL.h"
#include "SortPoly.h"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Polygon Compare function used in Sort Polygon only          */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
#ifdef HPUX_SORT
PolygonCriterion(cv_el1, cv_el2)
const void *cv_el1, *cv_el2;
#else
PolygonCriterion(el1, el2)
t_XmgfPoly *el1;
t_XmgfPoly *el2;
#endif
{
#ifdef HPUX_SORT
	t_XmgfPoly *el1, *el2;
	el1 = (t_XmgfPoly *)cv_el1;
	el2 = (t_XmgfPoly *)cv_el2;
#endif


	if (el1->z_depth == el2->z_depth) return 0;
	return (el1->z_depth > el2->z_depth) ? -1 : 1;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Sort a List of Polygons by depth                            */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SortPolygons(List)
t_LL *List;
{
	int Size, i;
	t_XmgfPoly *el;
	t_XmgfPoly *array;
	static int XmgfPolySize = sizeof(t_XmgfPoly);

	Size = SizeLL(*List);
	if (Size!=0){
	array = (t_XmgfPoly *) XmgfMalloc(Size * XmgfPolySize);
	assert(array);
	i = 0;
	ForeachLL_M(*List, el) {
		array[i++] = *el;
	}
	qsort(array, Size, XmgfPolySize, PolygonCriterion);
	i = 0;
	ForeachLL_M(*List, el) {
		*el = array[i++];
	}
	XmgfFree(array);
	}
	return ;
}
