static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
/*
 * Jon Leech 3/24/89
 */
#include <stdio.h>
#include <math.h>
#include <assert.h>

#include "XmgfMalloc.h"

#include "XmgfStruct.h"
#include "XmgfDefines.h"
#include "Parse.h"
#include "Read3DSet.h"

typedef struct {
	t_XmgfPt pt[3];		/* Vertices of triangle */
	double area;		/* Unused; might be used for adaptive
				   subdivision */
} t_XmgfTriangle;

typedef struct {
	int npoly;		/* # of polygons in object */
	t_XmgfTriangle *poly;	/* Polygons in no particular order */
} object;

/* Six equidistant points lying on the unit sphere */
#define XPLUS {  1,  0,  0 }	/* X */
#define XMIN  { -1,  0,  0 }	/* -X */
#define YPLUS {  0,  1,  0 }	/* Y */
#define YMIN  {  0, -1,  0 }	/* -Y */
#define ZPLUS {  0,  0,  1 }	/* Z */
#define ZMIN  {  0,  0, -1 }	/* -Z */

/* Vertices of a unit octahedron */
t_XmgfTriangle octahedron[] = {
	{{XPLUS, ZPLUS, YPLUS}, 0.0},
	{{YPLUS, ZPLUS, XMIN}, 0.0},
	{{XMIN, ZPLUS, YMIN}, 0.0},
	{{YMIN, ZPLUS, XPLUS}, 0.0},
	{{XPLUS, YPLUS, ZMIN}, 0.0},
	{{YPLUS, XMIN, ZMIN}, 0.0},
	{{XMIN, YMIN, ZMIN}, 0.0},
	{{YMIN, XPLUS, ZMIN}, 0.0}
};

/* An octahedron */
object oct = {
	sizeof(octahedron) / sizeof(octahedron[0]),
	&octahedron[0]
};

/* Forward declarations */
#ifndef _NO_PROTO
t_XmgfPt *normalize(t_XmgfPt *p );
t_XmgfPt *midpoint( t_XmgfPt *a, t_XmgfPt *b );
t_LL print_object(double xcen,double ycen,double zcen,double radius,object * obj,int level);
double sqr(double x );


#else
t_XmgfPt *normalize();
t_XmgfPt *midpoint();
t_LL print_object();
double sqr();

#endif

t_LL
MakeSphere(xcen, ycen, zcen, radius, TessLevel)
double xcen;
double ycen;
double zcen;
double radius;
int TessLevel;
{
	object *old, *new;
	int i, level, maxlevels;
	t_LL PolyList;


	maxlevels = DefaultTessLevel;

	old = &oct;

	for (level = 1; level < maxlevels; level++) {
		new = (object *) XmgfMalloc(sizeof(object));
		assert(new);
		new->npoly = old->npoly * 4;

		new->poly = (t_XmgfTriangle *) XmgfMalloc(new->npoly * sizeof(t_XmgfTriangle));
		assert(new->poly);
		if (new->poly == NULL) {
			fprintf(stderr, "Out of memory \n");
			return NULL;
		}
		for (i = 0; i < old->npoly; i++) {
			t_XmgfTriangle
				* oldt = &old->poly[i],
				*newt = &new->poly[i * 4];
			t_XmgfPt a, b, c;

			a = *normalize(midpoint(&oldt->pt[0], &oldt->pt[2]));
			b = *normalize(midpoint(&oldt->pt[0], &oldt->pt[1]));
			c = *normalize(midpoint(&oldt->pt[1], &oldt->pt[2]));
			newt->pt[0] = oldt->pt[0];
			newt->pt[1] = b;
			newt->pt[2] = a;
			newt++;
			newt->pt[0] = b;
			newt->pt[1] = oldt->pt[1];
			newt->pt[2] = c;
			newt++;
			newt->pt[0] = a;
			newt->pt[1] = b;
			newt->pt[2] = c;
			newt++;
			newt->pt[0] = a;
			newt->pt[1] = c;
			newt->pt[2] = oldt->pt[2];

		}

		if (level > 1) {
			free(old->poly);
			free(old);
		}
		old = new;
	}
	PolyList = print_object(xcen, ycen, zcen, radius, old, maxlevels);
	return PolyList;
}

/* Normalize a point p */
t_XmgfPt *
normalize(p)
t_XmgfPt *p;
{
	static t_XmgfPt r;
	double mag;

	r = *p;
	mag = r.x * r.x + r.y * r.y + r.z * r.z;
	if (mag != 0.0) {
		mag = 1.0 / sqrt(mag);
		r.x *= mag;
		r.y *= mag;
		r.z *= mag;
	}
	return &r;
}

/* Return the average of two points */
t_XmgfPt *
midpoint(a, b)
t_XmgfPt *a, *b;
{
	static t_XmgfPt r;

	r.x = (a->x + b->x) * 0.5;
	r.y = (a->y + b->y) * 0.5;
	r.z = (a->z + b->z) * 0.5;

	return &r;
}

/* Write out all polygons in an object */
t_LL
print_object(xcen, ycen, zcen, radius, obj, level)
	double xcen;
	double ycen;
	double zcen;
	double radius;
	object *obj;
	int level;
{
	int i, j;
	t_XmgfPoly Poly;
	t_XmgfPt Point;
	int Col;

	t_LL PolyList = ConsLL();

	/* Spit out coordinates for each triangle */

	for (i = 0; i < obj->npoly; i++) {
		Col = NOCOLOR;
		Poly.ListXmgfPts = ConsLL();
		Poly.ColNum = NOCOLOR;
		Poly.fill = NOFILL;
		Poly.cull = 0;
		Poly.LineStyle = DefaultLineStyle;
		Poly.LineWidth = DefaultLineWidth;
		Poly.num = 3;
		Poly.ListXmgfPts = ConsLL();
		for (j = 0; j < 3; j++) {
			Point.x = (double) xcen + (radius * obj->poly[i].pt[j].x);
			Point.y = (double) ycen + (radius * obj->poly[i].pt[j].y);
			Point.z = (double) zcen + (radius * obj->poly[i].pt[j].z);
			InsLastLL(Poly.ListXmgfPts, Point);
			InsLastLL(PolyList, Poly);
		}
	}
	return PolyList;
}

double
sqr(x)
double x;
{
	return x * x;
}
