static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include <X11/StringDefs.h>
#include <Xm/Scale.h>
#include "PICT.h"
#include "Pixmaps.h"
#include "3Droutines.h"
#include "Parse.h"

FILE           *PICTFilePtr;
int 		OutPICT;
float 		FmSc=100;

#define GROUPID 	1

#ifndef _NO_PROTO 
void MakeOutLinePICT(XPoint *Pts,int num,int LineWidth);
int SetPICTColour(int Color);
#else 
void MakeOutLinePICT();
int SetPICTColour();
#endif 



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SavePICT(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Saving .PICT  File", SAVE_PICT_FILE, PICTFIL, "Out.pict", PICTDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputPICT(fname, Col)
char *fname;
int Col;
{
	OutPICT=1;
	if ((PICTFilePtr = fopen(fname, "w")) == NULL)
		return ;
	else if (OutPICT == 1)
		InitPICT();
	REDRAW_SCREEN;
	if (OutPICT == 1)
		EndPICT();
	fclose(PICTFilePtr);
	OutPICT = 0;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PolygonPICT(Pts, num, fill, TmpWind, Color, PtType, BaseType, LineStyle, LineWidth, FillStyle,ShadedVal)
XPoint *Pts;
int num;
int fill;
Window TmpWind;
int Color;
int PtType;
int BaseType;
int LineStyle;
int LineWidth;
int FillStyle;
int ShadedVal;
{
	int i;
	int PICTColour = -1;
	int P = DefaultPointSize;
	int PICTFill = 0;

	PICTColour = SetPICTColour(Color);
	fill =  DetermineFillType(fill,num,PtType,FillStyle,BaseType);

	if (Color < 64) {
                PICTColour = 0;
                PICTFill = (int) (((double) Color / 64.0) * 7.0);
        }
	else {
		PICTFill = 0;
	}


	switch (fill) {
	    case DOT:{
		/* Pts[0].x Pts[0].y hold data */
		/* Print using fprintf(PICTFilePtr, ""); */
		/* Pointsize is in P */
		/* num = Number of verticies */
                break;
		}
	    case PLUS:{
                break;
		}
	    case CROSS:{
                break;
		}
	    case BOX:{
                break;
		}
	    case TRI:{
                break;
		}
	    case FILLEDTRI:{
                break;
		}
	    case FILLEDBOX:{
                break;
		}
	    case PTCIRCLE:{
		break;
		}
	    case FILLEDCIRCLE:{
		break;
		}
	    case FILLEDOPAQUE:{/* Polygon and PolyLine */
		break;
		}
	    case COLOUREDOPAQUE:{/* Polygon and PolyLine */
		break;
	    }
	    case FILLEDHIDDENLINE:{
		if(DitherFill){
		PICTFill = (int) (((double) ShadedVal / 64.0) * 7.0);
		}
		MakeOutLinePICT(Pts,num,LineWidth);
		break;
		}
	    case WHITELINES:{
		PICTColour = 1;
		if (num>2) {fprintf(PICTFilePtr, "<Polygon\n");
		}
		else {fprintf(PICTFilePtr, "<PolyLine\n");
		}
		break;
                }
            case BLACKLINES:{
		PICTColour = 0;
		if (num>2) {fprintf(PICTFilePtr, "<Polygon\n");
		}
		else {fprintf(PICTFilePtr, "<PolyLine\n");
		}
		break;
                }
	    case COLOUREDLINES:
	    case FILLEDCOLOR:{	/* Polygon */
		if(DitherFill){
		PICTFill = (int) (((double) ShadedVal / 64.0) * 7.0);
		}
		MakeOutLinePICT(Pts,num,LineWidth);
		break;
		}
	    case POINTS_ONLY:{
                break;
		}
	    case TEXTLABEL:{  
		/* PICTColour = Colour */
		/* CurrentString = Text String */
		break;
        }
	    default:{		/* PolyLine */
		break;
		}
	}
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitPICT()
{
	fprintf(PICTFilePtr, "FormayID for PICT\n");
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
EndPICT()
{
	fprintf(PICTFilePtr, "\n");
	return ;
}

void
MakeOutLinePICT(Pts,num,LineWidth)
XPoint *Pts;
int num;
int LineWidth;
{
    int PICTColour = -1;
    int PICTFill;
    int i;

    if(OutLine){
    PICTColour =SetPICTColour(OutLineColour);
    PICTFill = 0;
	/* Draw an outline */
    }

}

int SetPICTColour(Color)
int Color;
{
        int PICTColour = -1;

        switch (Color) {
            case 64:
                PICTColour = 0; /* Black */
                break;
            case 70:
                PICTColour = 1; /* White */
                break;
            case 65:
                PICTColour = 2; /* Red */
                break;
            case 69:
                PICTColour = 3; /* Green */
                break;
            case 66:
                PICTColour = 4; /* Blue */
                break;
            case 72:
                PICTColour = 5; /* Cyan */
                break;
            case 92:
                PICTColour = 6; /* Magenta */
                break;
            case 67:
                PICTColour = 7; /* Yellow */
                break;
            case -1:
                PICTColour = 0; /* Black */
                break;
            default:
                PICTColour = 0; /* Black */
                break;
            }
        return PICTColour;
}

