static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <assert.h>

#include "XmgfMalloc.h"

#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <X11/IntrinsicP.h>
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "ViewType.h"
#include "callbacks.h"
#include "Orth.h"
#include "Perspec.h"
#include "Stereo.h"
#include "Mouse.h"
#include "GUI.h"
#include "Parse.h"
#include "BackDrop.h"
#include "3Droutines.h"
#include "XmgfEvent.h"
#include "XmgfFont.h"

/* Font define stuff */
int FontClass=ADOBE;
int FontFamily=HELVETICA;
int FontWeight=BOLD;
int FontSlant=NOITALIC;
int FontSize=10;
int FontColour=0;


char *fontclass[CLASS]={
        "adobe"
};
char *family[FAMILY] ={
        "courier","helvetica","new century schoolbook","symbol","times"
};
char *weight[WEIGHT]={
        "*","bold","medium"
};
char *slant[SLANT]={
        "*","o","r"
};

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetView(ViewType)
int ViewType;
{
	if (ViewType == 1)
		viewtype = 0;
	else
		viewtype = 1;
	XtDestroyWidget(ViewManager);

	switch (viewtype) {
	    case VIEW_PERS:{
		create_Perspective_widget(graphicspane, DrawingAreaWidth/2,DrawingAreaHeight/2);
		create_Perspective_window();
			break;
		}
	    case VIEW_ORTH:{
		create_Ortho_widgets(graphicspane, DrawingAreaWidth,DrawingAreaHeight);
		create_Ortho_window();
			break;
		}
	    case VIEW_STEREO:{
		create_Stereo_widgets(graphicspane, DrawingAreaWidth/2,DrawingAreaHeight/2);
		create_Stereo_window();
			break;
		}
	}

	if (viewtype == 1) {
		ScaleNumber = ScaleNumber / 2;
		Midx = DrawingAreaWidth/2;
		Midy = DrawingAreaHeight/2;

	}
	if (viewtype == 0) {
		ScaleNumber = ScaleNumber * 2;
		Midx = DrawingAreaWidth/2;
		Midy = DrawingAreaHeight/2;
	}
	Scale_factor = LogScale(ScaleNumber);
	SetScale();
	Redraw();
	return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
create_Perspective_widget(parent, XSize,YSize)
Widget parent;
int XSize;
int YSize;
{
	/* set up windows */
	Arg args[10];
	int n;

	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	ViewManager = XtCreateManagedWidget("ViewManager",
		xmFormWidgetClass, parent, args, n);

	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;

	Orthdr = XmCreateDrawingArea(ViewManager, "Orthdr", args, n);
	XtAddEventHandler(Orthdr, 
		Button1MotionMask| Button2MotionMask |Button3MotionMask |
		PointerMotionMask| ExposureMask | ButtonPressMask | 
		ButtonReleaseMask | KeyPressMask | ResizeRedirectMask | EnterWindowMask , False, 
		(XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtManageChild(Orthdr);
	return ;
}

void
create_Perspective_window()
{
	XGCValues gcv;
	XtGCMask gc_mask;

        while (!XtIsRealized(toplevel)) {
	XtRealizeWidget(toplevel);
        }
        XtCreateWindow(Orthdr, InputOutput, CopyFromParent, 0L,0);
        w_Orth = XtWindow(Orthdr);
        /* create the GC */
        gc_mask = GCForeground | GCBackground | GCFunction
                | GCLineWidth | GCCapStyle | GCFillStyle ;
        gcv.foreground = BlackPixel(theDisplay, theScreen);
        gcv.background = WhitePixel(theDisplay, theScreen);
        gcv.line_width = 1;
        gcv.function = GXcopy;
        gcv.cap_style = CapRound;
        gcv.fill_style = FillSolid;
        theGC = XCreateGC(theDisplay, w_Orth, gc_mask, &gcv);
        InitTiles();

        /* Set Font Type */
        XmgfSetFont();

        XFlush(theDisplay);
	return; 
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
create_Stereo_widgets(parent, XSize,YSize)
Widget parent;
int XSize;
int YSize;
{
	/* set up windows */
	Arg args[10];
	int n;

	n=0;
	XtSetArg(args[n], XmNheight, 2 * YSize + 20);n++;
	XtSetArg(args[n], XmNwidth, 2 * XSize + 20);n++;
	ViewManager = XtCreateManagedWidget("ViewManager",
		xmFormWidgetClass, parent, args, n);

	/* Drawing Region */
	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_NONE);n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
        XtSetArg(args[n], XmNborderWidth, 1); n++;
        XtSetArg(args[n], XmNmarginWidth, 3); n++;
        XtSetArg(args[n], XmNmarginHeight, 3); n++;
	Orthdr = XmCreateDrawingArea(ViewManager, "Orthdr", args, n);

	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNleftWidget, Orthdr);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
        XtSetArg(args[n], XmNborderWidth, 1); n++;
        XtSetArg(args[n], XmNmarginWidth, 3); n++;
        XtSetArg(args[n], XmNmarginHeight, 3); n++;
	Rightdr = XmCreateDrawingArea(ViewManager, "Rightdr", args, n);

	XtAddEventHandler(Orthdr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask | EnterWindowMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtAddEventHandler(Rightdr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask | EnterWindowMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtManageChild(Orthdr);
	XtManageChild(Rightdr);
	return ;
}

void
create_Stereo_window()
{
	XGCValues gcv;
        XtGCMask gc_mask;

	while (!XtIsRealized(toplevel)) {
	XtRealizeWidget(toplevel);
	}
	XtCreateWindow(Orthdr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Rightdr, InputOutput, CopyFromParent, 0L, 0);
	w_Orth = XtWindow(Orthdr);
	w_Right = XtWindow(Rightdr);
	/* create the GC */
        gc_mask = GCForeground | GCBackground | GCFunction
                | GCLineWidth | GCCapStyle | GCFillStyle ;
        gcv.foreground = BlackPixel(theDisplay, theScreen);
        gcv.background = WhitePixel(theDisplay, theScreen);
        gcv.line_width = 1;
        gcv.function = GXcopy;
        gcv.cap_style = CapRound;
        gcv.fill_style = FillSolid;
	theGC = XCreateGC(theDisplay, w_Orth, gc_mask, &gcv);
        InitTiles();

	XmgfSetFont();
	XFlush(theDisplay);
	return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
create_Ortho_widgets(parent, XSize , YSize)
Widget parent;
int XSize;
int YSize;
{
	/* set up windows */
	Arg args[10];
	int n;

/*	Size = 256;*/
	XtSetArg(args[0], XmNheight, (2 * YSize) + 20);
	XtSetArg(args[1], XmNwidth, (2 * XSize) + 20);
	ViewManager = XtCreateManagedWidget("ViewManager",
		xmFormWidgetClass, parent, args, 2);
	/* main button window */
	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
        XtSetArg(args[n], XmNborderWidth, 1); n++;
        XtSetArg(args[n], XmNmarginWidth, 3); n++;
        XtSetArg(args[n], XmNmarginHeight, 3); n++;
	Plandr = XmCreateDrawingArea(ViewManager, "Plandr", args, n);

	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNleftWidget, Plandr);n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
        XtSetArg(args[n], XmNborderWidth, 1); n++;
        XtSetArg(args[n], XmNmarginWidth, 3); n++;
        XtSetArg(args[n], XmNmarginHeight, 3); n++;
	Sidedr = XmCreateDrawingArea(ViewManager, "Sidedr", args, n);

	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNtopWidget, Plandr);n++;
        XtSetArg(args[n], XmNborderWidth, 1); n++;
        XtSetArg(args[n], XmNmarginWidth, 3); n++;
        XtSetArg(args[n], XmNmarginHeight, 3); n++;
	Frntdr = XmCreateDrawingArea(ViewManager, "Frntdr", args, n);

	n=0;
	XtSetArg(args[n], XmNheight, YSize);n++;
	XtSetArg(args[n], XmNwidth, XSize);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNleftWidget, Frntdr);n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNtopWidget, Sidedr);n++;
        XtSetArg(args[n], XmNborderWidth, 1); n++;
        XtSetArg(args[n], XmNmarginWidth, 3); n++;
        XtSetArg(args[n], XmNmarginHeight, 3); n++;
	Orthdr = XmCreateDrawingArea(ViewManager, "Orthdr", args, n);

	XtAddEventHandler(Orthdr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask | EnterWindowMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtAddEventHandler(Plandr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask | EnterWindowMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtAddEventHandler(Sidedr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask | EnterWindowMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtAddEventHandler(Frntdr,
                Button1MotionMask| Button2MotionMask |Button3MotionMask |
                PointerMotionMask| ExposureMask | ButtonPressMask |
                ButtonReleaseMask | KeyPressMask | EnterWindowMask, False,
                (XtEventHandler) XmgfEvent, (caddr_t) NULL);
	XtManageChild(Plandr);
	XtManageChild(Sidedr);
	XtManageChild(Frntdr);
	XtManageChild(Orthdr);
	return;
}

void 
create_Ortho_window()
{
	XGCValues gcv;
        XtGCMask gc_mask;
	while (!XtIsRealized(toplevel)) {
	XtRealizeWidget(toplevel);
	}
	XtCreateWindow(Plandr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Sidedr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Frntdr, InputOutput, CopyFromParent, 0L, 0);
	XtCreateWindow(Orthdr, InputOutput, CopyFromParent, 0L, 0);
	w_Plan = XtWindow(Plandr);
	w_Side = XtWindow(Sidedr);
	w_Frnt = XtWindow(Frntdr);
	w_Orth = XtWindow(Orthdr);
	/* create the GC */

         gc_mask = GCForeground | GCBackground | GCFunction
                | GCLineWidth | GCCapStyle | GCFillStyle ;
        gcv.foreground = BlackPixel(theDisplay, theScreen);
        gcv.background = WhitePixel(theDisplay, theScreen);
        gcv.line_width = 1;
        gcv.function = GXcopy;
        gcv.cap_style = CapRound;
        gcv.fill_style = FillSolid;
        theGC = XCreateGC(theDisplay, w_Orth, gc_mask, &gcv);
        InitTiles();
	XmgfSetFont();
	XFlush(theDisplay);
	return ;
}


void
XmgfSetFont()
{
	static int FontProblems=0;
	XFontStruct *FontID;
	char *fontname;

	fontname = (char *) XmgfMalloc(100*sizeof(char*));
	assert(fontname);
	if(FontFamily==SYMBOL) { FontWeight=MEDIUM;
				 FontSlant= NOITALIC; }
	sprintf(fontname,"-%s-%s-%s-%s-*-*-%d-*", 
		fontclass[FontClass],family[FontFamily],
		weight[FontWeight],slant[FontSlant],FontSize);
	FontID = XLoadQueryFont(theDisplay, fontname);
	if(FontID==NULL) { 
		if(FontProblems==0){
	        fprintf(stderr,"Font %s Not Found:-Using Default\n",fontname);
	        fprintf(stderr,"Warning You will not be notified further ");
	        fprintf(stderr,"of font Problems!\n");
		}
		FontProblems=1;
		fontname="-adobe-helvetica-*-r-*-*-10-*";	
		FontID = XLoadQueryFont(theDisplay, fontname);
		
		}
	if (FontID!=NULL) XSetFont(theDisplay, theGC, FontID->fid);
	else  {
	       if(FontProblems==0){
	       fprintf(stderr,"Font Error No Font found!\n");
	       fprintf(stderr,"Warning You will not be notified further ");
	       fprintf(stderr,"of font Problems!\n");
	       }
	}
	XmgfFree(fontname);
}

void
FNTNCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	FontFamily=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

void
FNTWCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        FontWeight=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

void
FNTICB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        FontSlant=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

void
FNTSCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        FontSize=(int)client_data;
	XmgfFontChange();
	XmgfSetFont();
}

int
GetFontNumber(FontName)
char *FontName;
{

	if (!strcasecmp(FontName,"courier")) return COURIER;
	if (!strcasecmp(FontName,"helvetica")) return HELVETICA;
	if (!strcasecmp(FontName,"newcensch")) return NEWCENSCH;
	if (!strcasecmp(FontName,"new century schoolbook")) return NEWCENSCH;
	if (!strcasecmp(FontName,"symbol")) return SYMBOL;
	if (!strcasecmp(FontName,"times")) return TIMES;
	else return HELVETICA;
}

int
GetFontWeight(Weight)
char *Weight;
{
        if (!strcasecmp(Weight,"bold")) return BOLD;
        if (!strcasecmp(Weight,"normal")) return MEDIUM;
        if (!strcasecmp(Weight,"medium")) return MEDIUM;
        if (!strcasecmp(Weight,"noblod")) return MEDIUM;
        else return MEDIUM;

}

int
GetFontSlant(Slant)
char *Slant;
{
        if (!strcasecmp(Slant,"italic")) return ITALIC;
        if (!strcasecmp(Slant,"normal")) return NOITALIC;
        if (!strcasecmp(Slant,"regular")) return NOITALIC;
        if (!strcasecmp(Slant,"noitalic")) return NOITALIC;
        else return NOITALIC;

}


