static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "GUI.h"
#include "Menus.h"
#include "Mouse.h"
#include "callbacks.h"
#include "Parse.h"

void XmgfResize();


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
XmgfEvent(w, closure, Xmgfevent, done)
Widget  w;
XtPointer closure;
XEvent *Xmgfevent;
int    *done;
{
  static int CurrentButton = 0;
  static int Events =0;
  static int CompressedExposes=0;

#ifndef NOCOLLAPSEEVENTS
  if (Xmgfevent->type==Expose){
  Events = XPending(theDisplay); 
  while(XCheckTypedWindowEvent(theDisplay,w_Orth,Expose,Xmgfevent)){
        CompressedExposes=1;
  }
  Events = XPending(theDisplay); 
  }
#endif

  switch (Xmgfevent->type) {
   case Expose:{
#ifndef BLIT_EXPOSES
      UpDateVisibleCB(w, (caddr_t)NULL, (caddr_t)NULL);
#else

#ifndef EXPOSEWHOLEAREA
      XExposeEvent *exp_event = (XExposeEvent*)Xmgfevent;
      int  x, y;
      int  width, height;

      if(!CompressedExposes){
      x = exp_event->x;
      y = exp_event->y;
      width = exp_event->width;
      height = exp_event->height;
      RestoreScreenArea(w_Orth,x,y,width,height);
      }
      else { 
	RestoreScreen(w_Orth);
	CompressedExposes=0;
      }
#else
      RestoreScreen(w_Orth);
#endif
#endif
    }
    break;
   case ButtonPress:{
      XButtonEvent *but_event = (XButtonEvent *) Xmgfevent;
      int     x, y;
      Window  win;

      win = but_event->window;
      x = but_event->x;
      y = but_event->y;

      switch (but_event->button) {
       case Button1:
	PointerSelectSetCB(w, (caddr_t)NULL, (caddr_t)NULL);
	CurrentButton = 1;
	break;
       case Button2:
	CurrentButton = 2;
	break;
       case Button3:
	CurrentButton = 3;
	break;
       default:
	CurrentButton = 0;
	break;
      }
    }
    break;
   case ButtonRelease:{
      XButtonEvent *but_event = (XButtonEvent *) Xmgfevent;
      int     x, y;
      Window  win;

      win = but_event->window;
      x = but_event->x;
      y = but_event->y;
      switch (but_event->button) {
       case Button1:
	CurrentButton = 0;
	break;
       case Button2:
	CurrentButton = 0;
	UpDateVisibleCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
       case Button3:
	CurrentButton = 0;
	UpDateVisibleCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
       default:
	CurrentButton = 0;
	break;
      }
    }
    break;
   case MotionNotify:{
      XButtonEvent *but_event = (XButtonEvent *) Xmgfevent;
      switch (CurrentButton) {
       case 1:
	CurrentButton = 1;
	break;
       case 2:
	CurrentButton = 2;
	UpdatePositionCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
       case 3:
	CurrentButton = 3;
	UpdateScaleCB(w, (caddr_t)NULL, (caddr_t)but_event);
	break;
       default:
	CurrentButton = 0;
	UpdateXYCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
      }
    }
    break;
   case ResizeRequest:{
	fprintf(stderr,"Resize Request Made\n");
    } 
    break;
   case EnterNotify:{
        XmgfMessage("1st Button Select, 2nd Button XY Move, 3rd Button Rotate");
	break;
   }
   case    FocusIn:{
	break;
   }
   case    FocusOut:{
	break;
   }
   case KeyPress:{
        XmgfMessage("KeyPressed:");
   }
   break;
   default:
    break;			/* ignore unexpected events */
  }
}

void
XmgfEventList(w, closure, Xmgfevent, done)
Widget  w;
XtPointer closure;
XEvent *Xmgfevent;
int    *done;
{
  	switch (Xmgfevent->type) {
 	case ButtonPress:{
         XButtonEvent *but_event = (XButtonEvent *) Xmgfevent;

         switch (but_event->button) {
          case Button1:
	   SetCB(w,(caddr_t)SELECTSET,(caddr_t)NULL);
           break;
          case Button2:
	   SetCB(w,(caddr_t)SELECTSET,(caddr_t)NULL);
	   SetCB(w,(caddr_t)ARDEL,(caddr_t)NULL);
           break;
          case Button3:
	   SetCB(w,(caddr_t)SELECTSET,(caddr_t)NULL);
	   SetCB(w,(caddr_t)ARDRAW,(caddr_t)NULL);
           break;
          default:
           break;
         }
	   break;
	}
	case EnterNotify:{
        XmgfMessage("1st Button Select, 2nd Button Delete, 3rd Button Draw");
	break;
	}
	default: break;
	}
}
/*#define WINDIFF 205*/
#define WINDIFF 210
void 
XmgfWindowEvent(w, closure, Xmgfevent, done)
Widget  w;
XtPointer closure;
XEvent *Xmgfevent;
int    *done;
{
	
        switch (Xmgfevent->type) {
	case ConfigureNotify:{
			XmgfResize();
  	}
  	break;
  	}
}

void
XmgfResize()
{
	int PosX,PosY,n;
        unsigned int WinWidth,WinHeight,BorderWidth,WinDepth;
        Window Root;
        Arg args[5];
        int VerticalNum,HorizontalNum,NumofIcons;
        static int NewWidth = 512;
	static OldWidth=0;
	static OldHeight=0;

	XGetGeometry(theDisplay,XtWindow(toplevel),
		&Root,&PosX,&PosY,&WinWidth,&WinHeight,&BorderWidth,&WinDepth);
	if (OldWidth!=WinWidth || OldHeight!=WinHeight) { 

	if (!ICONPANEL)
        {
        DrawingAreaHeight = WinHeight-WINDIFF;
        DrawingAreaWidth = WinWidth-30;
        }
else
        {
        DrawingAreaHeight = WinHeight-WINDIFF;
        DrawingAreaWidth = NewWidth;
        /*-------------------------oOo----------------------------------*/
        /* Developer Note                                               */
        /* Resize code works roughly for 1.2.X but not for 1.1.X so I'm */
        /* making it a compile switch for now.                          */
        /*-------------------------oOo----------------------------------*/
        /* Rearranging the icon panel */
        NumofIcons = 45;
        VerticalNum = (int)((float)DrawingAreaHeight/35.0);
        HorizontalNum = ((float)NumofIcons / (float)VerticalNum );
        HorizontalNum = XmgfCeiling(HorizontalNum);
        XtSetArg(args[0], XmNnumColumns, VerticalNum);
        XtSetValues(IconRowCol, args, 1);
        NewWidth = (WinWidth-((2+HorizontalNum)*38));
        DrawingAreaWidth = NewWidth;
        }
  n=0;
  XtSetArg(args[n], XmNwidth, DrawingAreaWidth);n++;
  XtSetArg(args[n], XmNheight, DrawingAreaHeight);n++;
  XtSetValues(ViewManager, args, n);
  DestroyBuff();
#ifdef BLIT_EXPOSES
  DestroySaveScreen();
#endif

  switch (viewtype) {
   case VIEW_ORTH:{
      n=0;
      XtSetArg(args[n], XmNwidth, DrawingAreaWidth/2);n++;
      XtSetArg(args[n], XmNheight, DrawingAreaHeight/2);n++;
      XtSetValues(Plandr, args, n);
      XtSetValues(Sidedr, args, n);
      XtSetValues(Orthdr, args, n);
      XtSetValues(Frntdr, args, n);
      CreateBuff(w_Orth, DrawingAreaWidth/2, DrawingAreaHeight/2);
      Midx = DrawingAreaWidth/4;
      Midy = DrawingAreaHeight/4;
      break;
    }
   case VIEW_STEREO:{
      n=0;
      XtSetArg(args[n], XmNwidth, DrawingAreaWidth/2);n++;
      XtSetArg(args[n], XmNheight, DrawingAreaHeight/2);n++;
      XtSetValues(Orthdr, args, n);
      XtSetValues(Rightdr, args, n);
      CreateBuff(w_Orth, DrawingAreaWidth/2, DrawingAreaHeight/2);
      Midx = DrawingAreaWidth/4;
      Midy = DrawingAreaHeight/4;
      break;
    }
   default:{
      n=0;
      XtSetArg(args[n], XmNwidth, DrawingAreaWidth);n++;
      XtSetArg(args[n], XmNheight, DrawingAreaHeight);n++;
      XtSetValues(Orthdr, args, n);
      CreateBuff(w_Orth, DrawingAreaWidth, DrawingAreaHeight);
      Midx = DrawingAreaWidth/2;
      Midy = DrawingAreaHeight/2;
      break;
    }
  }
  AutoScaleCMD();
  }
  OldWidth=WinWidth;
  OldHeight=WinHeight;
  return;
}
